/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.event;

import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.topic.TopicConnection;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventListener;
import java.util.HashMap;
import java.util.Properties;

public class WfEventProxy {
    private static final long serialVersionUID = 6861641437579019890L;
    private Destination destination;
    private transient TopicConnection conn;
    private String clientId;
    protected final WfEngine engine;

    public WfEventProxy(WfEngine engine, String clientId) {
        this.destination = engine.getMessageManager().getWfDestination();
        this.clientId = clientId;
        this.engine = engine;
    }

    public boolean subscribeEventMessge(String subscribeId, String eventTypeName, final WfEventListener wfel) throws WfException {
        if (this.destination == null) {
            throw new WfException("No Workflow Engine Destination found");
        }
        HashMap<String, String> selector = new HashMap<String, String>();
        if (eventTypeName != null) {
            selector.put("eventType", eventTypeName);
        }
        try {
            if (this.destination.getDriverClassName().equals("com.kingdee.bos.service.message.jms.topic.JMSTopicDriver")) {
                if (this.conn == null) {
                    Properties prop = new Properties();
                    prop.setProperty("clientId", this.clientId);
                    this.conn = (TopicConnection)this.destination.getConnection(prop);
                }
            } else {
                throw new WfException("Not support 'Subscribe' In this kind of message destination!");
            }
            this.conn.subscribeDurable(subscribeId, "kingdee.bos.workflow.", selector, new MessageListener(){

                public int onMessage(Message message) {
                    WfEvent event = WfEvent.FromMessage(WfEventProxy.this.engine, message);
                    wfel.onEvent(event);
                    return 1;
                }
            });
        }
        catch (MessageException ex) {
            throw new WfException("meet MessageException while ...", (Throwable)ex);
        }
        return true;
    }

    public void unsubscribeEventMessage(String subscribeId) throws WfException {
        if (this.destination == null) {
            throw new WfException("No Workflow Engine Destination found");
        }
        if (this.destination.getDriverClassName().equals("com.kingdee.bos.service.message.jms.topic.JMSTopicDriver")) {
            try {
                if (this.conn == null) {
                    Properties prop = new Properties();
                    prop.setProperty("clientId", this.clientId);
                    this.conn = (TopicConnection)this.destination.getConnection(prop);
                }
                this.conn.unSubscribeDurable(subscribeId);
                this.conn.close();
            }
            catch (MessageException ex) {
                throw new WfException("meet MessageException ...", (Throwable)ex);
            }
        } else {
            throw new WfException("Not support 'Subscribe' In this kind of message destination!");
        }
    }
}

