/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.autoapprove;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalNextActDef;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalUtil;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoApproveForwardUtil {
    protected static final Logger logger = Logger.getLogger(AutoApproveForwardUtil.class);

    public boolean autoApproveForward(List<?> participants, WfActivity act, Execution<? extends Node> execu) {
        try {
            TransitionDef trans = this.getPostTransDef(participants, act, execu);
            if (trans == null) {
                return false;
            }
            this.skipCurrentActivity(execu, trans);
        }
        catch (Exception e) {
            logger.error((Object)(act.getId() + " autoApproveForward error"), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isOneParticipant(List<?> participants) {
        if (participants == null || participants.size() == 0) {
            return false;
        }
        int countPerson = 0;
        String tempPersonId = "";
        for (int index = 0; index < participants.size(); ++index) {
            Person person = (Person)participants.get(index);
            String personId = person.getEmployeeId();
            if (personId.equals(tempPersonId)) continue;
            tempPersonId = personId;
            ++countPerson;
        }
        return countPerson == 1;
    }

    private TransitionDef getPostTransDef(List<?> participants, WfActivity currentAct, Execution<? extends Node> execu) throws WfException {
        WfProcess process;
        ProcessDef processDef;
        if (!this.isOneParticipant(participants)) {
            return null;
        }
        Person person = (Person)participants.get(0);
        String personId = person.getEmployeeId();
        if (personId == null || personId.length() == 0) {
            return null;
        }
        Flow flow = execu.getContext().getFlow();
        List<ActivityDef> tempList = CalUtil.getPostActDefs(currentAct, flow, processDef = currentAct.getProcess().getDefinition(), process = (WfProcess)currentAct.getProcess());
        if (tempList == null || tempList.size() == 0) {
            return null;
        }
        HashSet<String> postIds = new HashSet<String>();
        ArrayList<ActivityDef> postDefs = new ArrayList<ActivityDef>();
        for (ActivityDef def : tempList) {
            if (def.getID().equals(currentAct.getDefinition().getID())) continue;
            postIds.add(def.getID());
            postDefs.add(def);
        }
        boolean hasSamePerson = this.isHasSamePerson(currentAct, personId, postDefs);
        if (hasSamePerson) {
            TransitionCollection outTransColl = currentAct.getDefinition().getOutgoingTransitions();
            ActivityDef nextDef = (ActivityDef)postDefs.get(0);
            TransitionCollection inTransColl = nextDef.getIncomingTransitions();
            for (int i = 0; i < outTransColl.size(); ++i) {
                TransitionDef out = outTransColl.get(i);
                for (int j = 0; j < inTransColl.size(); ++j) {
                    TransitionDef in = inTransColl.get(j);
                    if (!out.getID().equals(in.getID())) continue;
                    if (this.recheckCondition(out, processDef, process)) {
                        return out;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private boolean recheckCondition(TransitionDef out, ProcessDef processDef, WfProcess process) {
        CalNextActDef cal = new CalNextActDef(null, null, null, null, processDef, null, null, null);
        boolean match = false;
        try {
            match = cal.evalConditionProc(out, process, false);
            if (!match) {
                match = cal.evalConditionProc(out, process, true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"recheckCondition error", (Throwable)e);
        }
        return match;
    }

    private boolean isHasSamePerson(WfActivity currentAct, String personId, List<ActivityDef> postDefs) throws WfException {
        boolean hasSamePerson = false;
        ProcessContext processContext = ((WfProcess)currentAct.getProcess()).getProcessContext();
        block0: for (ActivityDef actdef : postDefs) {
            String key;
            ArrayList personList;
            if (!(actdef instanceof ApproveActivityDef) || ((personList = (ArrayList)processContext.getDataFieldValue(key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)actdef))) == null || personList.size() == 0) && ((personList = (ArrayList)processContext.getDataFieldValue(key = this.getForwardPerformerKey(actdef))) == null || personList.size() == 0)) continue;
            for (int index = 0; index < personList.size(); ++index) {
                if (personList.get(index) == null || !personId.equals(personList.get(index).toString())) continue;
                hasSamePerson = true;
                continue block0;
            }
        }
        return hasSamePerson;
    }

    private String getForwardPerformerKey(ActivityDef activityDef) {
        ProcessDef procdef = (ProcessDef)activityDef.getContainer();
        return "AUTOFORWARD_" + procdef.getHashValue() + "@" + activityDef.getID().toString();
    }

    private void skipCurrentActivity(Execution<? extends Node> e, TransitionDef tTransitionDef) {
        ExecutionImpl eImpl = (ExecutionImpl)e;
        eImpl.seek(502000000);
        eImpl.getContext().enqueue(eImpl);
        Flow flow = e.getContext().getFlow();
        TransitionImpl transition = (TransitionImpl)flow.getTransition(tTransitionDef.getID());
        Utils.transit((ExecutionImpl)eImpl, (TransitionImpl)transition);
    }
}

