/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.cal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityState;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiaActivityType;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramParticipant;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalProcDiagram;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CalParticipant {
    private WfProcess process;
    private WfEngine engine;
    private String procDefHash;
    private Context ctx;
    protected static final Logger logger = Logger.getLogger(CalProcDiagram.class);

    public CalParticipant(WfEngine engine, String procDefHash, WfProcess process, Context ctx) {
        this.engine = engine;
        this.procDefHash = procDefHash;
        this.process = process;
        this.ctx = ctx;
    }

    public void calParticipantForAcitivitys(List<DiagramActivity> diaActList) throws WfException {
        try {
            WfEngine wfengine = WfEngine.getEngine(this.ctx);
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            IParticipantProvider participantProvider = this.engine.getPariticipantProvider();
            for (int index = 0; index < diaActList.size(); ++index) {
                try {
                    DiagramActivity tDiagramActivity = diaActList.get(index);
                    ActivityDef actDef = tDiagramActivity.getActDef();
                    if (!this.isNeedCalParticipantActivity(tDiagramActivity.getDiaActivityType())) continue;
                    if (tDiagramActivity.getDiaActivityType().equals(DiaActivityType.MESSAGENODE)) {
                        this.getMessageNodeParticipants(svc, tDiagramActivity, actDef);
                        continue;
                    }
                    ArrayList<DiagramParticipant> diagramParticipants = new ArrayList<DiagramParticipant>();
                    String activityId = tDiagramActivity.getActivityId();
                    if (StringUtils.isEmpty((String)activityId)) {
                        this.getNoStartActivityParticipant(this.ctx, svc, tDiagramActivity, actDef, diagramParticipants);
                    } else {
                        this.getCompleteActivityPartic(this.ctx, svc, participantProvider, diagramParticipants, activityId, tDiagramActivity.getActState());
                    }
                    tDiagramActivity.setDiagramParticList(diagramParticipants);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"\u8ba1\u7b97\u53c2\u4e0e\u4eba\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                }
            }
        }
        catch (BOSException e) {
            throw new WfException("\u8ba1\u7b97\u53c2\u4e0e\u4eba\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    private void getMessageNodeParticipants(IEnactmentService svc, DiagramActivity tDiagramActivity, ActivityDef actDef) throws WfException {
        List messagePerson = null;
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = ((MessageActivityDef)actDef).getReceivers();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        messagePerson = svc.getPersonsByDefParticipants(this.procDefHash, tDiagramActivity.getActDefId(), pList, this.ctx.getCaller().toString());
        messagePerson = CalParticipant.distinctPersons(messagePerson, this.ctx.getLocale());
        ArrayList<DiagramParticipant> diagramParticipants = new ArrayList<DiagramParticipant>();
        for (Person person : messagePerson) {
            DiagramParticipant diagramParticipant = new DiagramParticipant(WfAssignmentState.COMPLETED, person, null);
            diagramParticipants.add(diagramParticipant);
        }
        tDiagramActivity.setDiagramParticList(diagramParticipants);
    }

    private boolean isNeedCalParticipantActivity(DiaActivityType tDiaActivityType) {
        if (DiaActivityType.MANPOWERNODE.equals(tDiaActivityType)) {
            return true;
        }
        if (DiaActivityType.APPROVENODE.equals(tDiaActivityType)) {
            return true;
        }
        if (DiaActivityType.MANUALDECISIONNODE.equals(tDiaActivityType)) {
            return true;
        }
        if (DiaActivityType.SUBFLOWNODE.equals(tDiaActivityType)) {
            return false;
        }
        if (DiaActivityType.APPENDNODE.equals(tDiaActivityType)) {
            return true;
        }
        return DiaActivityType.MESSAGENODE.equals(tDiaActivityType);
    }

    private void getNoStartActivityParticipant(Context ctx, IEnactmentService svc, DiagramActivity tDiagramActivity, ActivityDef actDef, List<DiagramParticipant> diagramParticipants) throws WfException {
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = ((ManpowerActivityDef)actDef).getParticipants();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        List personList = null;
        if (this.process != null) {
            personList = this.designatePerformer(svc, actDef);
            if (personList.size() == 0) {
                personList = svc.getPersonsByParticipantsNew(this.process.getId(), (ActivityDef)((ManpowerActivityDef)tDiagramActivity.getActDef()), pList);
            }
        } else {
            personList = svc.getPersonsByDefParticipants(this.procDefHash, tDiagramActivity.getActDefId(), pList, ctx.getCaller().toString());
        }
        personList = CalParticipant.distinctPersons(personList, ctx.getLocale());
        for (int personIndex = 0; personIndex < personList.size(); ++personIndex) {
            diagramParticipants.add(new DiagramParticipant(null, (Person)personList.get(personIndex), null));
        }
    }

    private List designatePerformer(IEnactmentService svc, ActivityDef actDef) throws WfException, WfParticipantException {
        String key1 = ParticipantUtils.createDesignatePerformerKey((ActivityDef)actDef);
        Object dataFieldValue = svc.getProcessContext(this.process.getId(), key1);
        ArrayList<Person> result = new ArrayList<Person>();
        if (dataFieldValue != null && dataFieldValue instanceof List && ((List)dataFieldValue).size() > 0) {
            List dpl = (List)dataFieldValue;
            IParticipantProvider provider = this.engine.getPariticipantProvider();
            HashMap<String, String> mapPerson = new HashMap<String, String>();
            for (String personId : dpl) {
                Person[] persons = provider.getPersonByEmployeeId(this.ctx, personId);
                if (persons == null || persons.length == 0) {
                    persons = new Person[]{provider.getPersonByUserId(this.ctx, personId)};
                }
                for (int i = 0; i <= persons.length - 1; ++i) {
                    String key;
                    if (persons[i] == null || StringUtils.isEmpty((String)persons[i].getUserId()) || mapPerson.containsKey(key = persons[i].getUserId() + "_" + persons[i].getEmployeeId())) continue;
                    mapPerson.put(key, key);
                    result.add(persons[i]);
                }
            }
        }
        return result;
    }

    private static ArrayList distinctPersons(List persons, Locale locale) {
        LinkedHashMap<String, Person> mapPerson = new LinkedHashMap<String, Person>();
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            Person person = (Person)persons.get(i);
            String key = person.getUserName(locale);
            if (mapPerson.containsKey(key)) continue;
            mapPerson.put(key, person);
        }
        return new ArrayList(mapPerson.values());
    }

    private void getCompleteActivityPartic(Context ctx, IEnactmentService svc, IParticipantProvider participantProvider, List<DiagramParticipant> diagramParticipants, String activityId, DiaActivityState diaActivityState) throws WfException, WfParticipantException {
        AssignmentInfo[] assignments = svc.getAllAssignmentByActInstId(activityId);
        if (assignments.length > 0) {
            if (diaActivityState == DiaActivityState.CLOSEBACK || diaActivityState == DiaActivityState.CLOSEJUMP) {
                String sql = "select FCREATORID from t_bas_option where FCURRENTACINSTID=? and (ftype=0 or ftype=1)";
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{activityId});
                    if (rowSet.next()) {
                        Person person = svc.getPersonByUserID(rowSet.getString(1));
                        diagramParticipants.add(new DiagramParticipant(WfAssignmentState.COMPLETED, person, null));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                for (int assinIndex = 0; assinIndex < assignments.length; ++assinIndex) {
                    AssignmentInfo tAssignmentInfo = assignments[assinIndex];
                    Person tPerson = new Person();
                    tPerson.setUserId(tAssignmentInfo.getUserId());
                    tPerson.setUserName(ctx.getLocale(), tAssignmentInfo.getUserName(ctx.getLocale()));
                    tPerson.setEmployeeId(tAssignmentInfo.getEmployeeId());
                    tPerson.setEmployeeName(ctx.getLocale(), tAssignmentInfo.getEmployeeName(ctx.getLocale()));
                    diagramParticipants.add(new DiagramParticipant(tAssignmentInfo.getState(), tPerson, null));
                }
            }
        } else {
            ManpowerActivityDef activitydef = (ManpowerActivityDef)svc.getActDefByActInstInfo(svc.getActivityInstByActInstId(activityId));
            Person tPerson = null;
            if (this.process != null && activitydef.isFirstManpowerActivity()) {
                tPerson = participantProvider.getPersonByUserId(ctx, this.process.getProcessMeta().getInitiatorId());
                if (tPerson.getUserId() == null) {
                    String sqlString = "select u.fid as userId,u.fname_l1 as userName_l1 ,u.fname_l2 as userName_l2,u.fname_l3 as userName_l3,p.fid as employeeId ,p.fname_l1 as employeeName_l1,p.fname_l2  as employeeName_l2,p.fname_l3  as employeeName_l3 from t_pm_user u left join t_bd_person p on u.fpersonid = p.fid where u.fid = ?";
                    try {
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString, (Object[])new Object[]{this.process.getProcessMeta().getInitiatorId()});
                        if (rowSet.next()) {
                            tPerson.setUserId(rowSet.getString(1));
                            tPerson.setEmployeeId(rowSet.getString(5));
                            tPerson.setUserName(LocaleUtils.getLocale((String)"l1"), rowSet.getString(2));
                            tPerson.setUserName(LocaleUtils.getLocale((String)"l2"), rowSet.getString(3));
                            tPerson.setUserName(LocaleUtils.getLocale((String)"l3"), rowSet.getString(4));
                            tPerson.setEmployeeName(LocaleUtils.getLocale((String)"l1"), rowSet.getString(6));
                            tPerson.setEmployeeName(LocaleUtils.getLocale((String)"l2"), rowSet.getString(7));
                            tPerson.setEmployeeName(LocaleUtils.getLocale((String)"l3"), rowSet.getString(8));
                            diagramParticipants.add(new DiagramParticipant(WfAssignmentState.COMPLETED, tPerson, null));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    diagramParticipants.add(new DiagramParticipant(WfAssignmentState.COMPLETED, tPerson, null));
                }
            }
        }
    }
}

