/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.app.DefaultApplicationManager;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IAssignmentMonitorService;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssignmentMonitorService
extends AbstractBOSObject
implements IAssignmentMonitorService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFASTMOS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.AssignmentMonitorService");

    public static IAssignmentMonitorService getService(Context ctx) {
        return new AssignmentMonitorService(ctx);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public AssignmentMonitorService(Context ctx) {
        super(ctx);
        this.registerInterface(IAssignmentMonitorService.class, (Object)this);
    }

    public AssignmentInfo[] getAssignmentByProcInstId(String procInstId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentByProcInstId(procInstId);
    }

    public AssignmentInfo[] getAssignmentAllByProcInstId(String procInstId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentAllByProcInstId(procInstId);
    }

    public AssignmentInfo getAssignmentById(String assignId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentById been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: assignId=\"");
            buffer.append(assignId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assign = wfEngine.getAssignment(assignId);
        if (assign == null) {
            return null;
        }
        return assign.getMeta();
    }

    public AssignmentInfo[] getAssignmentById(String[] id, DataTypeEnum type) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentById been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: id=\"");
            buffer.append(StringUtils.arrayToString((Object[])id, (String)","));
            buffer.append('\"');
            buffer.append(" type=");
            buffer.append(type);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getWorkItemListByIds(id, type);
    }

    public AssignmentInfo[] getAssignmentByActInstId(String actInstId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentByActInstId been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: actInstId=\"");
            buffer.append(actInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentByActInstId(actInstId);
    }

    public AssignmentInfo[] getAllAssignmentByActInstId(String actInstId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAllAssignmentByActInstId been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: actInstId=\"");
            buffer.append(actInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAllAssignmentByActInstId(actInstId);
    }

    public AssignmentInfo[] getAssignmentByActInstId(String actInstId, WfAssignmentState state) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentByActInstId been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: actInstId=\"");
            buffer.append(actInstId);
            buffer.append('\"');
            buffer.append(" state=");
            buffer.append(state.getValue());
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        AssignmentInfo[] assignArray = wfEngine.getAssignmentByActInstId(actInstId);
        ArrayList<AssignmentInfo> list = new ArrayList<AssignmentInfo>(assignArray.length);
        for (int i = 0; i < assignArray.length; ++i) {
            if (!assignArray[i].getState().equals((Object)state)) continue;
            list.add(assignArray[i]);
        }
        AssignmentInfo[] rtnValue = new AssignmentInfo[list.size()];
        list.toArray(rtnValue);
        return rtnValue;
    }

    public AssignmentInfo[] getAssignmentByOwerId(String ownerId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentByOwerId been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: ownerId=\"");
            buffer.append(ownerId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentByOwerId(ownerId);
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId, WfAssignmentState assignmentState) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentByProcInstAndOwner been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" ownerId=\"");
            buffer.append(ownerId);
            buffer.append('\"');
            buffer.append(" assignmentState=");
            buffer.append(assignmentState.getValue());
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentByProcInstAndOwner(procInstId, ownerId, assignmentState);
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentByProcInstAndOwner been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" ownerId=\"");
            buffer.append(ownerId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentByProcInstAndOwner(procInstId, ownerId);
    }

    public Map getAssignmentArgument(String assignmentId, boolean isTransform) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:AssignmentMonitorService Method:getAssignmentArgument been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: assignmentId=\"");
            buffer.append(assignmentId);
            buffer.append('\"');
            buffer.append(" isTransform=");
            buffer.append(isTransform);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        return DefaultApplicationManager.getAssignmentArguments(EngineUtil.getEngine(this.getContext()), assignmentId, isTransform);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public AssignmentInfo getAssignmentById(String assignId, String[] selectors) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAssignmentInfo(assignId, selectors);
    }

    public AssignmentInfo[] getAssignmentById(String[] id, int type, String[] selectors) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getWorkItemListByIds(id, DataTypeEnum.getEnum((int)type), selectors);
    }

    public boolean allowForward(String[] assignmentsIds) throws WfException {
        if (assignmentsIds == null || assignmentsIds.length <= 0) {
            throw new WfException("AssignmentMonitorService allowForward: args assignmentIds can't be null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        boolean isAllow = false;
        for (int i = 0; i < assignmentsIds.length; ++i) {
            AssignmentInfo assignmentInfo = this.getAssignmentById(assignmentsIds[i]);
            String procInstId = assignmentInfo.getProcInstId();
            String actDefId = assignmentInfo.getActDefId();
            ProcessInstInfo processInstInfo = wfEngine.getProcessInst(procInstId).getData();
            ProcessDef processDef = null;
            processDef = wfEngine.getProcessDef(processInstInfo.getProcDefHashValue());
            if (processDef == null) {
                log.error((Object)("processinstance :" + procInstId + " The process define is not existing "));
                return false;
            }
            ActivityDef activityDef = processDef.getActivityDef(actDefId);
            if (!(activityDef instanceof ManpowerActivityDef)) {
                return false;
            }
            ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)activityDef;
            isAllow = manpowerActivityDef.getAllowAssignNextPerformer();
            if (!isAllow) break;
        }
        return isAllow;
    }

    public String getAllAssignFromRelationProcessInst(String assignmentID) throws WfException {
        ArrayList allAssignments = new ArrayList();
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment wfAssignment = wfEngine.getAssignment(assignmentID);
        String ancestorProcInstID = WorkflowUtils.getAncestorProcInstID(this.getContext(), wfAssignment.getProcInstId());
        ProcessInstInfo ancestorProcInstInfo = wfEngine.getProcessInst(ancestorProcInstID).getData();
        List allChildInsts = this.getAllProcessInstInfoByParentProcInstId(wfEngine, ancestorProcInstID);
        ProcessInstInfo[] childInfos = allChildInsts.toArray(new ProcessInstInfo[0]);
        ProcessInstInfo[] allProcInsts = new ProcessInstInfo[childInfos.length + 1];
        System.arraycopy(childInfos, 0, allProcInsts, 0, childInfos.length);
        allProcInsts[childInfos.length] = ancestorProcInstInfo;
        for (int i = 0; i < allProcInsts.length; ++i) {
            AssignmentInfo[] assignInfos = this.getAssignmentAllByProcInstId(allProcInsts[i].getProcInstId());
            this.fillCompletedAssign(allAssignments, assignInfos);
        }
        return this.constructAssignmentsSql(allAssignments);
    }

    private List getAllProcessInstInfoByParentProcInstId(WfEngine wfEngine, String ancestorProcInstID) throws WfException {
        ArrayList<Object> result = new ArrayList<Object>();
        ProcessInstInfo[] childInfos = wfEngine.getProcessInstancesByParentProcInstId(ancestorProcInstID);
        if (childInfos == null || childInfos.length == 0) {
            return result;
        }
        for (int i = 0; i < childInfos.length; ++i) {
            result.add(childInfos[i]);
            List infos = this.getAllProcessInstInfoByParentProcInstId(wfEngine, childInfos[i].getProcInstId());
            if (infos == null || infos.size() <= 0) continue;
            for (int j = 0; j < infos.size(); ++j) {
                result.add(infos.get(j));
            }
        }
        return result;
    }

    private String constructAssignmentsSql(List allAssignments) {
        if (allAssignments == null || allAssignments.size() <= 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < allAssignments.size(); ++i) {
            AssignmentInfo info = (AssignmentInfo)allAssignments.get(i);
            buffer.append('\'');
            buffer.append(info.getAssignmentId());
            buffer.append('\'');
            buffer.append(',');
        }
        return buffer.deleteCharAt(buffer.length() - 1).toString();
    }

    private void fillCompletedAssign(List allAssignments, AssignmentInfo[] infos) {
        if (allAssignments == null || infos == null || infos.length <= 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            AssignmentInfo info = infos[i];
            if (info.getState() != WfAssignmentState.COMPLETED) continue;
            allAssignments.add(info);
        }
    }

    public Map<String, List<String>> getCurrentAssignIds(String userId, String[] billIdArr, String bizPackage, String bizFuncion, String bizOperation) throws Exception {
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        return engine.getCurrentAssignIds(this.getContext(), userId, billIdArr, bizPackage, bizFuncion, bizOperation);
    }
}

