/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.monitor.WfProcessDiagram;
import com.kingdee.bos.workflow.service.DynamicActDef;
import com.kingdee.bos.workflow.service.IDynamicWfCfg;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.param.util.ParamManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicWfCfg
implements IDynamicWfCfg {
    protected static final Logger logger = Logger.getLogger(DynamicWfCfg.class);
    private final String TABLE = "t_wfr_dynamicAppend";
    public static final String key = "WFDynamicAppendCFG";
    private Context ctx;
    private boolean hasAppendPerm;

    public DynamicWfCfg(Context ctx) {
        this.ctx = ctx;
        this.hasAppendPerm = DynamicWfCfg.isCheckPermission(ctx);
    }

    @Override
    public Map<String, String> getManpowerActDefs(String userID, IObjectValue bizObject, String functionName, String operationName) {
        LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            ProcessDef procdef = svc.findSubmitProcDefObj(userID, bizObject, functionName, operationName);
            WfProcessDiagram diag = new WfProcessDiagram(this.ctx, null);
            HashMap[] postActivitesList = diag.findNextManpownerActivities(procdef, false, false);
            this.putLinkMap(postActivitesList, linkMap, procdef);
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return linkMap;
    }

    private void putLinkMap(HashMap[] postActivitesList, Map<String, String> linkMap, ProcessDef procDef) throws WfException {
        if (postActivitesList.length > 0) {
            String procDefId = procDef.getID();
            WfEngine wfEngine = WfEngine.getEngine(this.ctx);
            for (int i = 0; i < postActivitesList.length; ++i) {
                HashMap actMap = postActivitesList[i];
                String actId = (String)actMap.get("id");
                String actName = (String)actMap.get("name");
                HashMap[] subActs = (HashMap[])actMap.get("subActivities");
                ActivityDef e = procDef.getActivityDef(actId);
                if (subActs != null) {
                    procDefId = (String)subActs[0].get("processId");
                    procDef = wfEngine.getProcessMgr(procDefId).getProcessDef();
                    this.putLinkMap(subActs, linkMap, procDef);
                    continue;
                }
                if (!(e instanceof ApproveActivityDef) || !this.hasAppendPerm && !this.getBoolean(e, "appendActivity")) continue;
                linkMap.put(actId, actName);
            }
        }
    }

    private boolean getBoolean(ActivityDef act, String attr) {
        ExtendedAttributeCollection extAttr = act.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ext = extAttr.get(attr);
        if (ext == null) {
            return false;
        }
        return Boolean.valueOf(ext.getValue());
    }

    private static boolean isCheckPermission(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"IS_SHOW_APPENDACTIVITY");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u7279\u6b8a\u6743\u9650\u8bbe\u7f6e\u51fa\u9519   ", (Throwable)e);
        }
        return false;
    }

    @Override
    public void saveDynamicCfg(String billId, List<DynamicActDef> defs) {
        String sql = "insert into t_wfr_dynamicAppend(fbillId,factDefId,fopinion,fisPriorAppend,fisSequencial,fpersonId,fcreator,ftime) values(?,?,?,?,?,?,?,?)";
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 93};
        for (DynamicActDef def : defs) {
            Object[] params = new Object[]{billId, def.getActDefId(), def.getOption(), def.isPriorAppend() ? "2" : "1", def.isSequencial() ? "1" : "2", this.idsToString(def.getPerformerIds()), this.ctx.getCaller().toString(), new Timestamp(System.currentTimeMillis())};
            try {
                SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])params);
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }

    @Override
    public List<DynamicActDef> getDynamicCfgs(String billId) {
        ArrayList<DynamicActDef> dynamicActDefs = new ArrayList<DynamicActDef>();
        String sql = "select * from t_wfr_dynamicAppend where fbillId =? and fisable='1'";
        ArrayList result = null;
        try {
            result = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{billId});
            for (Object obj : result) {
                DynamicActDef dynamic = new DynamicActDef();
                dynamic.setActDefId((String)((Map)obj).get("factdefid"));
                dynamic.setOption((String)((Map)obj).get("fopinion"));
                String personIds = (String)((Map)obj).get("fpersonid");
                dynamic.setPerformerIds(this.toPersonArray(personIds));
                String priorAppend = (String)((Map)obj).get("fispriorappend");
                dynamic.setPriorAppend(priorAppend.equals("2"));
                String sequencial = (String)((Map)obj).get("fissequencial");
                dynamic.setSequencial(sequencial.equals("1"));
                String creator = (String)((Map)obj).get("fcreator");
                dynamic.setCreator(creator);
                dynamicActDefs.add(dynamic);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return dynamicActDefs;
    }

    private String[] toPersonArray(String personIds) {
        if (personIds == null) {
            return new String[0];
        }
        return personIds.split(",");
    }

    @Override
    public boolean lock(String billId, String actDefId, String actInstId) {
        try {
            String query = "select top 1 fbillId from t_wfr_dynamicAppend where fbillId =?";
            if (SQL.executeQuery((Context)this.ctx, (String)query, (int[])new int[]{12}, (Object[])new Object[]{billId}).size() > 0) {
                String sql = "update t_wfr_dynamicAppend set factInstId = ?,ftime =? where factdefid = ? and (factInstId is null or factInstId <> ?) and fbillid = ?";
                int i = SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])new int[]{12, 93, 12, 12, 12}, (Object[])new Object[]{actInstId, new Timestamp(System.currentTimeMillis()), actDefId, actInstId, billId});
                return i > 0;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return false;
    }

    private String now() {
        return new Timestamp(System.currentTimeMillis()).toString().substring(0, 19);
    }

    private String idsToString(String[] ids) {
        String s = "";
        for (String id : ids) {
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + id;
        }
        return s;
    }

    @Override
    public void disableCfg(String[] billIds) {
        if (billIds == null || billIds.length == 0) {
            return;
        }
        String idStr = this.idsToString(billIds);
        String sql = "update t_wfr_dynamicAppend set fisable='0' where fbillId in(" + idStr + ")";
        try {
            SQL.executeUpdate((Context)this.ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    @Override
    public void deleteDynamicCfg(String billId) {
        String sql = "delete from t_wfr_dynamicAppend where fbillId=?";
        try {
            SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{billId});
        }
        catch (BOSException e) {
            logger.error((Object)"\u5220\u9664\u52a8\u6001\u52a0\u7b7e\u65b9\u6848\u62a5\u9519", (Throwable)e);
        }
    }
}

