/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.webservice.MetaDataHelper;
import com.kingdee.bos.webservice.WSInvokeException;
import com.kingdee.bos.workflow.ActivitySuspendedException;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class WfIntegrationService {
    protected static final Logger logger = Logger.getLogger(WfIntegrationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String submitBill(String pk, String wfUser, String datajson) throws WSInvokeException {
        String id = null;
        Context ctx = new Context();
        String caller = null;
        Throwable exp = null;
        try {
            Message message = MessageContext.getCurrentContext().getRequestMessage();
            SOAPEnvelope soap = message.getSOAPEnvelope();
            SOAPHeaderElement headerElement = soap.getHeaderByName("http://login.webservice.bos.kingdee.com", "SessionId");
            String SessionId = headerElement.getValue();
            ctx = SessionManager.getInstance().getSession(SessionId).getContext();
            caller = ctx.getCaller().toString();
            JSONObject json = (JSONObject)JSON.parse((String)datajson);
            if (!(json instanceof JSONObject)) {
                throw new BOSException("datajson is invalid");
            }
            if (StringUtils.isEmpty((String)wfUser)) {
                throw new BOSException("workflowUser's number is null");
            }
            String sql = "select fid from t_pm_user where fnumber = '" + wfUser + "'";
            ArrayList ids = SQL.executeQuery((Context)ctx, (String)sql);
            if (ids.size() == 0) {
                throw new BOSException("Can not find the user whose number is " + wfUser);
            }
            String wfUserId = (String)((Map)ids.get(0)).get("fid");
            Context ctx2 = Ctx.generateContext((String)ctx.getAIS(), (String)wfUserId, null, null);
            ICoreBase icorebase = null;
            EntityObjectInfo entity = MetaDataHelper.getEntityMetaData((Context)ctx2, (String)pk);
            CoreBillBaseCustomInfo objectInfo = null;
            if (entity == null) {
                icorebase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx2, (IMetaDataPK)new MetaDataPK(pk));
                objectInfo = new CoreBillBaseCustomInfo();
                objectInfo.setBOSType(icorebase.getType());
                objectInfo.setPK((IMetaDataPK)new MetaDataPK(pk));
            } else {
                String factoryClassName = entity.getBusinessImplFactory();
                Class<?> factoryClass = Class.forName(factoryClassName);
                Method getLocalInstanceMethod = this.getFacadeInstanceMethod(factoryClass);
                icorebase = (ICoreBase)getLocalInstanceMethod.invoke(factoryClass, ctx2);
                objectInfo = Utils.newObjectValueInstance((EntityObjectInfo)entity);
            }
            objectInfo = this.fillValue(ctx2, icorebase, (IObjectValue)objectInfo, json);
            IObjectPK ipk = icorebase.submit((CoreBaseInfo)objectInfo);
            if (ipk != null) {
                id = ipk.toString();
            }
            String string = id;
            this.saveLog(ctx, pk, datajson, id, caller, exp);
            return string;
        }
        catch (Throwable e) {
            try {
                exp = e;
                this.handException(e);
                String string = null;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.saveLog(ctx, pk, datajson, id, caller, exp);
            }
        }
    }

    private void handException(Throwable e) throws WSInvokeException {
        String msg = "";
        if (e instanceof ActivitySuspendedException) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ctivitySuspended");
        }
        if (e instanceof AlreadyInProcessQueueException) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AlreadyInProcessQueue");
        }
        if (e instanceof MissMatchParticipantException) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MissMatchParticipant");
        }
        if (e instanceof MatchAssignmentException) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch");
        }
        logger.error((Object)"WfIntegrationService submitBill fail", e);
        if (StringUtils.isEmpty((String)msg)) {
            msg = e.getMessage();
        }
        throw new WSInvokeException(msg);
    }

    private IObjectValue fillValue(Context ctx, ICoreBase icorebase, IObjectValue objectInfo, JSONObject json) throws BOSException, EASBizException {
        String oql;
        CoreBaseInfo objectInfo2;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(icorebase.getType());
        PropertyCollection properties = entity.getInheritedPropertiesRuntime();
        String tid = (String)json.get((Object)"tid");
        if (!StringUtils.isEmpty((String)tid) && (objectInfo2 = icorebase.getValue(oql = "where tid = '" + json.get((Object)"tid") + "'")) != null) {
            objectInfo = objectInfo2;
        }
        for (String s : json.keySet()) {
            PropertyInfo property = (PropertyInfo)properties.getObject((Object)s);
            if (property instanceof LinkPropertyInfo) {
                if (!this.isEntry((LinkPropertyInfo)property)) continue;
                EntityObjectInfo entryEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
                JSONArray entryList = (JSONArray)json.get((Object)s);
                CoreBillBaseCustomEntryCollection entryC = new CoreBillBaseCustomEntryCollection();
                int entrysize = entryList.size();
                for (int i = 0; i < entrysize; ++i) {
                    CoreBillBaseCustomEntryInfo eobjectInfo = new CoreBillBaseCustomEntryInfo();
                    eobjectInfo.setBOSType(entryEntity.getType());
                    eobjectInfo.setPK((IMetaDataPK)new MetaDataPK(entryEntity.getFullName()));
                    JSONObject ejson = (JSONObject)entryList.get(i);
                    for (String es : ejson.keySet()) {
                        Object entryValue = ejson.get((Object)es);
                        if (entryEntity.getProperties().getObject((Object)es) instanceof OwnPropertyInfo && DataType.DATE.equals((Object)((OwnPropertyInfo)entryEntity.getProperties().getObject((Object)es)).getDataType())) {
                            entryValue = new Timestamp((Long)entryValue);
                        }
                        eobjectInfo.put(es, entryValue);
                    }
                    entryC.add(eobjectInfo);
                }
                objectInfo.put(s, (Object)entryC);
                continue;
            }
            if (!(property instanceof OwnPropertyInfo)) continue;
            Object value = json.get((Object)s);
            if (DataType.DATE.equals((Object)((OwnPropertyInfo)property).getDataType())) {
                value = new Timestamp((Long)value);
            }
            objectInfo.put(s, value);
        }
        return objectInfo;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    private Method getFacadeInstanceMethod(Class<?> factoryClass) {
        Method[] factoryMethods = factoryClass.getMethods();
        String localInstaceMethodName = "getLocalInstance";
        for (Method fMethod : factoryMethods) {
            Class<?>[] classParamTypes;
            if (!fMethod.getName().equals(localInstaceMethodName) || (classParamTypes = fMethod.getParameterTypes()).length != 1) continue;
            for (Class<?> cpt : classParamTypes) {
                if (!cpt.equals(Context.class)) continue;
                return fMethod;
            }
        }
        return null;
    }

    private void saveLog(Context ctx, String pk, String datajson, String billId, String caller, Throwable exp) {
        try {
            String sql = "insert into T_WFR_INTEGRATIONLOG(fid,FPK, Fjsondata, FBILLID,FCaller,FCreateTime,FEXCEPTION) values (?,?,?,?,?,?,?)";
            int[] types = new int[]{12, 12, 12, 12, 12, 93, 12};
            Object[] values = new Object[]{Uuid.randomUUID().toString() + "WFINTELG", pk, datajson, billId, caller, new Timestamp(System.currentTimeMillis()), Serialization.dump((Throwable)exp)};
            SQL.executeUpdate((Context)ctx, (String)sql, (int[])types, (Object[])values);
        }
        catch (BOSException e) {
            logger.error((Object)"WfIntegrationService saveLog fail", (Throwable)e);
        }
    }
}

