/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.app.startsheme.WFStartLogInfo;
import com.kingdee.bos.workflow.cust.app.startsheme.WFStartLogStorer;
import com.kingdee.bos.workflow.metas.IWFREngineLog;
import com.kingdee.bos.workflow.metas.IWFRProcessDefLog;
import com.kingdee.bos.workflow.metas.IWFRProcessInstLog;
import com.kingdee.bos.workflow.metas.IWFRQueueLog;
import com.kingdee.bos.workflow.metas.WFREngineLogFactory;
import com.kingdee.bos.workflow.metas.WFREngineLogInfo;
import com.kingdee.bos.workflow.metas.WFRProcessDefLogFactory;
import com.kingdee.bos.workflow.metas.WFRProcessDefLogInfo;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogFactory;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogInfo;
import com.kingdee.bos.workflow.metas.WFRQueueLogFactory;
import com.kingdee.bos.workflow.metas.WFRQueueLogInfo;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.AnalysisDataInfo;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LogStorer
extends AbstractBaseStorer {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.store.LogStorer");

    public LogStorer(Context context) {
        super(context);
    }

    public void clearWfLog() throws WfException {
        try {
            IWFRQueueLog wfrQueueLog = WFRQueueLogFactory.getLocalInstance((Context)this.getContext());
            wfrQueueLog.delete("");
            IWFREngineLog wfrEngineLog = WFREngineLogFactory.getLocalInstance((Context)this.getContext());
            wfrEngineLog.delete("");
            IWFRProcessDefLog wfrProcessDefLog = WFRProcessDefLogFactory.getLocalInstance((Context)this.getContext());
            wfrProcessDefLog.delete("");
            IWFRProcessInstLog wfrProcessInstLog = WFRProcessInstLogFactory.getLocalInstance((Context)this.getContext());
            wfrProcessInstLog.delete("");
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"clearWfLog() ", (Throwable)e);
        }
    }

    public void addWfLog(Object info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        if (info instanceof WFRQueueLogInfo) {
            this.addWfQueueLog((WFRQueueLogInfo)info);
        } else if (info instanceof WFREngineLogInfo) {
            this.addWfEngineLog((WFREngineLogInfo)info);
        } else if (info instanceof WFRProcessDefLogInfo) {
            this.addWfProcessDefLog((WFRProcessDefLogInfo)info);
        } else if (info instanceof WFRProcessInstLogInfo) {
            this.addWfProcessInstLog((WFRProcessInstLogInfo)info);
        } else if (info instanceof AnalysisDataInfo) {
            this.addAnalysisData((AnalysisDataInfo)info);
        } else if (info instanceof WFStartLogInfo) {
            this.addWfStartLog((WFStartLogInfo)info);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void addWfEngineLog(WFREngineLogInfo info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        Locale[] locales = this.getLocales();
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale locale = locales[i];
            String description = info.getDescription(locale);
            info.setDescription(this.subDescription(description), locale);
        }
        try {
            Context context = this.getContext();
            IWFREngineLog wfrEngineLog = WFREngineLogFactory.getLocalInstance((Context)context);
            wfrEngineLog.addnew(info);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public void addWfQueueLog(WFRQueueLogInfo info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        Locale[] locales = this.getLocales();
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale locale = locales[i];
            String description = info.getDescription(locale);
            info.setDescription(this.subDescription(description), locale);
        }
        try {
            Context context = this.getContext();
            IWFRQueueLog wfrQueueLog = WFRQueueLogFactory.getLocalInstance((Context)context);
            wfrQueueLog.addnew(info);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public void addWfProcessDefLog(WFRProcessDefLogInfo info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        Locale[] locales = this.getLocales();
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale locale = locales[i];
            String description = info.getDescription(locale);
            info.setDescription(this.subDescription(description), locale);
        }
        try {
            Context context = this.getContext();
            IWFRProcessDefLog wfrProcessDefLog = WFRProcessDefLogFactory.getLocalInstance((Context)context);
            wfrProcessDefLog.addnew(info);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    private String subDescription(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        if (description.length() <= 200) {
            return description;
        }
        return description.substring(0, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnalysisData(AnalysisDataInfo info) {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            String sql = "INSERT INTO T_WFR_ANALYSISDATA (FPERFORMER,FTHREAD,FOPERATION,FSTEP,FCREATEDTIME,FCONSUMETIME,FNOTE) VALUES (?,?,?,?,?,?,?)";
            connection = this.getConnection();
            statement = connection.prepareStatement(sql);
            int index = 0;
            statement.setString(++index, info.getPerformer());
            statement.setString(++index, info.getThread());
            statement.setString(++index, info.getOperation());
            statement.setString(++index, info.getStep());
            Long createdTime = new Long(info.getCreatedTime());
            statement.setString(++index, createdTime.toString());
            statement.setLong(++index, info.getConsumeTime());
            statement.setString(++index, info.getNote());
            statement.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(null, statement, connection);
                throw throwable;
            }
            StoreManager.cleanup(null, statement, connection);
        }
        StoreManager.cleanup(null, statement, connection);
    }

    public void addWfProcessInstLog(WFRProcessInstLogInfo info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        Locale[] locales = this.getLocales();
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale locale = locales[i];
            String description = info.getDescription(locale);
            info.setDescription(this.subDescription(description), locale);
        }
        try {
            Context context = this.getContext();
            IWFRProcessInstLog wfrProcessInstLog = WFRProcessInstLogFactory.getLocalInstance((Context)context);
            wfrProcessInstLog.addnew(info);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    private void addWfStartLog(WFStartLogInfo info) throws WfException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        try {
            WFStartLogStorer.addnew((Context)this.getContext(), (WFStartLogInfo)info);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }
}

