/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.store.AssignmentBatchPersistence;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.listener.AbstractDataProvider;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.transaction.IBatchPersistence;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessContextBatchPersistence
extends AbstractDataProvider
implements IBatchPersistence {
    private static final Logger logger = Logger.getLogger(AssignmentBatchPersistence.class);
    private static final BOSObjectType bosObjectType = new ProcInstDataInfo().getBOSType();

    public ProcessContextBatchPersistence(Context ctx) {
        super(ctx);
    }

    @Override
    public void executeBatch(List newObjects, List changedObjects) throws WfException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        int newSize = 0;
        int changeSize = 0;
        try {
            if (newObjects != null && !newObjects.isEmpty()) {
                newSize = newObjects.size();
                ProcessStorer processStorer = WfEngine.getEngine(this.innerContext).getStoreManager().getProcessStorer();
                processStorer.addNewProcInstDataBatch(newObjects);
            }
            if (changedObjects != null && changedObjects.size() > 0) {
                cn = this.getConnection();
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)bosObjectType, (Context)this.innerContext, (Connection)cn);
                changeSize = changedObjects.size();
                for (int i = 0; i < changeSize; ++i) {
                    IObjectValue objectValue = (IObjectValue)changedObjects.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(objectValue.getBOSUuid(objectValue.getPKField()));
                    dao.updateBatch((IObjectPK)pk, objectValue);
                }
                dao.executeBatch();
                if (this.isEnableListen()) {
                    String procInstId = null;
                    if (changedObjects != null && changedObjects.size() > 0) {
                        AssignInfo info = (AssignInfo)changedObjects.get(0);
                        procInstId = StoreUtil.getProcInstIdByAssign(info.getAssignID().toString(), this.innerContext);
                        this.notifyDataChangedByProcInstId(procInstId, "executeBatch", new Class[]{List.class, List.class}, new Object[]{null, changedObjects});
                    }
                }
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(cn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ProcessContextBatchPersistence.executeBatch:" + lowTimer.msValue() + " new:" + newSize + " changed:" + changeSize));
        }
    }

    @Override
    public BOSObjectType getBOSObjectType() {
        return bosObjectType;
    }
}

