/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.enactment.AssignmentWorkerManager;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.message.AssignmentDeletionEvent;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignDetailInfo;
import com.kingdee.bos.workflow.metas.AssignHstCollection;
import com.kingdee.bos.workflow.metas.AssignHstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.OptionCollection;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.ForwardStep;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.WfAssignmentCounter;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ResourceUtils;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WorkItemStorer
extends AbstractBaseStorer {
    private static final Logger logger = Logger.getLogger(WorkItemStorer.class);
    private static final int DUMP_BATCH_SIZE = 100;
    private static final String DUMP_ASSIGN_SQL = new StringBuffer(500).append("INSERT INTO T_WFR_AssignDetail ").append(" (FASSIGNID, FBODY_L1, FBODY_L2,  FBODY_L3,  FSTATE,  FPERSONUSERID, ").append(" FPERSONUSERNAME_L1, FPERSONUSERNAME_L2, FPERSONUSERNAME_L3, ").append(" FPERSONEMPID, FPERSONEMPNAME_L1, FPERSONEMPNAME_L2, FPERSONEMPNAME_L3, ").append(" FPERFORMERUID, FPERFORMERUNAME_L1, FPERFORMERUNAME_L2, FPERFORMERUNAME_L3, ").append(" FPERFORMEREID, FPERFORMERENAME_L1, FPERFORMERENAME_L2 ,FPERFORMERENAME_L3, ").append(" FACTINSTID, FACTDEFID, FACTDEFNAME_L1, FACTDEFNAME_L2, FACTDEFNAME_L3, ").append(" FPROCDEFHASH, FPROCDEFID, FPROCDEFNAME_L1, FPROCDEFNAME_L2, FPROCDEFNAME_L3, ").append(" FPROCINSTID, FENDTIME, FLASTSTATETIME, FCREATEDTIME, FFORWARDPATH, FEXTATTR, ").append(" FACCEPTTIME, FBIZPACKAGE, FBIZFUNCTION,  FBIZOPERATION, FBIZOBJID, FAPPDEFID, FPRIORITY, ").append(" FDURATION, FWORKINGTIME, FWAITINGTIME, FISSENDMSG, ").append(" FORGID, FORGTYPE, ").append(" FINITIATORNAME_L1, FINITIATORNAME_L2, FINITIATORNAME_L3, ").append(" FSUBJECT_L1, FSUBJECT_L2, FSUBJECT_L3,FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3, FBILLENTITY").append(" ,FResponsibleEmpId, FSourceAssignId,FisSupportMobile,FOtherType ").append(" ) ").append(" SELECT Assign.FASSIGNID , Assign.FBODY_L1, Assign.FBODY_L2, Assign.FBODY_L3, Assign.FSTATE, Assign.FPERSONUSERID, ").append(" Assign.FPERSONUSERNAME_L1, Assign.FPERSONUSERNAME_L2, Assign.FPERSONUSERNAME_L3, ").append(" Assign.FPERSONEMPID, Assign.FPERSONEMPNAME_L1, Assign.FPERSONEMPNAME_L2, Assign.FPERSONEMPNAME_L3, ").append(" Assign.FPERFORMERUID, Assign.FPERFORMERUNAME_L1, Assign.FPERFORMERUNAME_L2, Assign.FPERFORMERUNAME_L3, ").append(" Assign.FPERFORMEREID, Assign.FPERFORMERENAME_L1, Assign.FPERFORMERENAME_L2, Assign.FPERFORMERENAME_L3, ").append(" Assign.FACTINSTID, Assign.FACTDEFID, Assign.FACTDEFNAME_L1, Assign.FACTDEFNAME_L2, Assign.FACTDEFNAME_L3, ").append(" Assign.FPROCDEFHASH, Assign.FPROCDEFID, Assign.FPROCDEFNAME_L1, Assign.FPROCDEFNAME_L2, Assign.FPROCDEFNAME_L3, ").append(" Assign.FPROCINSTID, Assign.FENDTIME, Assign.FLASTSTATETIME, Assign.FCREATEDTIME, Assign.FFORWARDPATH, Assign.FEXTATTR, ").append(" Assign.FACCEPTTIME, Assign.FBIZPACKAGE, Assign.FBIZFUNCTION, Assign.FBIZOPERATION, Assign.FBIZOBJID, Assign.FAPPDEFID, Assign.FPRIORITY, ").append(" Assign.FDURATION, Assign.FWORKINGTIME, Assign.FWAITINGTIME, Assign.FISSENDMSG, ").append("AssignRead.FOrgID, AssignRead.FOrgType , ").append(" ProcInst.finitiatorname_l1, ProcInst.finitiatorname_l2 , ProcInst.finitiatorname_l3, ").append(" Assign.FSUBJECT_L1, Assign.FSUBJECT_L2, Assign.FSUBJECT_L3, Assign.FPRIORPERFORMER, Assign.FPRIORPERFORMERNAME_l1, Assign.FPRIORPERFORMERNAME_l2, Assign.FPRIORPERFORMERNAME_l3, Assign.FBILLENTITY ").append(" ,Assign.FResponsibleEmpId, Assign.FSourceAssignId,Assign.FisSupportMobile,Assign.FOtherType").append(" FROM T_WFR_Assign Assign ").append(" LEFT OUTER JOIN T_BAS_AssignRead AssignRead ON  AssignRead.FAssignID = Assign.FAssignID ").append(" LEFT JOIN T_WFR_ProcInst ProcInst ON  ProcInst.FPROCINSTID = Assign.FPROCINSTID ").toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssignCollection getActivedAssignCollection(String oql) throws SQLException, DataAccessException {
        AssignCollection ac;
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            ac = (AssignCollection)oc;
        }
        finally {
            this.cleanup(cn);
        }
        return ac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignCollection getAssignInfoCollection(String oql) throws BOSException, SQLException {
        AssignCollection ac = new AssignCollection();
        Connection cn = null;
        long time = System.currentTimeMillis();
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            ac = (AssignCollection)oc;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WorkItemStorer getAssignInfoCollection (1) cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if ((oc = (ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT_DETAIL, cn)).getCollection(oql)) != null) {
                int n = oc.size();
                for (int i = 0; i < n; ++i) {
                    AssignInfo assignInfo = new AssignInfo(((AssignDetailInfo)oc.getObject(i)).getValues());
                    ac.add(assignInfo);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WorkItemStorer getAssignInfoCollection (1) cost: " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
        }
        finally {
            this.cleanup(cn);
        }
        return ac;
    }

    public AssignCollection getAllAssignInfoCollection(String oql) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)oql)) {
            throw new BOSException(" getAllAssignInfoCollection : args oql can't be null ");
        }
        AssignCollection col = this.getAssignInfoCollection(oql);
        AssignHstCollection hstCol = this.getAssignHstInfoCollection(oql);
        for (AssignHstInfo hstInfo : hstCol) {
            AssignInfo info = new AssignInfo(hstInfo.getValues());
            col.add(info);
        }
        return col;
    }

    private AssignmentInfo[] getAssignmentInfoArray(String oql) throws SQLException, BOSException {
        AssignCollection ac = this.getAssignInfoCollection(oql);
        if (ac != null && ac.size() > 0) {
            return StoreUtils.toAssignmentInfoArray((Object[])ac.toArray());
        }
        return new AssignmentInfo[0];
    }

    public AssignmentInfo[] getActivedAssignmentInfoArray(String oql) throws SQLException, BOSException {
        AssignCollection ac = this.getActivedAssignCollection(oql);
        if (ac != null && ac.size() > 0) {
            return StoreUtils.toAssignmentInfoArray((Object[])ac.toArray());
        }
        return new AssignmentInfo[0];
    }

    public AssignmentInfo getLastCompletedAssignment(String actInstId) throws BOSException, SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select *");
        buffer.append(" where");
        buffer.append(" (actInstID='" + actInstId + "')");
        buffer.append(" and");
        buffer.append(" (state=16)");
        buffer.append(" order by lastStateTime");
        String oql = buffer.toString();
        AssignCollection assignments = this.getAssignInfoCollection(oql);
        if (assignments == null || assignments.size() <= 0) {
            return null;
        }
        AssignInfo last = null;
        int size = assignments.size();
        for (int i = 0; i < size; ++i) {
            if (last == null) {
                last = assignments.get(i);
                continue;
            }
            if (assignments.get(i).getLastStateTime().compareTo(last.getLastStateTime()) <= 0) continue;
            last = assignments.get(i);
        }
        if (last == null) {
            return null;
        }
        return new AssignmentInfo(last);
    }

    private AssignmentInfo getActivedAssignmentInfo(String oql) throws BOSException, SQLException {
        AssignCollection ac = this.getActivedAssignCollection(oql);
        if (ac != null && ac.size() > 0) {
            return new AssignmentInfo(ac.get(0));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssignHstCollection getAssignHstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            AssignHstCollection ac;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTHSTBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            AssignHstCollection assignHstCollection = ac = (AssignHstCollection)oc;
            return assignHstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private AssignmentInfo[] getAssignmentInfoArray_Hst(String oql) throws SQLException, DataAccessException {
        AssignHstCollection ac = this.getAssignHstInfoCollection(oql);
        if (ac != null && ac.size() > 0) {
            return StoreUtils.toAssignmentInfoArray((Object[])ac.toArray());
        }
        return new AssignmentInfo[0];
    }

    public AssignmentInfo getActivedWorkItem(String workItemId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE ");
        sql.append("(assignID = '" + workItemId + "')");
        return this.getActivedAssignmentInfo(sql.toString());
    }

    public AssignmentInfo[] getWorkItemListByIds(String[] id, DataTypeEnum dataType, String[] selectors) throws SQLException, BOSException {
        if (id == null || id.length == 0) {
            return new AssignmentInfo[0];
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE (");
        sql.append("(assignID = '" + id[0] + "')");
        for (int i = 1; i < id.length; ++i) {
            sql.append(" OR (assignID = '" + id[i] + "')");
        }
        sql.append(')');
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(sql.toString());
        }
        return this.getAssignmentInfoArray_Hst(sql.toString());
    }

    public static String getBizObjIdList(ManpowerActivityDef manpowerDef, ProcessContext procContext) {
        String bizObjectId = null;
        ApplicationDef appDef = manpowerDef.getRelatedApplication();
        FormalParameterCollection formalPramCol = appDef.getFormalParameters();
        ActualParameterCollection actualParamCal = manpowerDef.getActualParameters();
        for (int i = 0; i < formalPramCol.size(); ++i) {
            FormalParameterDef formalParam = formalPramCol.get(i);
            if (!formalParam.getMode().equals((Object)FormalParameterMode.IN) && !formalParam.getMode().equals((Object)FormalParameterMode.INOUT) || !formalParam.getDataType().equals(BasicType.BOID)) continue;
            if (formalParam.getIndex() >= actualParamCal.size()) {
                logger.error((Object)"\u6d41\u7a0b\u5b9a\u4e49\u590d\u5236\u8282\u70b9\u95ee\u9898\u9020\u6210\u4e0b\u6807\u8d8a\u754c\uff0c\u8fd0\u884c\u671f\u517c\u5bb9\u8be5\u95ee\u9898");
                continue;
            }
            ActualParameterDef actualParam = (ActualParameterDef)actualParamCal.getObject(formalParam.getIndex());
            String dataName = actualParam.getDataField().getName();
            if (!StringUtils.isEmpty((String)actualParam.getProp())) {
                dataName = dataName + "." + actualParam.getProp();
            }
            String pramValue = null;
            Object value = procContext.getDataFieldValue(dataName);
            if (value == null) continue;
            pramValue = value.toString();
            if (pramValue == null) {
                logger.info((Object)("get ProcContext Error! DataField is:" + dataName));
            }
            if (pramValue == null || pramValue.length() == 0) continue;
            bizObjectId = bizObjectId != null && bizObjectId.length() != 0 ? bizObjectId + "," + pramValue : pramValue;
        }
        return bizObjectId;
    }

    public WorkItemStorer(Context context) {
        super(context);
    }

    public AssignmentInfo createWorkItem(WfActivity activity, Person person, String forwardPath) throws SQLException, DataAccessException, WfException {
        return this.createWorkItem(activity, person, forwardPath, true);
    }

    public AssignmentInfo createWorkItem(WfActivity activity, Person person, String forwardPath, boolean isSendMsg) throws SQLException, DataAccessException, WfException {
        return this.createWorkItem(activity, person, forwardPath, null, isSendMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignmentInfo createForwardWorkItem(WfActivity activity, AssignmentInfo fromAsgnmnt, Person toPerson, boolean isSendMsg, String forwardType, Map extendMsg) throws SQLException, DataAccessException, WfException {
        String type = "";
        if (extendMsg != null && extendMsg.size() >= 0 && extendMsg.containsKey("forwardType")) {
            type = extendMsg.get("forwardType").toString();
            extendMsg.remove("forwardType");
        }
        if (!"devolve".equals(forwardType) && !"forward".equals(forwardType)) {
            throw new IllegalArgumentException();
        }
        Connection connection = null;
        try {
            Locale locale;
            connection = this.getConnection();
            Locale[] locales = this.getLocales();
            ActivityDef actDef = activity.getDefinition();
            Map subjects = null;
            Map bodies = null;
            if (actDef instanceof ManpowerActivityDef) {
                subjects = WfMessageUtil.getMessageTitles(activity, locales);
                bodies = WfMessageUtil.getMessageContents(activity, locales);
            }
            if (extendMsg != null && "forward".equals(forwardType)) {
                for (Map.Entry entry : extendMsg.entrySet()) {
                    locale = (Locale)entry.getKey();
                    Object value = entry.getValue();
                    StringBuffer buffer = new StringBuffer();
                    if (!StringUtils.isEmpty((String)((String)bodies.get(locale)))) {
                        String msgBody = (String)bodies.get(locale);
                        buffer.append(msgBody);
                    }
                    if (!StringUtils.isEmpty((String)((String)value))) {
                        String msgExtend = (String)value;
                        String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELIVER_OPINION", locale);
                        buffer.append("\n\n/*" + resource + "\n" + msgExtend + "*/\n");
                    }
                    bodies.put(locale, buffer.toString());
                }
            }
            if ("devolve".equals(forwardType)) {
                int size = locales.length;
                for (int i = 0; i < size; ++i) {
                    locale = locales[i];
                    StringBuffer buffer = new StringBuffer();
                    String body = StringUtils.isEmpty((String)((String)bodies.get(locale))) ? "" : (String)bodies.get(locale);
                    buffer.append(body);
                    String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELEGATE_USER", locale);
                    buffer.append("\n\n/*" + resource + fromAsgnmnt.getAssignInfo().getPersonUserName(locale) + "*/\n");
                    bodies.put(locale, buffer.toString());
                }
            }
            ProcessDefInfo procDefMeta = activity.container().manager().getData();
            ProcessInstInfo procInstMeta = activity.container().getData();
            Timestamp ct = new Timestamp(System.currentTimeMillis());
            String workItemId = Uuid.create().toString() + "WFWKITEM";
            ForwardStep forwardStep = new ForwardStep();
            forwardStep.setType(forwardType);
            forwardStep.setFromAssignment(fromAsgnmnt.getAssignmentId());
            forwardStep.setToAssignment(workItemId);
            AssignInfo ai = new AssignInfo();
            ai.setAssignID(BOSUuid.read((String)workItemId));
            for (int i = 0; i <= locales.length - 1; ++i) {
                Locale lcl = locales[i];
                String temp = StringUtils.cnulls(subjects.get(lcl));
                if (!"backdele".equals(type)) {
                    temp = StringUtils.isEmpty((String)temp) ? null : (lcl == LocaleUtils.locale_l2 ? "\u59d4\u6258[" + temp + "]" : (lcl == LocaleUtils.locale_l3 ? "\u59d4\u8a17[" + temp + "]" : "Delegate [" + temp + "]"));
                }
                ai.setSubject(temp, lcl);
                temp = StringUtils.cnulls(bodies.get(lcl));
                if (StringUtils.isEmpty((String)temp)) {
                    temp = null;
                }
                ai.setBody(temp, lcl);
                ai.setPersonUserName(toPerson.getUserName(lcl), lcl);
                ai.setPersonEmpName(toPerson.getEmployeeName(lcl), lcl);
                String actName = actDef.getName(lcl);
                if (StringUtils.isEmpty((String)actName)) {
                    actName = null;
                }
                ai.setActdefName(actName, lcl);
                ai.setProcdefName(procDefMeta.getProcDefName(lcl), lcl);
                ai.setPriorPerformName(fromAsgnmnt.getAssignInfo().getPriorPerformName(lcl), lcl);
            }
            ai.setPriorPerformerID(fromAsgnmnt.getAssignInfo().getPriorPerformerID());
            ai.setIsSupportMobile(fromAsgnmnt.getAssignInfo().isIsSupportMobile());
            int asgndi = WfAssignmentState.ASSIGNED.getValue();
            WfAssignmentState wfase = WfAssignmentState.getEnum((int)asgndi);
            ai.setState(wfase);
            ai.setPersonUserID(BOSUuid.read((String)toPerson.getUserId()));
            if (toPerson.getEmployeeId() != null && toPerson.getEmployeeId().length() > 0) {
                ai.setPersonEmpID(BOSUuid.read((String)toPerson.getEmployeeId()));
            } else {
                logger.error((Object)("Workflow Add WorkItem error: can't get employee by user.userId " + toPerson.getUserId()));
            }
            ai.setActInstID(BOSUuid.read((String)activity.getId()));
            ai.setActdefID(BOSUuid.read((String)actDef.getID()));
            ai.setProcdefhash(procDefMeta.getMd5HashValue());
            ai.setProcdefID(BOSUuid.read((String)procDefMeta.getProcDefId()));
            ai.setProcInstID(BOSUuid.read((String)procInstMeta.getProcInstId()));
            int p = activity.getDefinition().getActivityHeader().getpriority();
            p = p == -3 || p == -2 ? 0 : (p == -1 || p == 0 || p == 1 ? 10 : (p == 2 || p == 3 || p == 4 || p == 5 ? 20 : 10));
            ai.setPriority(p);
            ai.setLastStateTime(ct);
            ai.setCreatedTime(ct);
            ai.setForwardPath(forwardStep.toXML());
            WorkItemStorer.copyAppInfo(fromAsgnmnt, ai);
            ai.setIsSendMsg(isSendMsg);
            ai.setSourceAssignId(fromAsgnmnt.getAssignmentId());
            if (!"backdele".equals(type)) {
                String fromAssignPerson = fromAsgnmnt.getEmployeeId();
                if (StringUtils.isEmpty((String)fromAssignPerson)) {
                    fromAssignPerson = fromAsgnmnt.getUserId();
                }
                ai.setResponsibleEmpId(fromAssignPerson);
            }
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, connection);
            ormdao.addnew((IObjectValue)ai);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WfMessageSender send message : " + subjects.get(new Locale("L2"))));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isEnableListen()) {
                ProcessDefInfo def = StoreUtil.getProcessDefInfoByID(ai.getProcdefID().toString(), this.getContext());
                this.setDataChanged(StoreUtil.generateDaoDataByProcDef(this, this.getContext(), "addnew", WfBOSObjectTypeUtil.ASSIGNMENTBOT, new Object[]{ai}, def));
            }
            AssignmentInfo assignmentInfo = new AssignmentInfo(ai);
            return assignmentInfo;
        }
        finally {
            this.cleanup(connection);
        }
    }

    private static void copyAppInfo(AssignmentInfo fromAsgnmnt, AssignInfo ai) {
        ai.setBizPackage(fromAsgnmnt.getBizPackage());
        ai.setBizFunction(fromAsgnmnt.getBizFunction());
        ai.setBizOperation(fromAsgnmnt.getBizOperation());
        ai.setBizObjID(fromAsgnmnt.getBizObjectIds());
        String appId = fromAsgnmnt.getApplicationDefId();
        if (appId != null && appId.length() > 0) {
            ai.setAppdefID(BOSUuid.read((String)appId));
        }
        ai.setBillEntity(fromAsgnmnt.getBillEntity());
    }

    public static AssignmentInfo newForwardWorkItem(Context ctx, WfActivity activity, AssignmentInfo fromAsgnmnt, Person toPerson, boolean isSendMsg, String forwardType, Map extendMsg) throws WfException {
        Locale locale;
        Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
        ActivityDef actDef = activity.getDefinition();
        Map subjects = null;
        Map bodies = null;
        if (actDef instanceof ManpowerActivityDef) {
            subjects = WfMessageUtil.getMessageTitles(activity, locales);
            bodies = WfMessageUtil.getMessageContents(activity, locales);
        }
        if (extendMsg != null && "forward".equals(forwardType)) {
            for (Map.Entry entry : extendMsg.entrySet()) {
                locale = (Locale)entry.getKey();
                Object value = entry.getValue();
                StringBuffer buffer = new StringBuffer();
                if (!StringUtils.isEmpty((String)((String)bodies.get(locale)))) {
                    String msgBody = (String)bodies.get(locale);
                    buffer.append(msgBody);
                }
                if (!StringUtils.isEmpty((String)((String)value))) {
                    String msgExtend = (String)value;
                    String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELIVER_OPINION", locale);
                    buffer.append("\n\n/*" + resource + "\n" + msgExtend + "*/\n");
                }
                bodies.put(locale, buffer.toString());
            }
        }
        if ("devolve".equals(forwardType)) {
            int size = locales.length;
            for (int i = 0; i < size; ++i) {
                locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                String body = StringUtils.isEmpty((String)((String)bodies.get(locale))) ? "" : (String)bodies.get(locale);
                buffer.append(body);
                String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELEGATE_USER", locale);
                buffer.append("\n\n/*" + resource + fromAsgnmnt.getAssignInfo().getPersonUserName(locale) + "*/\n");
                bodies.put(locale, buffer.toString());
            }
        }
        ProcessDefInfo procDefMeta = activity.container().manager().getData();
        ProcessInstInfo procInstMeta = activity.container().getData();
        Timestamp ct = new Timestamp(System.currentTimeMillis());
        String workItemId = Uuid.create().toString() + "WFWKITEM";
        ForwardStep forwardStep = new ForwardStep();
        forwardStep.setType(forwardType);
        forwardStep.setFromAssignment(fromAsgnmnt.getAssignmentId());
        forwardStep.setToAssignment(workItemId);
        AssignInfo ai = new AssignInfo();
        ai.setAssignID(BOSUuid.read((String)workItemId));
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale lcl = locales[i];
            String temp = StringUtils.cnulls(subjects.get(lcl));
            if (StringUtils.isEmpty((String)temp)) {
                temp = null;
            }
            ai.setSubject(temp, lcl);
            temp = StringUtils.cnulls(bodies.get(lcl));
            if (StringUtils.isEmpty((String)temp)) {
                temp = null;
            }
            ai.setBody(temp, lcl);
            ai.setPersonUserName(toPerson.getUserName(lcl), lcl);
            ai.setPersonEmpName(toPerson.getEmployeeName(lcl), lcl);
            String actName = actDef.getName(lcl);
            if (StringUtils.isEmpty((String)actName)) {
                actName = null;
            }
            ai.setActdefName(actName, lcl);
            ai.setProcdefName(procDefMeta.getProcDefName(lcl), lcl);
            ai.setPriorPerformName(fromAsgnmnt.getAssignInfo().getPriorPerformName(lcl), lcl);
        }
        ai.setPriorPerformerID(fromAsgnmnt.getAssignInfo().getPriorPerformerID());
        ai.setIsSupportMobile(fromAsgnmnt.getAssignInfo().isIsSupportMobile());
        int asgndi = WfAssignmentState.ASSIGNED.getValue();
        WfAssignmentState wfase = WfAssignmentState.getEnum((int)asgndi);
        ai.setState(wfase);
        ai.setPersonUserID(BOSUuid.read((String)toPerson.getUserId()));
        if (toPerson.getEmployeeId() != null && toPerson.getEmployeeId().length() > 0) {
            ai.setPersonEmpID(BOSUuid.read((String)toPerson.getEmployeeId()));
        } else {
            logger.error((Object)("Workflow Add WorkItem error: can't get employee by user.userId " + toPerson.getUserId()));
        }
        ai.setActInstID(BOSUuid.read((String)activity.getId()));
        ai.setActdefID(BOSUuid.read((String)actDef.getID()));
        ai.setProcdefhash(procDefMeta.getMd5HashValue());
        ai.setProcdefID(BOSUuid.read((String)procDefMeta.getProcDefId()));
        ai.setProcInstID(BOSUuid.read((String)procInstMeta.getProcInstId()));
        int p = activity.getDefinition().getActivityHeader().getpriority();
        p = p == -3 || p == -2 ? 0 : (p == -1 || p == 0 || p == 1 ? 10 : (p == 2 || p == 3 || p == 4 || p == 5 ? 20 : 10));
        ai.setPriority(p);
        ai.setLastStateTime(ct);
        ai.setCreatedTime(ct);
        ai.setForwardPath(forwardStep.toXML());
        WorkItemStorer.copyAppInfo(fromAsgnmnt, ai);
        ai.setIsSendMsg(isSendMsg);
        ai.setSourceAssignId(fromAsgnmnt.getAssignmentId());
        String s = fromAsgnmnt.getResponsibleEmpId();
        if (s == null) {
            s = fromAsgnmnt.getEmployeeId();
        }
        ai.setResponsibleEmpId(s);
        return new AssignmentInfo(ai);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchForward(AssignmentInfo[] assigns) throws SQLException, DataAccessException, WfException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, connection);
            for (int i = 0; i < assigns.length; ++i) {
                ormdao.addNewBatch((IObjectValue)assigns[i].getAssignInfo());
            }
            ormdao.executeBatch();
        }
        finally {
            this.cleanup(connection);
        }
    }

    public AssignmentInfo newForwardWorkItem(WfActivity activity, AssignmentInfo fromAsgnmnt, Person toPerson, boolean isSendMsg, String forwardType, Map extendMsg) throws WfException {
        Locale locale;
        if (!"devolve".equals(forwardType) && !"forward".equals(forwardType)) {
            throw new IllegalArgumentException();
        }
        Locale[] locales = this.getLocales();
        ActivityDef actDef = activity.getDefinition();
        Map subjects = null;
        Map bodies = null;
        if (actDef instanceof ManpowerActivityDef) {
            subjects = WfMessageUtil.getMessageTitles(activity, locales);
            bodies = WfMessageUtil.getMessageContents(activity, locales);
        }
        if (extendMsg != null && "forward".equals(forwardType)) {
            for (Map.Entry entry : extendMsg.entrySet()) {
                locale = (Locale)entry.getKey();
                Object value = entry.getValue();
                StringBuffer buffer = new StringBuffer();
                if (!StringUtils.isEmpty((String)((String)bodies.get(locale)))) {
                    String msgBody = (String)bodies.get(locale);
                    buffer.append(msgBody);
                }
                if (!StringUtils.isEmpty((String)((String)value))) {
                    String msgExtend = (String)value;
                    String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELIVER_OPINION", locale);
                    buffer.append("\n\n/*" + resource + "\n" + msgExtend + "*/\n");
                }
                bodies.put(locale, buffer.toString());
            }
        }
        if ("devolve".equals(forwardType)) {
            int size = locales.length;
            for (int i = 0; i < size; ++i) {
                locale = locales[i];
                StringBuffer buffer = new StringBuffer();
                String body = StringUtils.isEmpty((String)((String)bodies.get(locale))) ? "" : (String)bodies.get(locale);
                buffer.append(body);
                String resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELEGATE_USER", locale);
                buffer.append("\n\n/*" + resource + fromAsgnmnt.getAssignInfo().getPersonUserName(locale) + "*/\n");
                bodies.put(locale, buffer.toString());
            }
        }
        ProcessDefInfo procDefMeta = activity.container().manager().getData();
        ProcessInstInfo procInstMeta = activity.container().getData();
        Timestamp ct = new Timestamp(System.currentTimeMillis());
        String workItemId = Uuid.create().toString() + "WFWKITEM";
        ForwardStep forwardStep = new ForwardStep();
        forwardStep.setType(forwardType);
        forwardStep.setFromAssignment(fromAsgnmnt.getAssignmentId());
        forwardStep.setToAssignment(workItemId);
        AssignInfo ai = new AssignInfo();
        ai.setAssignID(BOSUuid.read((String)workItemId));
        for (int i = 0; i <= locales.length - 1; ++i) {
            Locale lcl = locales[i];
            String temp = StringUtils.cnulls(subjects.get(lcl));
            if (StringUtils.isEmpty((String)temp)) {
                temp = null;
            }
            ai.setSubject(temp, lcl);
            temp = StringUtils.cnulls(bodies.get(lcl));
            if (StringUtils.isEmpty((String)temp)) {
                temp = null;
            }
            ai.setBody(temp, lcl);
            ai.setPersonUserName(toPerson.getUserName(lcl), lcl);
            ai.setPersonEmpName(toPerson.getEmployeeName(lcl), lcl);
            String actName = actDef.getName(lcl);
            if (StringUtils.isEmpty((String)actName)) {
                actName = null;
            }
            ai.setActdefName(actName, lcl);
            ai.setProcdefName(procDefMeta.getProcDefName(lcl), lcl);
            ai.setPriorPerformName(fromAsgnmnt.getAssignInfo().getPriorPerformName(lcl), lcl);
        }
        ai.setPriorPerformerID(fromAsgnmnt.getAssignInfo().getPriorPerformerID());
        ai.setIsSupportMobile(fromAsgnmnt.getAssignInfo().isIsSupportMobile());
        int asgndi = WfAssignmentState.ASSIGNED.getValue();
        WfAssignmentState wfase = WfAssignmentState.getEnum((int)asgndi);
        ai.setState(wfase);
        ai.setPersonUserID(BOSUuid.read((String)toPerson.getUserId()));
        if (toPerson.getEmployeeId() != null && toPerson.getEmployeeId().length() > 0) {
            ai.setPersonEmpID(BOSUuid.read((String)toPerson.getEmployeeId()));
        } else {
            logger.error((Object)("Workflow Add WorkItem error: can't get employee by user.userId " + toPerson.getUserId()));
        }
        ai.setActInstID(BOSUuid.read((String)activity.getId()));
        ai.setActdefID(BOSUuid.read((String)actDef.getID()));
        ai.setProcdefhash(procDefMeta.getMd5HashValue());
        ai.setProcdefID(BOSUuid.read((String)procDefMeta.getProcDefId()));
        ai.setProcInstID(BOSUuid.read((String)procInstMeta.getProcInstId()));
        ai.setLastStateTime(ct);
        ai.setCreatedTime(ct);
        ai.setForwardPath(forwardStep.toXML());
        WorkItemStorer.copyAppInfo(fromAsgnmnt, ai);
        ai.setIsSendMsg(isSendMsg);
        return new AssignmentInfo(ai);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignmentInfo createWorkItem(WfActivity activity, Person person, String forwardPath, Map extendMsg, boolean isSendMsg) throws SQLException, DataAccessException, WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            AssignInfo ai = WorkItemStorer.createNewAssignInfo(this.innerContext, activity, person, forwardPath, extendMsg, isSendMsg);
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, cn);
            ormdao.addnew((IObjectValue)ai);
            if (this.isEnableListen()) {
                ProcessDefInfo def = StoreUtil.getProcessDefInfoByID(ai.getProcdefID().toString(), this.getContext());
                this.setDataChanged(StoreUtil.generateDaoDataByProcDef(this, this.getContext(), "addnew", WfBOSObjectTypeUtil.ASSIGNMENTBOT, new Object[]{ai}, def));
            }
            AssignmentInfo assignmentInfo = new AssignmentInfo(ai);
            return assignmentInfo;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private static AssignInfo getPreAssignInfo(WfActivity activity) throws WfException {
        AssignmentInfo[] assigninfo;
        WfEngine engine = activity.getWfEngine();
        WfProcess proc = engine.getProcessInst(activity.getProcInstId());
        String subActId = null;
        Object subLastAssign = null;
        Object finalAssign = null;
        HashMap<String, WfActivity> actMap = new HashMap<String, WfActivity>();
        for (WfActivity actInt : proc.activities()) {
            actMap.put(actInt.getId(), actInt);
        }
        ArrayList<String> allIds = new ArrayList<String>();
        String[] preIds = activity.getInstanceInfo().getPreActInstList();
        while (preIds != null && preIds.length > 0) {
            ArrayList<String> preList = new ArrayList<String>(2);
            for (int j = 0; j < preIds.length; ++j) {
                allIds.add(preIds[j]);
            }
            for (int i = 0; i < preIds.length; ++i) {
                WfActivity act = (WfActivity)actMap.get(preIds[i]);
                if (act == null) continue;
                ActivityDef def = act.getDefinition();
                if (def instanceof SubflowActivityDef) {
                    WfProcess subProc = act.getSubProcessInstance();
                    subLastAssign = subProc.getProcessContext().getDataFieldValue("$LAST_PROCESSED_ASSIGN$");
                    subActId = preIds[i];
                    break;
                }
                String[] ids = act.getInstanceInfo().getPreActInstList();
                if (ids == null) continue;
                for (int j = 0; j < ids.length; ++j) {
                    preList.add(ids[j]);
                }
            }
            if (subLastAssign == null && !preList.isEmpty()) {
                preIds = preList.toArray(new String[preList.size()]);
                continue;
            }
            preIds = null;
        }
        String parentactinstid = "";
        if (activity.getInstanceInfo().getData("parentactinstid") != null) {
            parentactinstid = activity.getInstanceInfo().getData("parentactinstid").toString();
        }
        if (!"".equals(parentactinstid) && (assigninfo = activity.getWfEngine().getAssignmentByActInstId(parentactinstid)) != null && assigninfo.length > 0) {
            return assigninfo[0].getAssignInfo();
        }
        Object lastAssign = proc.getProcessContext().getDataFieldValue("$LAST_PROCESSED_ASSIGN$");
        if (subLastAssign != null && subLastAssign instanceof String) {
            subLastAssign = WorkItemStorer.getAssignInfoById(engine, (String)subLastAssign);
        }
        if (lastAssign != null && lastAssign instanceof String) {
            lastAssign = WorkItemStorer.getAssignInfoById(engine, (String)lastAssign);
        }
        if (subLastAssign != null) {
            if (lastAssign == null) {
                finalAssign = subLastAssign;
            } else {
                String lastActId = ((AssignInfo)lastAssign).getActInstID().toString();
                int lastIndex = allIds.indexOf(lastActId);
                int subActIndex = allIds.indexOf(subActId);
                finalAssign = lastIndex > -1 && lastIndex < subActIndex ? lastAssign : subLastAssign;
            }
        } else if (lastAssign != null) {
            finalAssign = lastAssign;
        } else {
            String parentProcId = proc.getProcessMeta().getParentProcInstId();
            if (parentProcId != null) {
                WfProcess parentProc = engine.getProcessInst(parentProcId);
                Object parentLastAssign = parentProc.getProcessContext().getDataFieldValue("$LAST_PROCESSED_ASSIGN$");
                if (parentLastAssign != null && parentLastAssign instanceof String) {
                    parentLastAssign = WorkItemStorer.getAssignInfoById(engine, (String)parentLastAssign);
                }
                finalAssign = parentLastAssign;
            }
        }
        if (finalAssign != null) {
            return finalAssign;
        }
        return null;
    }

    private static AssignInfo getAssignInfoById(WfEngine engine, String id) throws WfException {
        WfAssignment assignment = engine.getAssignment(id);
        if (assignment != null) {
            return assignment.getAssignmentInfo().getAssignInfo();
        }
        return null;
    }

    private static AssignInfo createNewAssignInfo(Context ctx, WfActivity activity, Person person, String forwardPath, Map extendMsg, boolean isSendMsg) throws WfException {
        Locale[] lcla = ApplicationUtil.getContextLocales((Context)ctx);
        ActivityDef actDef = activity.getDefinition();
        Map subjects = null;
        Map bodies = null;
        ManpowerActivityDef manpowerDef = null;
        ApplicationDef appDef = null;
        FunctionDef funcDef = null;
        String appDefId = null;
        if (actDef instanceof ManpowerActivityDef) {
            manpowerDef = (ManpowerActivityDef)actDef;
            appDef = manpowerDef.getRelatedApplication();
            if (appDef != null) {
                funcDef = appDef.getFunction();
                appDefId = appDef.getID();
            }
            subjects = WfMessageUtil.getMessageTitles(activity, lcla);
            bodies = WfMessageUtil.getMessageContents(activity, lcla);
        }
        if (extendMsg != null) {
            for (Object o : extendMsg.keySet()) {
                Locale locale;
                if (!(o instanceof Locale) || StringUtils.isEmpty((String)((String)bodies.get(locale = (Locale)o)))) continue;
                String msgBody = (String)bodies.get(locale);
                if (StringUtils.isEmpty((String)((String)extendMsg.get(locale)))) continue;
                String msgExtend = (String)extendMsg.get(locale);
                StringBuffer buffer = new StringBuffer(msgBody);
                String resource = null;
                if (extendMsg.containsKey("assignCountersign")) {
                    resource = locale.equals(new Locale("l1")) ? "The following are countersigning comments\uff1a" : "\u4ee5\u4e0b\u662f\u4f1a\u7b7e\u53d1\u8d77\u4eba\u610f\u89c1\uff1a";
                    String msgTitle = (String)subjects.get(locale);
                    if (locale.equals(new Locale("l2"))) {
                        msgTitle = "\u4f1a\u7b7e[" + msgTitle + "]";
                    } else if (locale.equals(new Locale("l3"))) {
                        msgTitle = "\u6703\u7c3d[" + msgTitle + "]";
                    }
                    subjects.put(locale, msgTitle);
                } else {
                    resource = ResourceUtils.getString("com.kingdee.bos.workflow.metas.WorkflowResources", "DELIVER_OPINION", locale);
                }
                buffer.append("\n\n/*" + resource + "\n\n" + msgExtend + "*/\n");
                bodies.put(locale, buffer.toString());
            }
        }
        ProcessDefInfo procDefMeta = activity.container().manager().getData();
        ProcessInstInfo procInstMeta = activity.container().getData();
        Timestamp ct = new Timestamp(System.currentTimeMillis());
        String bizObjectId = null;
        if (funcDef != null || actDef instanceof WebBillManpowerActivityDef) {
            bizObjectId = WorkItemStorer.getBizObjIdList(manpowerDef, activity.container().getProcessContext());
        }
        String billEntity = null;
        if (bizObjectId != null) {
            billEntity = WorkItemStorer.getEntityFullNameByBoid(bizObjectId, ctx);
        }
        boolean mobileApprove = WorkItemStorer.isSupportedMobileApprove(actDef);
        AssignInfo ai = new AssignInfo();
        BOSUuid workItemId = BOSUuid.create((BOSObjectType)ai.getBOSType());
        ai.setAssignID(workItemId);
        forwardPath = forwardPath != null && forwardPath.length() > 0 ? forwardPath + ";" + workItemId + "," + person.getUserId() + "," + person.getUserName(Locale.ENGLISH) + "," + person.getEmployeeId() + person.getEmployeeName(Locale.ENGLISH) : " ";
        ai.setIsSupportMobile(mobileApprove);
        WfProcess proc = activity.getWfEngine().getProcessInst(activity.getProcInstId());
        AssignInfo priorAssign = WorkItemStorer.getPreAssignInfo(activity);
        ProcessInstInfo procInst = proc.getData();
        ai.setPriorPerformerID(priorAssign == null ? procInst.getInitiatorId() : priorAssign.getPersonUserID().toString());
        for (int i = 0; i <= lcla.length - 1; ++i) {
            Locale lcl = lcla[i];
            String temp = StringUtils.cnulls(subjects.get(lcl));
            ai.setSubject(temp, lcl);
            temp = StringUtils.cnulls(bodies.get(lcl));
            if (StringUtils.isEmpty((String)temp)) {
                temp = null;
            }
            ai.setBody(temp, lcl);
            ai.setPersonUserName(person.getUserName(lcl), lcl);
            ai.setPersonEmpName(person.getEmployeeName(lcl), lcl);
            String actName = activity.getMeta().getActDefName(lcl);
            if (actName == null) {
                actName = actDef.getName(lcl);
            }
            if (StringUtils.isEmpty((String)actName)) {
                actName = null;
            }
            ai.setActdefName(actName, lcl);
            ai.setProcdefName(procDefMeta.getProcDefName(lcl), lcl);
            String priorName = priorAssign == null ? procInst.getInitiatorName(lcl) : priorAssign.getPersonUserName(lcl);
            ai.setPriorPerformName(priorName, lcl);
        }
        ai.setState(WfAssignmentState.ASSIGNED);
        ai.setPersonUserID(BOSUuid.read((String)person.getUserId()));
        if (person.getEmployeeId() != null && person.getEmployeeId().length() > 0) {
            ai.setPersonEmpID(BOSUuid.read((String)person.getEmployeeId()));
        } else {
            logger.error((Object)("Workflow Add WorkItem error: can't get employee by user.userId " + person.getUserId()));
        }
        ai.setActInstID(BOSUuid.read((String)activity.getId()));
        ai.setActdefID(BOSUuid.read((String)actDef.getID()));
        ai.setProcdefhash(procDefMeta.getMd5HashValue());
        ai.setProcdefID(BOSUuid.read((String)procDefMeta.getProcDefId()));
        ai.setProcInstID(BOSUuid.read((String)procInstMeta.getProcInstId()));
        int p = activity.getDefinition().getActivityHeader().getpriority();
        p = p == -2 || p == -3 ? 0 : (p == -1 || p == 0 || p == 1 ? 10 : (p == 2 || p == 3 || p == 4 || p == 5 ? 20 : 10));
        ai.setPriority(p);
        ai.setLastStateTime(ct);
        ai.setCreatedTime(ct);
        ai.setForwardPath(forwardPath);
        if (funcDef != null) {
            ai.setBizPackage(funcDef.getPackageName());
            ai.setBizFunction(funcDef.getName());
            ai.setBizOperation(funcDef.getOperation());
            ai.setBizObjID(bizObjectId);
            ai.setAppdefID(BOSUuid.read((String)appDefId));
            ai.setBillEntity(billEntity);
        } else if (actDef instanceof WebBillManpowerActivityDef) {
            ai.setBizObjID(bizObjectId);
            ai.setBizOperation(((WebBillManpowerActivityDef)actDef).getOperation());
            ai.setAppdefID(BOSUuid.read((String)appDefId));
            ai.setBillEntity(billEntity);
        }
        ai.setIsSendMsg(isSendMsg);
        WorkItemStorer.createOption(ctx, ai.getActInstID(), ai.getAssignID(), priorAssign, person);
        return ai;
    }

    private static boolean isSupportedMobileApprove(ActivityDef actDef) {
        ExtendedAttributeDef ext = actDef.getActivityHeader().getExtendedAttributes().get("isPushToProcessAssist");
        if (ext != null) {
            String s = ext.getValue();
            if (StringUtils.isEmpty((String)s)) {
                return true;
            }
            return Boolean.valueOf(ext.getValue());
        }
        return true;
    }

    private static boolean createOption(Context ctx, BOSUuid actinstid, BOSUuid assignid, AssignInfo priorAssign, Person person) {
        try {
            IOption wfoption = OptionFactory.getLocalInstance((Context)ctx);
            OptionCollection optionCollection = wfoption.getOptionCollection("WHERE actinstID = '" + actinstid.toString() + "'");
            if (optionCollection != null) {
                for (int i = 0; i < optionCollection.size(); ++i) {
                    OptionInfo optioninfo = optionCollection.get(i);
                    if (optioninfo.getNextAssignid() != null) continue;
                    if (person.getEmployeeId() != null && person.getEmployeeId().length() > 0) {
                        optioninfo.setNextHandlerPersonID(person.getEmployeeId());
                    }
                    optioninfo.setNextAssignid(assignid);
                    wfoption.update((IObjectPK)new ObjectUuidPK(optioninfo.getId()), optioninfo);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static AssignmentInfo[] buildNewAssignmentInfos(Context ctx, WfActivity activity, List personList, String forwardPath, Map extendMsg, boolean isSendMsg) throws WfException {
        int size = personList.size();
        AssignmentInfo[] assignmentInfos = new AssignmentInfo[size];
        for (int i = 0; i < size; ++i) {
            AssignInfo assignInfo = WorkItemStorer.createNewAssignInfo(ctx, activity, (Person)personList.get(i), forwardPath, extendMsg, isSendMsg);
            assignmentInfos[i] = new AssignmentInfo(assignInfo);
        }
        if (extendMsg != null && extendMsg.containsKey("assignCountersign") && extendMsg.get("counterSignInfo") != null) {
            HashMap counterSignMap = (HashMap)extendMsg.get("counterSignInfo");
            WorkItemStorer.storeCounterSignInfo(counterSignMap, ctx, assignmentInfos);
        }
        return assignmentInfos;
    }

    public static void storeCounterSignInfo(HashMap map, Context ctx, AssignmentInfo[] assignmentInfos) throws WfException {
        Connection cn = null;
        PreparedStatement ps = null;
        String sql = new StringBuffer(500).append("INSERT INTO T_WFR_CounterSign").append(" (FID, FCOUNTERSIGNINITIATOR, FINITIATORNAME_L1, FINITIATORNAME_L2, FINITIATORNAME_L3, ").append(" FASSIGNOPINION_L1, FASSIGNOPINION_L2, FASSIGNOPINION_L3, ").append(" FCREATEDTIME,FASSIGNID").append(')').append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)").toString();
        HashMap initiatorMap = (HashMap)map.get("counterSignInitiator");
        HashMap counterSignComment = (HashMap)map.get("counterSignComment");
        try {
            cn = WfDbUtil.getConnection((Context)ctx);
            ps = cn.prepareStatement(sql);
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            for (int i = 0; i < assignmentInfos.length; ++i) {
                AssignmentInfo assignInfo = assignmentInfos[i];
                ps.setString(1, BOSUuid.create((String)"DYNMSIGN").toString());
                ps.setString(2, (String)initiatorMap.get("counterSignInitiatorID"));
                ps.setString(3, (String)initiatorMap.get(l1));
                ps.setString(4, (String)initiatorMap.get(l2));
                ps.setString(5, (String)initiatorMap.get(l3));
                ps.setString(6, (String)counterSignComment.get(l1));
                ps.setString(7, (String)counterSignComment.get(l2));
                ps.setString(8, (String)counterSignComment.get(l3));
                ps.setTimestamp(9, new Timestamp(new Date().getTime()));
                ps.setString(10, assignInfo.getAssignmentId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    public void addNewBatch(List assignInfos) throws WfException {
        Connection cn = null;
        PreparedStatement ps = null;
        String sql = new StringBuffer(500).append("INSERT INTO T_WFR_Assign ").append(" (FASSIGNID, FBODY_L1, FBODY_L2, FBODY_L3, FSTATE, FPERSONUSERID, ").append(" FPERSONUSERNAME_L1, FPERSONUSERNAME_L2, FPERSONUSERNAME_L3, ").append(" FPERSONEMPID, FPERSONEMPNAME_L1, FPERSONEMPNAME_L2, FPERSONEMPNAME_L3, ").append(" FPERFORMERUID, FPERFORMERUNAME_L1, FPERFORMERUNAME_L2, FPERFORMERUNAME_L3, ").append(" FPERFORMEREID, FPERFORMERENAME_L1, FPERFORMERENAME_L2, FPERFORMERENAME_L3, ").append(" FACTINSTID, FACTDEFID, FACTDEFNAME_L1, FACTDEFNAME_L2, FACTDEFNAME_L3, ").append(" FPROCDEFHASH, FPROCDEFID, FPROCDEFNAME_L1, FPROCDEFNAME_L2, FPROCDEFNAME_L3, ").append(" FPROCINSTID, FENDTIME, FLASTSTATETIME, FCREATEDTIME, FFORWARDPATH, FEXTATTR, ").append(" FACCEPTTIME, FBIZPACKAGE, FBIZFUNCTION, FBIZOPERATION, FBIZOBJID, FAPPDEFID, FPRIORITY, ").append(" FDURATION, FWORKINGTIME, FWAITINGTIME, FISSENDMSG, ").append(" FSUBJECT_L1, FSUBJECT_L2, FSUBJECT_L3").append(",FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3, FBILLENTITY").append(" ,FResponsibleEmpId, FSourceAssignId, FisSupportMobile").append(')').append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?,?, ?, ?, ?, ?, ?, ? ,? ,?,? ,?, ?, ? ,? ,?, ").append("?, ?, ?, ?, ?, ?, ? ,? ,? ,?, ?, ?, ?, ?, ?, ?, ?,?,? )").toString();
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement(sql);
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            int size = assignInfos.size();
            for (int i = 0; i < size; ++i) {
                AssignInfo assignInfo = (AssignInfo)assignInfos.get(i);
                ps.setString(1, assignInfo.getAssignID().toString());
                String bodyL1 = assignInfo.getBody(l1);
                ps.setString(2, bodyL1);
                String bodyL2 = assignInfo.getBody(l2);
                ps.setString(3, bodyL2);
                String bodyL3 = assignInfo.getBody(l3);
                ps.setString(4, bodyL3);
                ps.setInt(5, assignInfo.getState().getValue());
                ps.setString(6, assignInfo.getPersonUserID().toString());
                String personUserNameL1 = assignInfo.getPersonUserName(l1);
                if (personUserNameL1 == null) {
                    ps.setNull(7, 12);
                } else {
                    ps.setString(7, personUserNameL1);
                }
                String personUserNameL2 = assignInfo.getPersonUserName(l2);
                if (personUserNameL2 == null) {
                    ps.setNull(8, 12);
                } else {
                    ps.setString(8, personUserNameL2);
                }
                String personUserNameL3 = assignInfo.getPersonUserName(l3);
                if (personUserNameL3 == null) {
                    ps.setNull(9, 12);
                } else {
                    ps.setString(9, personUserNameL3);
                }
                BOSUuid personEmpID = assignInfo.getPersonEmpID();
                if (personEmpID == null) {
                    ps.setNull(10, 12);
                } else {
                    ps.setString(10, assignInfo.getPersonEmpID().toString());
                }
                String personEmpNameL1 = assignInfo.getPersonEmpName(l1);
                if (personEmpNameL1 == null) {
                    ps.setNull(11, 12);
                } else {
                    ps.setString(11, personEmpNameL1);
                }
                String personEmpNameL2 = assignInfo.getPersonEmpName(l2);
                if (personEmpNameL2 == null) {
                    ps.setNull(12, 12);
                } else {
                    ps.setString(12, personEmpNameL2);
                }
                String personEmpNameL3 = assignInfo.getPersonEmpName(l3);
                if (personEmpNameL3 == null) {
                    ps.setNull(13, 12);
                } else {
                    ps.setString(13, personEmpNameL3);
                }
                BOSUuid performerUID = assignInfo.getPerformerUID();
                if (performerUID == null) {
                    ps.setNull(14, 12);
                } else {
                    ps.setString(14, performerUID.toString());
                }
                String performerUNameL1 = assignInfo.getPerformerUName(l1);
                if (performerUNameL1 == null) {
                    ps.setNull(15, 12);
                } else {
                    ps.setString(15, performerUNameL1);
                }
                String performerUNameL2 = assignInfo.getPerformerUName(l2);
                if (performerUNameL2 == null) {
                    ps.setNull(16, 12);
                } else {
                    ps.setString(16, performerUNameL2);
                }
                String performerUNameL3 = assignInfo.getPerformerUName(l3);
                if (performerUNameL3 == null) {
                    ps.setNull(17, 12);
                } else {
                    ps.setString(17, performerUNameL3);
                }
                BOSUuid performerEID = assignInfo.getPerformerEID();
                if (performerEID == null) {
                    ps.setNull(18, 12);
                } else {
                    ps.setString(18, assignInfo.getPerformerEID().toString());
                }
                String performerENameL1 = assignInfo.getPerformerEName(l1);
                if (performerENameL1 == null) {
                    ps.setNull(19, 12);
                } else {
                    ps.setString(19, performerENameL1);
                }
                String performerENameL2 = assignInfo.getPerformerEName(l2);
                if (performerENameL2 == null) {
                    ps.setNull(20, 12);
                } else {
                    ps.setString(20, performerENameL2);
                }
                String performerENameL3 = assignInfo.getPerformerEName(l3);
                if (performerENameL3 == null) {
                    ps.setNull(21, 12);
                } else {
                    ps.setString(21, performerENameL3);
                }
                ps.setString(22, assignInfo.getActInstID().toString());
                ps.setString(23, assignInfo.getActdefID().toString());
                String actDefNameL1 = assignInfo.getActdefName(l1);
                if (actDefNameL1 == null) {
                    ps.setNull(24, 12);
                } else {
                    ps.setString(24, actDefNameL1);
                }
                String actDefNameL2 = assignInfo.getActdefName(l2);
                if (actDefNameL2 == null) {
                    ps.setNull(25, 12);
                } else {
                    ps.setString(25, actDefNameL2);
                }
                String actDefNameL3 = assignInfo.getActdefName(l3);
                if (actDefNameL3 == null) {
                    ps.setNull(26, 12);
                } else {
                    ps.setString(26, actDefNameL3);
                }
                ps.setString(27, assignInfo.getProcdefhash());
                ps.setString(28, assignInfo.getProcdefID().toString());
                String procDefNameL1 = assignInfo.getProcdefName(l1);
                if (procDefNameL1 == null) {
                    ps.setNull(29, 12);
                } else {
                    ps.setString(29, procDefNameL1);
                }
                String procDefNameL2 = assignInfo.getProcdefName(l2);
                if (procDefNameL2 == null) {
                    ps.setNull(30, 12);
                } else {
                    ps.setString(30, procDefNameL2);
                }
                String procDefNameL3 = assignInfo.getProcdefName(l3);
                if (procDefNameL3 == null) {
                    ps.setNull(31, 12);
                } else {
                    ps.setString(31, procDefNameL3);
                }
                ps.setString(32, assignInfo.getProcInstID() == null ? null : assignInfo.getProcInstID().toString());
                Timestamp endTime = assignInfo.getEndTime();
                if (endTime == null) {
                    ps.setNull(33, 93);
                } else {
                    ps.setTimestamp(33, assignInfo.getEndTime());
                }
                ps.setTimestamp(34, assignInfo.getLastStateTime());
                ps.setTimestamp(35, assignInfo.getCreatedTime());
                ps.setString(36, assignInfo.getForwardPath());
                byte[] bytesExtarrt = assignInfo.getExtattr();
                if (bytesExtarrt == null) {
                    ps.setBytes(37, null);
                } else {
                    ps.setBinaryStream(37, (InputStream)new SerializableByteArrayInputStream(bytesExtarrt), bytesExtarrt.length);
                }
                Timestamp acceptTime = assignInfo.getAcceptTime();
                if (acceptTime == null) {
                    ps.setNull(38, 93);
                } else {
                    ps.setTimestamp(38, acceptTime);
                }
                String bizPackage = assignInfo.getBizPackage();
                if (bizPackage == null) {
                    ps.setNull(39, 12);
                } else {
                    ps.setString(39, bizPackage);
                }
                String bizFunction = assignInfo.getBizFunction();
                if (bizFunction == null) {
                    ps.setNull(40, 12);
                } else {
                    ps.setString(40, bizFunction);
                }
                String bizOperation = assignInfo.getBizOperation();
                if (bizOperation == null) {
                    ps.setNull(41, 12);
                } else {
                    ps.setString(41, bizOperation);
                }
                String bizObjectID = assignInfo.getBizObjID();
                if (bizObjectID == null) {
                    ps.setNull(42, 12);
                } else {
                    ps.setString(42, bizObjectID);
                }
                BOSUuid appDefID = assignInfo.getAppdefID();
                if (appDefID == null) {
                    ps.setNull(43, 12);
                } else {
                    ps.setString(43, appDefID.toString());
                }
                ps.setInt(44, assignInfo.getPriority());
                ps.setInt(45, assignInfo.getDuration());
                ps.setInt(46, assignInfo.getWorkingTime());
                ps.setInt(47, assignInfo.getWaitingTime());
                ps.setInt(48, assignInfo.isIsSendMsg() ? 1 : 0);
                String subjectL1 = assignInfo.getSubject(l1);
                if (subjectL1 == null) {
                    ps.setNull(49, 12);
                } else {
                    ps.setString(49, subjectL1);
                }
                String subjectL2 = assignInfo.getSubject(l2);
                if (subjectL2 == null) {
                    ps.setNull(50, 12);
                } else {
                    ps.setString(50, subjectL2);
                }
                String subjectL3 = assignInfo.getSubject(l3);
                if (subjectL3 == null) {
                    ps.setNull(51, 12);
                } else {
                    ps.setString(51, subjectL3);
                }
                int p = 52;
                String tmp = assignInfo.getPriorPerformerID();
                if (tmp == null) {
                    ps.setNull(p, 12);
                } else {
                    ps.setString(p, tmp);
                }
                ++p;
                for (int k = 1; k <= 3; ++k) {
                    tmp = assignInfo.getPriorPerformName(new Locale("L" + k));
                    if (tmp == null) {
                        ps.setNull(p, 12);
                    } else {
                        ps.setString(p, tmp);
                    }
                    ++p;
                }
                String billEntity = assignInfo.getBillEntity();
                if (billEntity == null) {
                    ps.setNull(p, 12);
                } else {
                    ps.setString(p, billEntity);
                }
                ++p;
                String responsible = assignInfo.getResponsibleEmpId();
                if (responsible == null) {
                    ps.setNull(p, 12);
                } else {
                    ps.setString(p, responsible);
                }
                ++p;
                String source = assignInfo.getSourceAssignId();
                if (source == null) {
                    ps.setNull(p, 12);
                } else {
                    ps.setString(p, source);
                }
                ++p;
                boolean isSupportMobile = assignInfo.isIsSupportMobile();
                if (isSupportMobile) {
                    ps.setInt(p, 1);
                } else {
                    ps.setInt(p, 0);
                }
                ++p;
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        WfAssignmentCounter.increase(this.innerContext, assignInfos.size());
        if (this.isEnableListen() && assignInfos.size() > 0) {
            AssignInfo info = (AssignInfo)assignInfos.get(0);
            String procInstId = info.getProcInstID().toString();
            this.notifyDataChangedByProcInstId(procInstId, "addNewBatch", new Class[]{List.class}, new Object[]{assignInfos});
        }
    }

    public AssignmentInfo getWorkItem(String assignmentId) throws SQLException, BOSException {
        try {
            return this.getWorkItem(assignmentId, (String)null);
        }
        catch (Exception ex) {
            if (ex instanceof BOSException) {
                throw (BOSException)((Object)ex);
            }
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new BOSException((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private AssignmentInfo getWorkItem(String assignmentId, String oql) throws SQLException, BOSException, ParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AssignmentInfo getWorkItem(String workItemId, String[] selectors) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if (selectors != null && selectors.length > 0) {
            sql.append(" SELECT ");
            sql.append(StringUtils.arrayToString((Object[])selectors, (String)","));
        }
        try {
            return this.getWorkItem(workItemId, sql.toString());
        }
        catch (BOSException e) {
            throw e;
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw e;
        }
    }

    public AssignmentInfo[] getWorkItemListByActInstId(String activityId) throws SQLException, BOSException {
        AssignmentInfo[] result = this.getWorkItemListByActInstId(activityId, DataTypeEnum.RUNTIME);
        return result;
    }

    public AssignmentInfo[] getWorkItemListByActInstId(String actInstId, DataTypeEnum dataType) throws SQLException, BOSException {
        String cndtn = "(actinstID = '" + actInstId + "')";
        String oql = "WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByActInstId(actInstId, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByActInstId(actInstId, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public AssignmentInfo[] getWorkItemListByIds(String[] assignmentIds, DataTypeEnum dataType) throws SQLException, BOSException {
        if (assignmentIds == null || assignmentIds.length == 0) {
            return new AssignmentInfo[0];
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= assignmentIds.length - 1; ++i) {
            if (buffer.length() > 0) {
                buffer.append(" OR ");
            }
            buffer.append("(assignID = '" + assignmentIds[i] + "')");
        }
        buffer.insert(0, " WHERE ");
        String oql = buffer.toString();
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByIds(assignmentIds, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByIds(assignmentIds, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public AssignmentInfo[] getWorkItemListByProcInstId(String procInstId) throws SQLException, BOSException {
        AssignmentInfo[] result = this.getWorkItemListByProcInstId(procInstId, DataTypeEnum.RUNTIME);
        return result;
    }

    public AssignmentInfo[] getWorkItemListByProcInstId(String procInstId, DataTypeEnum dataType) throws SQLException, BOSException {
        String cndtn = "(procinstID = '" + procInstId + "')";
        String oql = "WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByProcInstId(procInstId, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByProcInstId(procInstId, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public AssignmentInfo[] getWorkItemListByOwnerId(String ownerPersonUserId) throws SQLException, BOSException {
        return this.getWorkItemListByOwnerId(ownerPersonUserId, DataTypeEnum.RUNTIME);
    }

    public AssignmentInfo[] getWorkItemListByOwnerId(String ownerPersonUserId, DataTypeEnum dataType) throws SQLException, BOSException {
        String cndtn = "(personUserID = '" + ownerPersonUserId + "')";
        String oql = "WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByOwnerId(ownerPersonUserId, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByOwnerId(ownerPersonUserId, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public AssignmentInfo[] getWorkItemListByProcInstAndOwner(String procInstId, String ownerPersonUserId, WfAssignmentState assignmentState) throws SQLException, BOSException {
        return this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, assignmentState, DataTypeEnum.RUNTIME);
    }

    public AssignmentInfo[] getWorkItemListByProcInstAndOwner(String procInstId, String ownerPersonUserId, WfAssignmentState assignmentState, DataTypeEnum dataType) throws SQLException, BOSException {
        String cndtn0 = "(procinstID = '" + procInstId + "')";
        String cndtn1 = "(personUserID = '" + ownerPersonUserId + "')";
        String cndtn2 = "(state = " + assignmentState.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1 + " and " + cndtn2;
        String oql = "WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, assignmentState, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, assignmentState, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    private AssignmentInfo[] getActivedWorkItemListByBizInfo(String businessObjId, String userId, String packageName, String functionName, String operation, DataTypeEnum dataType, String[] selectors) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (selectors != null && selectors.length > 0) {
            sql.append(" SELECT ");
            sql.append(StringUtils.arrayToString((Object[])selectors, (String)","));
        }
        sql.append(" WHERE ");
        sql.append(" (bizObjID = '" + businessObjId + "')");
        sql.append(" AND (personUserID = '" + userId + "')");
        sql.append(" AND (bizPackage = '" + packageName + "')");
        sql.append(" AND (bizFunction = '" + functionName + "')");
        sql.append(" AND (bizOperation = '" + operation + "')");
        String accept = Integer.toString(WfAssignmentState.ACCEPTED.getValue());
        String assign = Integer.toString(WfAssignmentState.ASSIGNED.getValue());
        sql.append(" AND (state = " + accept + " or state = " + assign + ")");
        return this.getActivedAssignmentInfoArray(sql.toString());
    }

    private AssignmentInfo[] getWorkItemListByBizInfo(String businessObjId, String userId, String packageName, String functionName, String operation, DataTypeEnum dataType, String[] selectors) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (selectors != null && selectors.length > 0) {
            sql.append(" SELECT ");
            sql.append(StringUtils.arrayToString((Object[])selectors, (String)","));
        }
        sql.append(" WHERE ");
        sql.append(" (bizObjID = '" + businessObjId + "')");
        sql.append(" AND (personUserID = '" + userId + "')");
        sql.append(" AND (bizPackage = '" + packageName + "')");
        sql.append(" AND (bizFunction = '" + functionName + "')");
        sql.append(" AND (bizOperation = '" + operation + "')");
        String accept = Integer.toString(WfAssignmentState.ACCEPTED.getValue());
        String assign = Integer.toString(WfAssignmentState.ASSIGNED.getValue());
        sql.append(" AND (state = " + accept + " or state = " + assign + ")");
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(sql.toString());
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(sql.toString());
        }
        throw new IllegalArgumentException();
    }

    public AssignmentInfo[] getActivedWorkItemListByBizInfo(String businessObjId, String userId, String[] selector) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (selector != null && selector.length > 0) {
            sql.append("select " + StringUtils.arrayToString((Object[])selector, (String)",") + " ");
        }
        sql.append(" WHERE ");
        sql.append("(bizObjID = '" + businessObjId + "')");
        sql.append("AND (personUserID = '" + userId + "')");
        String accept = Integer.toString(WfAssignmentState.ACCEPTED.getValue());
        String assign = Integer.toString(WfAssignmentState.ASSIGNED.getValue());
        sql.append(" AND (state = " + accept + " or state = " + assign + ")");
        return this.getActivedAssignmentInfoArray(sql.toString());
    }

    public AssignmentInfo[] getActivedWorkItemListByBizInfo(String userId, String[] selector) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (selector != null && selector.length > 0) {
            sql.append("select " + StringUtils.arrayToString((Object[])selector, (String)",") + " ");
        }
        sql.append(" WHERE ");
        sql.append(" (personUserID = '" + userId + "')");
        String accept = Integer.toString(WfAssignmentState.ACCEPTED.getValue());
        String assign = Integer.toString(WfAssignmentState.ASSIGNED.getValue());
        sql.append(" AND (state = " + accept + " or state = " + assign + ")");
        return this.getActivedAssignmentInfoArray(sql.toString());
    }

    public AssignmentInfo[] getWorkItemListByBizInfo(String businessObjId, String userId, DataTypeEnum dataType, String[] selector) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (selector != null && selector.length > 0) {
            sql.append("select " + StringUtils.arrayToString((Object[])selector, (String)",") + " ");
        }
        sql.append(" WHERE ");
        sql.append("(bizObjID = '" + businessObjId + "')");
        sql.append("AND (personUserID = '" + userId + "')");
        String accept = Integer.toString(WfAssignmentState.ACCEPTED.getValue());
        String assign = Integer.toString(WfAssignmentState.ASSIGNED.getValue());
        sql.append(" AND (state = " + accept + " or state = " + assign + ")");
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(sql.toString());
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(sql.toString());
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByBizInfo(businessObjId, userId, DataTypeEnum.RUNTIME, selector);
            AssignmentInfo[] history = this.getWorkItemListByBizInfo(businessObjId, userId, DataTypeEnum.HISTORY, selector);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public AssignmentInfo[] getWorkItemListByBizInfo(String businessObjId, String userId, String packageName, String functionName, String operation, String[] selectors) throws SQLException, BOSException {
        AssignmentInfo[] result = this.getWorkItemListByBizInfo(businessObjId, userId, packageName, functionName, operation, DataTypeEnum.RUNTIME, selectors);
        return result;
    }

    public AssignmentInfo[] getActivedWorkItemListByBizInfo(String businessObjId, String userId, String packageName, String functionName, String operation, String[] selectors) throws SQLException, BOSException {
        AssignmentInfo[] result = this.getActivedWorkItemListByBizInfo(businessObjId, userId, packageName, functionName, operation, DataTypeEnum.RUNTIME, selectors);
        return result;
    }

    public AssignmentInfo[] getWorkItemListByProcInstAndOwner(String procInstId, String ownerPersonUserId) throws SQLException, BOSException {
        AssignmentInfo[] result = this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, DataTypeEnum.RUNTIME);
        return result;
    }

    public AssignmentInfo[] getWorkItemListByProcInstAndOwner(String procInstId, String ownerPersonUserId, DataTypeEnum dataType) throws SQLException, BOSException {
        String cndtn0 = "(procinstID = '" + procInstId + "')";
        String cndtn1 = "(personUserID = '" + ownerPersonUserId + "')";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "WHERE " + cndtn;
        if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
            return this.getAssignmentInfoArray(oql);
        }
        if (DataTypeEnum.HISTORY.equals((Object)dataType)) {
            return this.getAssignmentInfoArray_Hst(oql);
        }
        if (DataTypeEnum.ALL.equals((Object)dataType)) {
            AssignmentInfo[] run = this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, DataTypeEnum.RUNTIME);
            AssignmentInfo[] history = this.getWorkItemListByProcInstAndOwner(procInstId, ownerPersonUserId, DataTypeEnum.HISTORY);
            return StoreUtils.catAssignmentInfoArray((AssignmentInfo[])run, (AssignmentInfo[])history);
        }
        String message = "\"dataType\" is " + dataType + "!";
        throw new IllegalArgumentException(message);
    }

    public boolean exist(String assignmentID) throws WfException {
        boolean bl;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            int dbType = ApplicationUtil.getDbType((Context)this.innerContext);
            String sql = dbType == 3 ? "/*dialect*/SELECT 1 WHERE EXISTS(SELECT 1 FROM T_WFR_ASSIGN WITH (READPAST) WHERE FASSIGNID = ?)" : "SELECT 1 WHERE EXISTS(SELECT 1 FROM T_WFR_ASSIGN WHERE FASSIGNID = ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, assignmentID);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(rs, stmt, conn);
        return bl;
    }

    private String getWhereSQL(String prefix, ArrayList unit) {
        StringBuffer whereSQL = new StringBuffer(200);
        Object[] arrayID = unit.toArray(new String[unit.size()]);
        int length = arrayID.length;
        for (int i = 0; i < length; ++i) {
            arrayID[i] = new StringBuffer("'").append((String)arrayID[i]).append("'").toString();
        }
        String partSQL = StringUtils.arrayToString((Object[])arrayID, (String)",");
        whereSQL.append(" WHERE ").append(prefix).append("FASSIGNID IN (").append(partSQL).append(") ");
        whereSQL.append(" and not exists( select 1 from T_WFR_ASSIGNDETAIL detail where Assign.FASSIGNID = detail.FASSIGNID) ");
        return whereSQL.toString();
    }

    public void dumpTx(Set assignmentIDs) throws WfException {
        this.dumpTx(assignmentIDs, true);
    }

    public void dumpTx(Set assignmentIDs, boolean triggerListener) throws WfException {
        Class<?> cls = this.getClass();
        Class[] ptypes = new Class[]{Set.class, Boolean.TYPE};
        Object[] params = new Object[]{assignmentIDs, triggerListener};
        try {
            Method m = ObjectFactory.getMethod(cls, (String)"dump", (Class[])ptypes);
            ObjectFactory.invokeRequired((Object)this, (Method)m, (Object[])params);
        }
        catch (Exception e) {
            throw new WfException("dump failed", (Throwable)e);
        }
    }

    public void dump(Set assignmentIDs) throws WfException {
        this.dump(assignmentIDs, true);
    }

    public void dump(Set assignmentIDs, boolean triggerListener) throws WfException {
        StringBuffer executeDumpSQL = null;
        ArrayList<String> unit = null;
        int count = 0;
        int index = 0;
        int size = assignmentIDs.size();
        StringBuilder assignFilter = new StringBuilder();
        Iterator iterator = assignmentIDs.iterator();
        while (iterator.hasNext()) {
            if (index == 0) {
                unit = new ArrayList<String>();
                executeDumpSQL = new StringBuffer(1000);
                assignFilter = new StringBuilder();
            }
            ++index;
            ++count;
            String assignmentID = (String)iterator.next();
            unit.add(assignmentID);
            assignFilter.append("'").append(assignmentID).append("',");
            boolean canDump = index < 100 && count == size || index >= 100;
            if (!canDump) continue;
            executeDumpSQL.append(DUMP_ASSIGN_SQL).append(this.getWhereSQL("Assign.", unit));
            Connection conn = null;
            Statement statement = null;
            try {
                conn = this.getConnection();
                statement = conn.createStatement();
                String updateSql = "update t_wfr_assigndetail set flatestassign = 0 where fprocinstid = ( select fprocinstid from t_wfr_assign where fassignid = '" + unit.get(0) + "')  and fpersonuserid in (select fpersonuserid from t_wfr_assign where fassignid in (" + assignFilter.substring(0, assignFilter.length() - 1) + "))";
                statement.execute(updateSql);
                int effectCount = statement.executeUpdate(executeDumpSQL.toString());
                int unitCount = unit.size();
                if (effectCount != unitCount) {
                    int assigndetailCount;
                    logger.error((Object)("************dump error: effectCount = " + effectCount + " unitSize=" + unitCount + " whereSQL:" + this.getWhereSQL("Assign.", unit)));
                    String sql = "select count(*) as count from t_wfr_assigndetail where fassignid in (" + assignFilter.substring(0, assignFilter.length() - 1) + ")";
                    ResultSet rowset = statement.executeQuery(sql);
                    if (rowset.next() && (assigndetailCount = rowset.getInt("count")) != unitCount) continue;
                }
                this.dumpInner(triggerListener, unit, conn);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            finally {
                index = 0;
                SQLUtils.cleanup((Statement)statement, (Connection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInner(boolean triggerListener, ArrayList unit, Connection conn) throws WfException, SQLException {
        if (triggerListener) {
            AssignmentDeletionEvent[] events = this.transformToEvents(unit);
            AssignmentWorkerManager.getInstance(this.innerContext).fireDeleteAssignmentEvent(events);
        } else {
            PreparedStatement ps = null;
            try {
                ps = conn.prepareStatement("DELETE FROM T_WFR_Assign WHERE FASSIGNID = ?");
                for (int i = 0; i < unit.size(); ++i) {
                    ps.setString(1, (String)unit.get(i));
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)ps);
            }
        }
    }

    private AssignmentDeletionEvent[] transformToEvents(ArrayList assignmentIDs) throws WfException {
        AssignmentDeletionEvent[] events = new AssignmentDeletionEvent[assignmentIDs.size()];
        WfEngine engine = WfEngine.getEngine(this.innerContext);
        int size = assignmentIDs.size();
        for (int i = 0; i < size; ++i) {
            AssignmentDeletionEvent event = new AssignmentDeletionEvent();
            String assignmentID = assignmentIDs.get(i).toString();
            AssignInfo assignInfo = engine.getAssignment(assignmentID).getMeta().getAssignInfo();
            event.assignmentId = assignmentID;
            event.solution = this.innerContext.getSolution();
            event.datacenter = this.innerContext.getAIS();
            event.receiverID = assignInfo.getPersonUserID().toString();
            events[i] = event;
        }
        return events;
    }

    public AssignCollection getUncompleteAssignments(String userID) throws WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO dao = this.getDAO(WfBOSObjectTypeUtil.ASSIGNMENTBOT, cn);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("personUserID", (Object)userID));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
            filterInfo.setMaskString("#0 AND (#1 OR #2)");
            entityViewInfo.setFilter(filterInfo);
            AssignCollection assignCollection = (AssignCollection)dao.getCollection(entityViewInfo);
            return assignCollection;
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static String getEntityFullNameByBoid(String billId, Context ctx) {
        if (billId == null) {
            return null;
        }
        String[] boid = billId.split(",");
        BOSObjectType bosType = BOSUuid.read((String)boid[0]).getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = null;
        try {
            bo = loader.getEntity(bosType);
        }
        catch (Exception e) {
            bo = null;
        }
        if (bo != null) {
            return bo.getFullName();
        }
        return null;
    }

    public Map<String, List<String>> getCurrentAssignIds(Context ctx, String userId, String[] billIdArr, String bizPackage, String bizFuncion, String bizOperation) throws Exception {
        if (StringUtils.isEmpty((String)userId)) {
            throw new IllegalArgumentException("userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (billIdArr == null) {
            throw new IllegalArgumentException("billIdArr\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)bizPackage)) {
            throw new IllegalArgumentException("bizPackage\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)bizFuncion)) {
            throw new IllegalArgumentException("bizFuncion\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)bizOperation)) {
            throw new IllegalArgumentException("bizOperation\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> billIdList = this.getBillInWf(ctx, billIdArr);
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (int i = 0; i < billIdArr.length; ++i) {
            if (this.isBillInWf(billIdArr[i], billIdList)) {
                List<String> l = this.getAssignIds(ctx, userId, billIdArr[i], bizPackage, bizFuncion, bizOperation);
                ret.put(billIdArr[i], l);
                continue;
            }
            ret.put(billIdArr[i], null);
        }
        return ret;
    }

    private List<String> getBillInWf(Context ctx, String[] billIdArr) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer ids = new StringBuffer();
        for (String id : billIdArr) {
            ids.append("'").append(id).append("',");
        }
        ids.setLength(ids.length() - 1);
        String sql = "SELECT R.FREFID FROM T_WFR_PROCINSTREF R INNER JOIN T_WFR_PROCINST P ON R.FPROCINSTID = P.FPROCINSTID WHERE P.FSTATE LIKE 'open%' and R.FREFID in(" + ids + ") AND R.FTYPE = 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs != null && rs.next()) {
            idList.add(rs.getString(1));
        }
        return idList;
    }

    private boolean isBillInWf(String id, List<String> inWfIds) {
        for (int i = 0; i < inWfIds.size(); ++i) {
            if (!id.equals(inWfIds.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> getAssignIds(Context ctx, String userId, String billId, String bizPackage, String bizFuncion, String bizOperation) throws Exception {
        String sql = "select FASSIGNID from T_WFR_ASSIGN WHERE FSTATE IN(0,1,2,32) And FPERSONUSERID = ? AND FBIZPACKAGE = ?  AND FBIZFUNCTION = ? AND FBIZOPERATION = ?  AND FBIZOBJID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId, bizPackage, bizFuncion, bizOperation, billId});
        ArrayList<String> idList = new ArrayList<String>();
        while (rs != null && rs.next()) {
            idList.add(rs.getString(1));
        }
        return idList;
    }
}

