/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.store.ActivityBatchPersistence;
import com.kingdee.bos.workflow.store.AssignmentBatchPersistence;
import com.kingdee.bos.workflow.store.DefaultBatchPersistence;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.listener.AbstractDataProvider;
import com.kingdee.bos.workflow.store.listener.DataChangeObjectValue;
import com.kingdee.bos.workflow.store.listener.IDataReceiver;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Locale;

public class DefaultDataReceiver
implements IDataReceiver {
    private String solution;
    private String ais;
    private Context context;

    public DefaultDataReceiver() {
    }

    public DefaultDataReceiver(String solution, String ais) {
        this.solution = solution;
        this.ais = ais;
    }

    @Override
    public void receiveChangedData(String ais, String solution, IObjectValue info) throws WfException {
        if (ais == null || solution == null || ais.equals("") || solution.equals("")) {
            throw new WfException("The ais and solution can't be null or empty");
        }
        if (info instanceof DataChangeObjectValue) {
            DataChangeObjectValue data = (DataChangeObjectValue)info;
            if (data.isDirectInvokeDAO()) {
                this.invokeDao(ais, solution, data);
            } else {
                this.invokeEngineReflection(ais, solution, data);
            }
        }
    }

    private void invokeEngineReflection(String ais, String solution, DataChangeObjectValue data) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(ais, solution);
        StoreManager storeManager = wfEngine.getStoreManager();
        String className = data.getProviderName();
        Context context = wfEngine.getClonedContext();
        context.put((Object)"eaiInvoke", (Object)"true");
        Object instance = this.getInstanceByClassName(storeManager, className, context, data);
        try {
            Class<?> c = instance.getClass();
            Method m = c.getMethod(data.getProviderMethodName(), data.getProviderMethodParametersType());
            m.invoke(instance, data.getProviderMethodParameters());
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        finally {
            ((AbstractDataProvider)instance).getContext().remove((Object)"eaiInvoke");
        }
    }

    private void invokeDao(String ais, String solution, DataChangeObjectValue data) throws WfException {
        if (this.ais == null || this.solution == null || !ais.equals(this.ais) || !solution.equals(this.solution)) {
            this.ais = ais;
            this.solution = solution;
            this.context = new Context(null, solution, ais, new Locale("L2"));
        }
        Connection conn = null;
        try {
            conn = WfDbUtil.getConnection((Context)this.context);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)data.getDAOType(), (Context)this.context, (Connection)conn);
            if (data.getProviderMethodName().equalsIgnoreCase("addnew") && data.getProviderMethodParameters().length == 1) {
                dao.addnew((IObjectValue)data.getProviderMethodParameters()[0]);
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private Object getInstanceByClassName(StoreManager storeManager, String className, Context context, DataChangeObjectValue data) {
        AbstractDataProvider store = null;
        if (className.endsWith("ProcessStorer")) {
            store = storeManager.getProcessStorer();
        } else if (className.endsWith("ActivityStorer")) {
            store = storeManager.getActivityStorer();
        } else if (className.endsWith("DataFieldStorer")) {
            store = storeManager.getDataFieldStorer();
        } else if (className.endsWith("WorkItemStorer")) {
            store = storeManager.getWorkItemStorer();
        } else if (className.endsWith("ActivityBatchPersistence")) {
            store = new ActivityBatchPersistence(context);
        } else if (className.endsWith("AssignmentBatchPersistence")) {
            store = new AssignmentBatchPersistence(context);
        } else if (className.endsWith("DefaultBatchPersistence")) {
            store = new DefaultBatchPersistence(context, data.getDAOType());
        }
        return store;
    }

    public String getAis() {
        return this.ais;
    }

    public void setAis(String ais) {
        this.ais = ais;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }
}

