/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.WorkCalendarUtil;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.DeadlineDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DeadlineWaiter {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.timeliness.DeadlineWaiter");
    private String desc;
    private Date date;
    private long interval = -1L;
    private String activityInstId;
    private final WfEngine engine;
    private int index;
    private String timeMode;
    private String orgId;

    public DeadlineWaiter(WfActivity activity, DeadlineDef deadlineDef, int index, boolean isSetup) {
        this.engine = activity.getWfEngine();
        this.index = index;
        this.activityInstId = activity.getId();
        this.desc = "DeadlineWaiter for [" + activity.getDefinition().getName() + "]" + this.activityInstId + " In Process " + ((ProcessDef)activity.getDefinition().getContainer()).getName();
        this.orgId = deadlineDef.getOrgId();
        this.timeMode = deadlineDef.getTimeMode();
        if (isSetup) {
            try {
                this.parseDeadlineCondition(deadlineDef.getDeadlineCondition());
            }
            catch (Exception e) {
                throw new RuntimeException("\u8ba1\u7b97\u6700\u540e\u671f\u9650\u65f6\u95f4\u5931\u8d25\uff0c" + deadlineDef.getDeadlineCondition(), e);
            }
        }
    }

    public Date getFireTime() {
        return this.date;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getId() {
        return this.activityInstId + "-" + this.index;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getActivityId() {
        return this.activityInstId;
    }

    public WfEngine getWfEngine() {
        return this.engine;
    }

    private Date parseDeadlineCondition(String condition) throws Exception {
        if (condition != null) {
            String[] time = StringUtils.split((String)condition, (String)"/");
            if (time != null && (time.length == 5 || time.length == 6)) {
                int conditLength = time.length;
                try {
                    long l = Calendar.getInstance().getTime().getTime();
                    if (this.timeMode.equalsIgnoreCase("WorkingDay")) {
                        int year = 0;
                        int month = this.eval(time[conditLength - 5]);
                        int date = this.eval(time[conditLength - 4]);
                        int hour = this.eval(time[conditLength - 3]);
                        int min = this.eval(time[conditLength - 2]);
                        int sec = this.eval(time[conditLength - 1]);
                        try {
                            this.date = WorkCalendarUtil.timeAdd((Context)this.engine.context(), (String)this.orgId, (Date)new Date(), (int)year, (int)month, (int)date, (int)hour, (int)min, (int)sec);
                        }
                        catch (BOSException e) {
                            log.warn((Object)e.getMessage(), (Throwable)e);
                            throw new IllegalArgumentException("\u8bfb\u53d6\u5de5\u4f5c\u65e5\u5386\u51fa\u9519!", e);
                        }
                    } else {
                        Calendar c = Calendar.getInstance();
                        int year = 0;
                        c.add(1, year);
                        int month = this.eval(time[conditLength - 5]);
                        c.add(2, month);
                        int date = this.eval(time[conditLength - 4]);
                        c.add(5, date);
                        int hour = this.eval(time[conditLength - 3]);
                        c.add(10, hour);
                        int min = this.eval(time[conditLength - 2]);
                        c.add(12, min);
                        int sec = this.eval(time[conditLength - 1]);
                        c.add(13, sec);
                        this.date = c.getTime();
                    }
                    this.interval = this.date.getTime() - l;
                }
                catch (NumberFormatException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u671f\u9650\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!", e);
                }
            } else {
                throw new IllegalArgumentException("\u671f\u9650\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!");
            }
        }
        log.error((Object)("deadline in deadlinewaiter is......" + this.date));
        return this.date;
    }

    private int eval(String str) {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            try {
                ProcessContext context = this.engine.getActivityInst(this.activityInstId).container().getProcessContext();
                Object object = context.getDataFieldValue(str);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (WfException e1) {
                log.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return retVal;
    }

    public int getIndex() {
        return this.index;
    }
}

