/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.WorkCalendarUtil;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EventTimerWaiter {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.timeliness.EventTimerWaiter");
    private String id;
    private String desc;
    private Date date;
    private long interval = -1L;
    private String activityInstId;
    private String activityDefId;
    private String procInstId;
    private String procDefId;
    private String endCondition;
    private long waiteTimes = 0L;
    private final WfEngine engine;
    private String timeMode;
    private String relativePoint;
    private String timerDescripter;

    public long getWaiteTimes() {
        return this.waiteTimes;
    }

    public void setWaiteTimes(long waiteTimes) {
        this.waiteTimes = waiteTimes;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    public String getProcInstId() {
        return this.procInstId;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    public String getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    public String getEndCondition() {
        return this.endCondition;
    }

    public void setEndCondition(String endCondition) {
        this.endCondition = endCondition;
    }

    public String getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(String timeMode) {
        this.timeMode = timeMode;
    }

    public String getRelativePoint() {
        return this.relativePoint;
    }

    public void setRelativePoint(String relativePoint) {
        this.relativePoint = relativePoint;
    }

    public String getTimerDescripter() {
        return this.timerDescripter;
    }

    public void setTimerDescripter(String timerDescripter) {
        this.timerDescripter = timerDescripter;
    }

    public EventTimerWaiter(WfActivity activity, TimerIntermediateEventActivityDef timerEventDef) {
        this.id = EventTimerWaiter.generateTimerId(activity, timerEventDef);
        this.engine = activity.getWfEngine();
        this.activityDefId = activity.getDefinition().getID();
        this.activityInstId = activity.getId();
        this.procDefId = activity.getDefinition().getContainer().getID();
        this.procInstId = activity.getProcInstId();
        this.timeMode = timerEventDef.getTimeMode();
        this.relativePoint = timerEventDef.getReferTimeObj();
        this.timerDescripter = timerEventDef.getDescription();
        this.endCondition = timerEventDef.getEndCondition();
        this.desc = "TimerIntermediateEventWaiter for [" + activity.getDefinition().getName() + "]" + this.activityInstId + " In Process " + ((ProcessDef)activity.getDefinition().getContainer()).getName();
        this.parseTimer(activity.getContext(), timerEventDef.getTime(), timerEventDef.getReferTimeCalendar(), timerEventDef.getOrgId());
    }

    public static String generateTimerId(WfActivity activity, TimerIntermediateEventActivityDef timerEventDef) {
        return timerEventDef.getID() + "_" + activity.getId();
    }

    public Date getFireTime() {
        return this.date;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getActivityId() {
        return this.activityInstId;
    }

    public WfEngine getWfEngine() {
        return this.engine;
    }

    private Date parseTimer(Context ctx, String condition, String refDay, String orgId) {
        if (condition != null) {
            String[] time = StringUtils.split((String)condition, (String)"/");
            if (time != null && time.length == 6) {
                try {
                    long l = Calendar.getInstance().getTime().getTime();
                    Calendar c = Calendar.getInstance();
                    if ("absolute".equalsIgnoreCase(this.timeMode)) {
                        c.clear();
                        c.set(1, this.eval(time[0]));
                        int month = this.eval(time[1]);
                        if (month > 0) {
                            --month;
                        }
                        c.set(2, month);
                        c.set(5, this.eval(time[2]));
                        c.set(10, this.eval(time[3]));
                        c.set(12, this.eval(time[4]));
                        c.set(13, this.eval(time[5]));
                    } else {
                        if (orgId != null && orgId.length() > 0 && "workday".equals(refDay)) {
                            try {
                                Date limit = WorkCalendarUtil.timeAdd((Context)this.engine.context(), (String)orgId, (Date)new Date(), (int)this.eval(time[0]), (int)this.eval(time[1]), (int)this.eval(time[2]), (int)this.eval(time[3]), (int)this.eval(time[4]), (int)this.eval(time[5]));
                                c.setTime(limit);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("\u8ba1\u7b97\u7b49\u5f85\u65f6\u95f4\u5931\u8d25\uff0c" + condition, e);
                            }
                        } else {
                            c.add(1, this.eval(time[0]));
                            c.add(2, this.eval(time[1]));
                            c.add(5, this.eval(time[2]));
                            c.add(10, this.eval(time[3]));
                            c.add(12, this.eval(time[4]));
                            c.add(13, this.eval(time[5]));
                        }
                        this.waiteTimes = this.eval(time[2]) * 24 * 60 * 60 + this.eval(time[3]) * 60 * 60 + this.eval(time[4]) * 60 + this.eval(time[5]);
                    }
                    this.date = c.getTime();
                    this.interval = this.date.getTime() - l;
                }
                catch (NumberFormatException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u65f6\u95f4\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!");
                }
            } else {
                throw new IllegalArgumentException("\u65f6\u95f4\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef!");
            }
        }
        return this.date;
    }

    private int eval(String str) {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            try {
                ProcessContext context = this.engine.getActivityInst(this.activityInstId).container().getProcessContext();
                Object object = context.getDataFieldValue(str);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (WfException e1) {
                log.warn((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        return retVal;
    }
}

