/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.core.thread.WfEventTimerRaiser;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EventTimerWaiterJob
implements Job {
    public static final String DATAMAP_NAME_ACTINST_ID = "actInstId";
    public static final String DATAMAP_NAME_ENGINE_NAME = "wfEngine_key";
    public static final String DATAMAP_NAME_PROCINST_ID = "procInstId";
    public static final String DATAMAP_NAME_PROCDEF_ID = "procDefId";
    public static final String DATAMAP_NAME_ACTDEF_ID = "actDefId";
    public static final String DATAMAP_NAME_END_CONDITION = "endCondition";
    public static final String DATAMAP_NAME_RELATE_WAITETIMES = "waiteTimes";
    public static final String DATAMAP_NAME_TIMER_MODE = "timerMode";

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap dataMap = jec.getJobDetail().getJobDataMap();
        if (dataMap != null) {
            try {
                this.executeAction(dataMap);
            }
            catch (WfException e) {
                throw new JobExecutionException("error to Excute EventTimerWaiterJob Action!", (Throwable)e, false);
            }
        }
    }

    private void executeAction(JobDataMap dataMap) throws WfException {
        String engineName = dataMap.getString(DATAMAP_NAME_ENGINE_NAME);
        WfEngine engine = WfEngine.getEngine(engineName);
        EventTimerWaiterJob obj = this;
        Class<?> classCaller = this.getClass();
        String methodName = "executeActionInWfTx";
        Class[] parameterTypes = new Class[]{JobDataMap.class};
        Object[] args = new Object[]{dataMap};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        WfTxHelper.invokeRequired(engine.context(), invocationDesc);
    }

    public void executeActionInWfTx(JobDataMap dataMap) throws WfException, JobExecutionException {
        WfEngine engine = EventTimerWaiterJob.getEngine(dataMap);
        WfEventTimerRaiser.enqueue(engine.context(), dataMap, new Date(System.currentTimeMillis()), dataMap.getString(DATAMAP_NAME_ACTINST_ID));
    }

    public static WfActivity getActivity(JobDataMap dataMap, WfEngine engine) throws JobExecutionException, WfException {
        String actInstId = dataMap.getString(DATAMAP_NAME_ACTINST_ID);
        if (actInstId == null) {
            throw new JobExecutionException("dataMap error!", null, false);
        }
        WfActivity act = engine.getActivityInst(actInstId);
        if (act == null) {
            throw new WfException("cannot find ActivityInst '" + actInstId + "'!");
        }
        return act;
    }

    public static WfEngine getEngine(JobDataMap dataMap) throws JobExecutionException, WfException {
        String engineName = dataMap.getString(DATAMAP_NAME_ENGINE_NAME);
        if (engineName == null) {
            throw new JobExecutionException("dataMap error!", null, false);
        }
        WfEngine engine = WfEngine.getEngine(engineName);
        if (engine == null) {
            throw new WfException("cannot find Engine '" + engineName + "'!");
        }
        return engine;
    }
}

