/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.exception.WfExpiredException;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;

public class ProcessStarterJob
implements StatefulJob {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.timeliness.ProcessStarterJob");
    public static final String ENGINE_KEY_PROP_NAME = "WF_ENGINE_KEY";
    public static final String PROC_DEF_ID_PROP_KEY = "PROCESS_DEF_ID";
    public static final String PROC_INST_ID_PROP_KEY = "PROCESS_INST_ID";
    public static final String RETRY_TIMES = "RETRY_TIMES";

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap data = jec.getJobDetail().getJobDataMap();
        String engineKey = this.getEngineKey(jec);
        String procid = data.getString(PROC_DEF_ID_PROP_KEY);
        String procInstId = data.getString(PROC_INST_ID_PROP_KEY);
        int retryTimes = data.getInt(RETRY_TIMES);
        boolean bReFire = jec.getRefireCount() < retryTimes;
        try {
            WfEngine wfEngine = WfEngine.getEngine(engineKey);
            ProcessStarterJob obj = this;
            Class<ProcessStarterJob> classCaller = ProcessStarterJob.class;
            String methodName = "startProcess";
            Class[] parameterTypes = new Class[]{WfEngine.class, String.class, String.class, Boolean.TYPE};
            Object[] args = new Object[]{wfEngine, procid, procInstId, bReFire};
            MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
            WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
            WfTxHelper.invokeNotSupported(wfEngine.context(), invocationDesc);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            JobExecutionException excep = new JobExecutionException("error start process " + procid, (Throwable)e, bReFire);
            excep.setUnscheduleFiringTrigger(bReFire);
            if (e instanceof WfExpiredException) {
                this.deleteExpiredJob(jec);
            }
            throw excep;
        }
    }

    private void deleteExpiredJob(JobExecutionContext jec) {
    }

    private String getEngineKey(JobExecutionContext jec) {
        if (jec == null) {
            throw new IllegalArgumentException();
        }
        try {
            String schedulerName = jec.getScheduler().getSchedulerName();
            String ais = SchedulerUtils.getAIS((String)schedulerName);
            String solution = SchedulerUtils.getSolution((String)schedulerName);
            return ais + "|" + solution;
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void startProcess(WfEngine wfEngine, String processid, String procInstId, boolean bReFire) throws WfException {
        WfProcess procInst;
        WfProcessMgr procMgr = wfEngine.getProcessMgr(processid);
        ProcessDef processDef = procMgr.getProcessDef();
        ScheduleDef scheduleDef = processDef.getProcessHeader().getScheduale();
        if (ProcessType.BACKGROUNDJOB.equals((Object)processDef.getType())) {
            return;
        }
        if (!procMgr.getData().isEnable()) {
            return;
        }
        boolean isUseCalendar = scheduleDef.isUseCalendar();
        if (isUseCalendar) {
            try {
                String orgUnitId = scheduleDef.getOrgUnitId();
                boolean isWorkDay = SchedulerUtils.isWorkDay((Context)wfEngine.context(), (String)orgUnitId, (Date)new Date());
                if (!isWorkDay) {
                    return;
                }
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e);
            }
        }
        if (procInstId == null || procInstId.length() == 0) {
            IParticipantProvider participantProvider = wfEngine.getPariticipantProvider();
            Person initiator = participantProvider.getPersonByUserId(wfEngine.context(), "00000000-0000-0000-0000-00000000000013B7DE7F");
            procInst = procMgr.createProcess(null, initiator);
        } else {
            procInst = wfEngine.getProcessInst(procInstId);
        }
        procInst.start();
    }
}

