/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.timeliness.DeadlineWaiter;
import com.kingdee.bos.workflow.timeliness.EventTimerWaiter;
import com.kingdee.bos.workflow.timeliness.Limiter;
import com.kingdee.bos.workflow.timeliness.ProcessStarter;
import com.kingdee.bos.workflow.timeliness.QuartzTimelinessProvider;
import com.kingdee.bos.workflow.timeliness.WorkflowTimer;
import java.util.HashMap;
import java.util.Map;
import org.quartz.spi.JobStore;

public abstract class TimelinessProvider {
    private static Map providerCache = new HashMap();

    protected TimelinessProvider() {
    }

    public abstract void start();

    public abstract void shutdown();

    public abstract void addTimer(WorkflowTimer var1);

    public abstract void deleteTimer(WorkflowTimer var1);

    public abstract void addProcessStarter(ProcessStarter var1);

    public abstract void deleteProcessStarter(ProcessStarter var1);

    public abstract void addLimiter(Limiter var1);

    public abstract void deleteLimiter(Limiter var1);

    public abstract void addDeadlineWaiter(DeadlineWaiter var1) throws WfException;

    public abstract void deleteDeadlineWaiter(String var1);

    public abstract JobStore getJobStore() throws WfException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimelinessProvider getProvider(String aisName, String solution) {
        Class<TimelinessProvider> clazz = TimelinessProvider.class;
        synchronized (TimelinessProvider.class) {
            String providerKey = aisName + solution;
            TimelinessProvider provider = (TimelinessProvider)providerCache.get(providerKey);
            if (provider == null) {
                provider = new QuartzTimelinessProvider(aisName, solution);
                providerCache.put(providerKey, provider);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return provider;
        }
    }

    public abstract void addTimeEventWaiter(EventTimerWaiter var1);
}

