/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.transaction.WfTxInvokeHandler;
import com.kingdee.bos.workflow.transaction.WfTxInvoker;

public final class WfTxHelper {
    public static Object invokeNotSupported(Context ctx, WfTxInvocationDesc invocationDesc) throws WfException {
        WfTxContext originalCtx = WfTxContext.current();
        WfTxContext newWfContext = null;
        try {
            ServiceStateManager.getInstance().disableNextCallServices();
            newWfContext = WfTxContext.beginNewTx(ctx);
            WfTxInvoker invoker = new WfTxInvoker(invocationDesc);
            invoker.setTxInvokeHandler(new WfTxInvokeHandler(invocationDesc, newWfContext));
            IInvokeMethodDelegate delegate = WfTxHelper.getTxDelegate(ctx);
            Object retValue = delegate.invokeNotSupported(invoker.getClass().getName(), (Object)invoker, "invoke", null, null);
            newWfContext.endTx();
            Object object = retValue;
            return object;
        }
        catch (Throwable e) {
            if (newWfContext != null) {
                newWfContext.rollbackTx();
            }
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WfException(e);
        }
        finally {
            WfTxContext.setCurrent(originalCtx);
        }
    }

    public static Object invokeSupports(Context ctx, WfTxInvocationDesc invocationDesc) throws WfException {
        WfTxContext wfContext = WfTxContext.beginTx(ctx);
        try {
            ServiceStateManager.getInstance().disableNextCallServices();
            WfTxInvoker invoker = new WfTxInvoker(invocationDesc);
            invoker.setTxInvokeHandler(new WfTxInvokeHandler(invocationDesc, wfContext));
            IInvokeMethodDelegate delegate = WfTxHelper.getTxDelegate(ctx);
            Object retValue = delegate.invokeSupports(invoker.getClass().getName(), (Object)invoker, "invoke", null, null);
            wfContext.endTx();
            return retValue;
        }
        catch (Throwable e) {
            wfContext.rollbackTx();
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WfException(e);
        }
    }

    public static Object invokeRequired(Context ctx, WfTxInvocationDesc invocationDesc) throws WfException {
        WfTxContext wfContext = WfTxContext.beginTx(ctx);
        try {
            ServiceStateManager.getInstance().disableNextCallServices();
            WfTxInvoker invoker = new WfTxInvoker(invocationDesc);
            invoker.setTxInvokeHandler(new WfTxInvokeHandler(invocationDesc, wfContext));
            IInvokeMethodDelegate delegate = WfTxHelper.getTxDelegate(ctx);
            Object retValue = delegate.invokeRequired(invoker.getClass().getName(), (Object)invoker, "invoke", null, null);
            wfContext.endTx();
            return retValue;
        }
        catch (Throwable e) {
            wfContext.rollbackTx();
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WfException(e);
        }
    }

    public static Object invokeRequiresNew(Context ctx, WfTxInvocationDesc invocationDesc) throws WfException {
        WfTxContext originalCtx = WfTxContext.current();
        WfTxContext newWfContext = null;
        try {
            ServiceStateManager.getInstance().disableNextCallServices();
            newWfContext = WfTxContext.beginNewTx(ctx);
            WfTxInvoker invoker = new WfTxInvoker(invocationDesc);
            invoker.setTxInvokeHandler(new WfTxInvokeHandler(invocationDesc, newWfContext));
            IInvokeMethodDelegate delegate = WfTxHelper.getTxDelegate(ctx);
            Object retValue = delegate.invokeRequiresNew(invoker.getClass().getName(), (Object)invoker, "invoke", null, null);
            newWfContext.endTx();
            Object object = retValue;
            return object;
        }
        catch (Throwable e) {
            newWfContext.rollbackTx();
            if (e instanceof WfException) {
                throw (WfException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WfException(e);
        }
        finally {
            WfTxContext.setCurrent(originalCtx);
        }
    }

    private static IInvokeMethodDelegate getTxDelegate(Context ctx) throws BOSException {
        return InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
    }
}

