/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.transaction.IWfTxInvokeHandler;
import com.kingdee.bos.workflow.transaction.LazyPersistentMgr;
import com.kingdee.bos.workflow.transaction.TxAssignmentMgr;
import com.kingdee.bos.workflow.transaction.WfMutexReleasePolicy;
import com.kingdee.bos.workflow.transaction.WfProcessMutexAcquirePolicy;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import java.lang.reflect.Method;

public class WfTxInvokeHandler
implements IWfTxInvokeHandler {
    private final WfTxInvocationDesc invocationDesc;
    private final WfTxContext wfContext;

    public WfTxInvokeHandler(WfTxInvocationDesc invocationDesc, WfTxContext wfContext) {
        this.invocationDesc = invocationDesc;
        this.wfContext = wfContext;
    }

    @Override
    public void invokeBefore() throws WfException {
        if (WorkflowClusterConfig.getInstance().isGroupType()) {
            WfProcessMutexAcquirePolicy policy = new WfProcessMutexAcquirePolicy(this.invocationDesc, this.wfContext);
            policy.execute();
        }
    }

    @Override
    public void invokeAfter() throws WfException {
        if (this.wfContext.isTopTx()) {
            Method m = ObjectFactory.getMethod(this.getClass(), (String)"invokeAfterWf");
            try {
                ObjectFactory.invokeRequired((Object)this, (Method)m, null);
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e);
            }
            this.dumpAssignments(this.wfContext);
            this.wfContext.getLazyPersistentMgr().wfExecutionExpired();
        }
    }

    public void invokeAfterWf() throws WfException {
        this.commitLazyTx(this.wfContext);
    }

    private void commitLazyTx(WfTxContext wfContext) throws WfException {
        LazyPersistentMgr mgr = wfContext.getLazyPersistentMgr();
        mgr.commit();
    }

    private void dumpAssignments(WfTxContext wfContext) throws WfException {
        TxAssignmentMgr mgr = wfContext.getTxAssignmentMgr();
        mgr.dumpAssignments();
    }

    @Override
    public void invokeFinally(boolean success) throws WfException {
        if (success && WorkflowClusterConfig.getInstance().isGroupType()) {
            WfMutexReleasePolicy policy = new WfMutexReleasePolicy(this.wfContext);
            policy.execute();
        }
    }
}

