/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.config.WorkflowInfo;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.workflow.WfLogConfig;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.util.TransEventPriorityPolicyConfig;
import com.kingdee.bos.workflow.util.WorkflowClusterConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EngineConfig {
    public static final String LOGCONFIG_LOGLEVEL = "LogLevel";
    public static final String LOGCONFIG_ENABLEENGINELOG = "EnableEngineLog";
    public static final String LOGCONFIG_ENABLEQUEUELOG = "EnableQueueLog";
    public static final String LOGCONFIG_ENABLEPROCESSDEFLOG = "EnableProcessDefLog";
    public static final String LOGCONFIG_ENABLEPROCESSINSTLOG = "EnableProcessInstLog";
    public static final String LOGCONFIG_ENABLEANALYSISDATA = "EnableAnalysisData";
    public static final String DELETEJOBPROCESSWHENCLOSED = "DeleteJobProcessWhenClosed";
    public static final String WORKFLOW_PARTICIPANT_CONFIG_NAME = "participant";
    public static final String WORKFLOW_TRANS_QUEUE_TIME = "workflowTransQueueTime";
    public static final String WORKFLOW_SERVER_KEY = "workflowServerKey";
    public static final String WORKFLOW_ISINITWFSERVICE = "isInitWfService";
    public static final String WORKFLOW_THREADSEMAPHORE = "threadSemaphore";
    public static final String WORKFLOW_TESTBEFOREUSE = "testBeforeUse";
    public static final String PROCESS_END_DELAY = "process-end-delay";
    public static final String WORKFLOW_ISUT = "isUT";
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.EngineConfig");
    private static final String PARTICIPANT_PROVIDER = "participant";
    private static final String PERMISSION_PROVIDER = "permission";
    private static final String CLASSIFICATION_SCHEMA_FACTORY = "messageClassification";
    private static final String PBOTP_PROVIDER = "botp";
    private static final String PKSCRIPTDEBUGSERVER_PROVIDER = "kscriptdebug";
    private static final String ASSIGNMENT_LISTENER = "assignmentListener";
    private static final String WORKFLOW_CONFIG_NAME = "Workflow";
    private static final String WORKFLOW_CACHEMANAGER = "cacheManager";
    private static final String RESUMESUSPENDEDPROCESSPOLICY = "ResumeSuspendedProcessPolicy";
    private static final String BIZEVENTRESETPOLICY = "BizeventResetPolicy";
    private static final String REPAIRBIZTOWFRELATIONPOLICY = "RepairBizToWfRelationPolicy";
    private static final String REPAIRSCHEDULERDATAPOLICY = "RepairSchedulerDataPolicy";
    private static final String QUEUEMAXRETRYTIMES = "QueueMaxRetryTimes";
    private static final String ISSENDMSG = "IsSendMsg";
    private static final String QUEUE_IDLE_TIME_GROUP_MODE = "queueIdleTimeGroupMode";
    private static final String ENABLE_BUFFERED_ASSIGNMENT_CHECK = "enableBufferedAssignmentCheck";
    private static final String ENABLE_METHOD_LEVEL_CACHE = "enableMethodLevelCache";
    private static final String SUBSYSTEM_PROVIDER = "subsystem";
    private static final String WORKCALENDAR_PROVIDER = "workcalendar";
    public static final String ENABLE_WORKFLOW_DATALISTEN = "EnableWorkflowDataListen";
    public static final String FILTER_DATALISTEN_PACKAGE = "DataListenFilterPackage";
    public static final String PROCESS_DEF_CACHE_SIZE = "proDefCacheSize";
    private WfLogConfig logConfig = new WfLogConfig();
    private String serverKey = null;
    private static EngineConfig instance;
    public boolean isEnableScheduler = false;
    public static final String WORKFLOW_WFDESIGNER_PROCESS_PERMISSION = "isControlProcessPermission";
    public boolean isControlProcessPermission = false;
    public boolean deleteJobProcessWhenClosed = false;
    private int recordTimeOut = 30;
    private int processInstDumpDays = 180;
    private int processInstDumpRecordOfBatch = 1000;
    public TransEventPriorityPolicyConfig transEventPriorityPolicyConfig = new TransEventPriorityPolicyConfig();
    private boolean testBeforeUse = false;
    public boolean isInitWfService = true;
    public boolean isUT = false;
    private int workflowQueueIdleTime = 2000;
    private int threadSemaphore = 5;
    private String participantProvider = null;
    private String classificationSchemaFactory = null;
    private String permissionProvider = null;
    private String botpProvider = "com.kingdee.bos.metadata.bot.app.WfBOTPProvider";
    private String kscriptDebugServerProvider = "com.kingdee.bos.kscript.KScriptDebugProvider";
    private int queueMaxRetryTimes = 1;
    private String[] resumeSuspendedProcessPolicyTime = new String[0];
    private int bizeventResetPolicyTime = -1;
    private int repairBizToWfRelationPolicyTime = 30;
    private int repairSchedulerDataPolicyTime = 30;
    private String cacheManager;
    private String assignListener;
    private int processEndDelay;
    private boolean isSendMsg = true;
    private boolean enableBufferedAssignmentCheck = true;
    private boolean enableMemCache = false;
    private int queueIdleTimeGroupMode = 250;
    private boolean enableMethodLevelCache = false;
    private boolean enableWorkflowDataListen = false;
    private String[] filterPackageArray = new String[0];
    private String subSystemProvider = "com.kingdee.eas.common.SubSystemProvider";
    private String workCalendarDayProvider = "";
    private boolean isAutoTrimPriority = true;
    private int autoTrimPriorityLower_num = 6;
    private long autoTrimPriorityLower_time = 180000L;
    private int autoTrimPriorityLowest_num = 3;
    private long autoTrimPriorityLowest_time = 1800000L;
    private int proDefCacheSize = 300;

    public boolean deleteJobProcessWhenClosed() {
        return this.deleteJobProcessWhenClosed;
    }

    private EngineConfig() {
    }

    public boolean testBeforeUse() {
        return this.testBeforeUse;
    }

    private void setLogConfig(WfLogConfig logConfig, Map value) {
        boolean enableAnalysisData;
        boolean enableProcessDefLog;
        boolean enableQueueLog;
        boolean enableEngineLog;
        if (logConfig == null) {
            return;
        }
        if (value == null || value.size() == 0) {
            return;
        }
        String logLevel = (String)value.get(LOGCONFIG_LOGLEVEL);
        LogTypeEnum logType = LogTypeEnum.getEnum((String)logLevel);
        if (logType != null) {
            logConfig.logLevel = logType;
        }
        String enableEngineLogString = (String)value.get(LOGCONFIG_ENABLEENGINELOG);
        logConfig.enableEngineLog = enableEngineLog = Boolean.valueOf(enableEngineLogString).booleanValue();
        String enableQueueLogString = (String)value.get(LOGCONFIG_ENABLEQUEUELOG);
        logConfig.enableQueueLog = enableQueueLog = Boolean.valueOf(enableQueueLogString).booleanValue();
        String enableProcessDefLogString = (String)value.get(LOGCONFIG_ENABLEPROCESSDEFLOG);
        logConfig.enableProcessDefLog = enableProcessDefLog = Boolean.valueOf(enableProcessDefLogString).booleanValue();
        String enableAnalysisDataString = (String)value.get(LOGCONFIG_ENABLEANALYSISDATA);
        logConfig.enableAnalysisData = enableAnalysisData = Boolean.valueOf(enableAnalysisDataString).booleanValue();
    }

    public WfLogConfig getLogConfig() {
        return this.logConfig;
    }

    public String getClassificationSchemaFactory() {
        return this.classificationSchemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        IDeployInfoManager deploy = DeployInfoManagerFactory.getDeployInfoManager();
        WorkflowInfo wfInfo = deploy.getWorkflowInfo();
        ConfigurationItem workflowItem = deploy.getConfigItem(WORKFLOW_CONFIG_NAME);
        if (wfInfo != null) {
            String strEnableMemCache;
            ConfigurationItem ciWfTransEvent;
            String strEnableMethodLevelCache;
            String strQueueIdleTimeGroupMode;
            String strEnableBufferedAssignmentCheck;
            String proDefCacheSizeStr;
            String testBeforeUseStr;
            String threadSemaphoreStr;
            String repairSchedulerDataPolicyTimeStr;
            String repairBizToWfRelationPolicyStr;
            String bizeventResetPolicyStr;
            String controlProcessPermissionStr;
            String resumeSuspendedProcessPolicyStr;
            int delay;
            String cacheMgrStr;
            String isUTStr;
            this.isEnableScheduler = wfInfo.isIsEnableScheduler();
            this.isInitWfService = wfInfo.isIsInitWfService();
            int swTime = 100;
            int wtTime = 100;
            try {
                wtTime = wfInfo.getWorkflowTransQueueTime();
                if (wtTime < 100) {
                    wtTime = 100;
                }
                this.workflowQueueIdleTime = wtTime;
                swTime = wfInfo.getSchedulerIdleWaiteTime();
                if (swTime < 100) {
                    swTime = 100;
                }
                MultiSchedulerFactory.IDEL_WAITE_TIME((int)swTime);
            }
            catch (Throwable e) {
                this.workflowQueueIdleTime = 100;
                log.error((Object)e.getMessage(), e);
            }
            if (WorkflowClusterConfig.getInstance().isGroupType()) {
                this.serverKey = wfInfo.getWorkflowServerKey();
            }
            if (StringUtils.isEmpty((String)this.serverKey)) {
                this.serverKey = this.getHostInfo();
            }
            if (StringUtils.isEmpty((String)this.serverKey)) {
                this.serverKey = WORKFLOW_SERVER_KEY;
            }
            if (this.serverKey.length() > 50) {
                this.serverKey = this.serverKey.substring(0, 49);
            }
            this.participantProvider = wfInfo.getProvider("participant");
            this.permissionProvider = wfInfo.getProvider(PERMISSION_PROVIDER);
            this.classificationSchemaFactory = workflowItem.getProperty(CLASSIFICATION_SCHEMA_FACTORY);
            if (wfInfo.getProvider(PBOTP_PROVIDER) != null && !wfInfo.getProvider(PBOTP_PROVIDER).equals("")) {
                this.botpProvider = wfInfo.getProvider(PBOTP_PROVIDER);
            }
            if (wfInfo.getProvider(SUBSYSTEM_PROVIDER) != null && !wfInfo.getProvider(SUBSYSTEM_PROVIDER).equals("")) {
                this.subSystemProvider = wfInfo.getProvider(SUBSYSTEM_PROVIDER);
            }
            if (wfInfo.getProvider(WORKCALENDAR_PROVIDER) != null && !wfInfo.getProvider(WORKCALENDAR_PROVIDER).equals("")) {
                this.workCalendarDayProvider = wfInfo.getProvider(WORKCALENDAR_PROVIDER);
            }
            if (wfInfo.getProvider(PKSCRIPTDEBUGSERVER_PROVIDER) != null && !wfInfo.getProvider(PKSCRIPTDEBUGSERVER_PROVIDER).equals("")) {
                this.kscriptDebugServerProvider = wfInfo.getProvider(PKSCRIPTDEBUGSERVER_PROVIDER);
            }
            if ((isUTStr = workflowItem.getProperty(WORKFLOW_ISUT)) != null && isUTStr.trim().length() > 0) {
                this.isUT = "true".equalsIgnoreCase(isUTStr);
            }
            if ((cacheMgrStr = workflowItem.getProperty(WORKFLOW_CACHEMANAGER)) != null && cacheMgrStr.trim().length() > 0) {
                this.cacheManager = cacheMgrStr;
            }
            this.assignListener = workflowItem.getProperty(ASSIGNMENT_LISTENER);
            String tmp = workflowItem.getProperty(PROCESS_END_DELAY);
            try {
                delay = tmp == null || tmp.length() == 0 ? 0 : Integer.parseInt(tmp);
            }
            catch (Exception e) {
                delay = 0;
            }
            this.processEndDelay = delay;
            tmp = workflowItem.getProperty("processInstDumpDays");
            if (tmp != null) {
                try {
                    this.processInstDumpDays = Integer.parseInt(tmp);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((tmp = workflowItem.getProperty("processInstDumpRecordOfBatch")) != null) {
                try {
                    this.processInstDumpRecordOfBatch = Integer.parseInt(tmp);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((resumeSuspendedProcessPolicyStr = workflowItem.getProperty(RESUMESUSPENDEDPROCESSPOLICY)) != null && resumeSuspendedProcessPolicyStr.trim().length() > 0) {
                this.resumeSuspendedProcessPolicyTime = StringUtils.split((String)resumeSuspendedProcessPolicyStr, (String)";");
            }
            if (!StringUtils.isEmpty((String)(controlProcessPermissionStr = workflowItem.getProperty(WORKFLOW_WFDESIGNER_PROCESS_PERMISSION)))) {
                try {
                    this.isControlProcessPermission = "true".equalsIgnoreCase(controlProcessPermissionStr);
                }
                catch (NumberFormatException e) {
                    this.isControlProcessPermission = false;
                    log.error((Object)"EngineConfig read isControlProcessPermission error.", (Throwable)e);
                }
            }
            if ((bizeventResetPolicyStr = workflowItem.getProperty(BIZEVENTRESETPOLICY)) != null && bizeventResetPolicyStr.trim().length() > 0) {
                try {
                    this.bizeventResetPolicyTime = Integer.parseInt(bizeventResetPolicyStr);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"EngineConfig read bizeventResetPolicy error.", (Throwable)e);
                }
                if (this.bizeventResetPolicyTime < 15 && this.bizeventResetPolicyTime >= 0) {
                    this.bizeventResetPolicyTime = 15;
                }
            }
            if ((repairBizToWfRelationPolicyStr = workflowItem.getProperty(REPAIRBIZTOWFRELATIONPOLICY)) != null && repairBizToWfRelationPolicyStr.trim().length() > 0) {
                try {
                    this.repairBizToWfRelationPolicyTime = Integer.parseInt(repairBizToWfRelationPolicyStr);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"EngineConfig read repairBizToWfRelationPolicy error.", (Throwable)e);
                }
                if (this.repairBizToWfRelationPolicyTime < 30 && this.repairBizToWfRelationPolicyTime >= 0) {
                    this.repairBizToWfRelationPolicyTime = 30;
                }
            }
            if ((repairSchedulerDataPolicyTimeStr = workflowItem.getProperty(REPAIRSCHEDULERDATAPOLICY)) != null && repairSchedulerDataPolicyTimeStr.trim().length() > 0) {
                try {
                    this.repairSchedulerDataPolicyTime = Integer.parseInt(repairSchedulerDataPolicyTimeStr);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"EngineConfig read repairSchedulerDataPolicyTime error.", (Throwable)e);
                }
                if (this.repairSchedulerDataPolicyTime < 30 && this.repairSchedulerDataPolicyTime >= 0) {
                    this.repairSchedulerDataPolicyTime = 30;
                }
            }
            if ((threadSemaphoreStr = workflowItem.getProperty(WORKFLOW_THREADSEMAPHORE)) != null && threadSemaphoreStr.trim().length() > 0) {
                try {
                    this.threadSemaphore = Integer.parseInt(threadSemaphoreStr);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"EngineConfig read threadSemaphore error.", (Throwable)e);
                }
            }
            if ((testBeforeUseStr = workflowItem.getProperty(WORKFLOW_TESTBEFOREUSE)) == null || testBeforeUseStr.length() == 0) {
                this.testBeforeUse = false;
            } else {
                try {
                    this.testBeforeUse = Boolean.valueOf(testBeforeUseStr);
                }
                catch (Throwable e) {
                    this.testBeforeUse = false;
                }
            }
            String dltJbPrcsWhnClsdStr = workflowItem.getProperty(DELETEJOBPROCESSWHENCLOSED);
            if (dltJbPrcsWhnClsdStr == null || dltJbPrcsWhnClsdStr.trim().length() <= 0) {
                this.deleteJobProcessWhenClosed = false;
            } else {
                try {
                    this.deleteJobProcessWhenClosed = Boolean.valueOf(dltJbPrcsWhnClsdStr);
                }
                catch (Throwable e) {
                    this.deleteJobProcessWhenClosed = false;
                }
            }
            String maxRetryTimesStr = workflowItem.getProperty(QUEUEMAXRETRYTIMES);
            if (maxRetryTimesStr == null || maxRetryTimesStr.trim().length() <= 0) {
                this.queueMaxRetryTimes = 1;
            } else {
                try {
                    this.queueMaxRetryTimes = Integer.parseInt(maxRetryTimesStr);
                }
                catch (Throwable e) {
                    this.queueMaxRetryTimes = 1;
                }
            }
            String isSendMsgStrng = workflowItem.getProperty(ISSENDMSG);
            this.isSendMsg = isSendMsgStrng == null || isSendMsgStrng.trim().length() <= 0 ? false : isSendMsgStrng.equalsIgnoreCase("true");
            String enableWfDataListen = workflowItem.getProperty(ENABLE_WORKFLOW_DATALISTEN);
            this.enableWorkflowDataListen = enableWfDataListen == null || enableWfDataListen.trim().length() <= 0 ? false : enableWfDataListen.equalsIgnoreCase("true");
            String filterPackages = workflowItem.getProperty(FILTER_DATALISTEN_PACKAGE);
            if (!StringUtils.isEmpty((String)filterPackages)) {
                this.filterPackageArray = StringUtils.split((String)filterPackages, (String)";");
            }
            if (!StringUtils.isEmpty((String)(proDefCacheSizeStr = workflowItem.getProperty(PROCESS_DEF_CACHE_SIZE))) && proDefCacheSizeStr.trim().matches("\\d*")) {
                this.proDefCacheSize = Integer.valueOf(proDefCacheSizeStr);
            }
            if (!StringUtils.isEmpty((String)(strEnableBufferedAssignmentCheck = workflowItem.getProperty(ENABLE_BUFFERED_ASSIGNMENT_CHECK)))) {
                this.enableBufferedAssignmentCheck = "true".equalsIgnoreCase(strEnableBufferedAssignmentCheck);
            }
            if (!StringUtils.isEmpty((String)(strQueueIdleTimeGroupMode = workflowItem.getProperty(QUEUE_IDLE_TIME_GROUP_MODE)))) {
                this.queueIdleTimeGroupMode = Integer.parseInt(strQueueIdleTimeGroupMode);
            }
            if (!StringUtils.isEmpty((String)(strEnableMethodLevelCache = workflowItem.getProperty(ENABLE_METHOD_LEVEL_CACHE)))) {
                this.enableMethodLevelCache = "true".equalsIgnoreCase(strEnableMethodLevelCache);
            }
            Map logConfigMap = wfInfo.getLogConfigs();
            this.setLogConfig(this.logConfig, logConfigMap);
            Map mapTransConcurrentConfig = wfInfo.getTransConcurrentConfigs();
            this.setTransEventPriorityPolicyConfig(this.transEventPriorityPolicyConfig, mapTransConcurrentConfig);
            ConfigurationItem ci = workflowItem.getChild("Concurrent");
            if (ci != null && (ciWfTransEvent = ci.getChild("WfTransEvent")) != null) {
                String v = ciWfTransEvent.getProperty("AutoTrimPriority", "true");
                this.isAutoTrimPriority = !"false".equalsIgnoreCase(v);
                v = ciWfTransEvent.getProperty("AutoTrimPriorityLowerNum", "6");
                try {
                    this.autoTrimPriorityLower_num = Integer.parseInt(v);
                    if (this.autoTrimPriorityLower_num <= 0) {
                        this.autoTrimPriorityLower_num = 6;
                    }
                }
                catch (Exception ex) {
                    this.autoTrimPriorityLower_num = 6;
                }
                v = ciWfTransEvent.getProperty("AutoTrimPriorityLowerTime", "3");
                try {
                    this.autoTrimPriorityLower_time = Long.parseLong(v) * 60L * 1000L;
                    if (this.autoTrimPriorityLower_time <= 60000L) {
                        this.autoTrimPriorityLower_time = 180000L;
                    }
                }
                catch (Exception ex) {
                    this.autoTrimPriorityLower_time = 180000L;
                }
                v = ciWfTransEvent.getProperty("AutoTrimPriorityLowestNum", "3");
                try {
                    this.autoTrimPriorityLowest_num = Integer.parseInt(v);
                    if (this.autoTrimPriorityLowest_num <= 0) {
                        this.autoTrimPriorityLowest_num = 3;
                    }
                }
                catch (Exception ex) {
                    this.autoTrimPriorityLowest_num = 3;
                }
                v = ciWfTransEvent.getProperty("AutoTrimPriorityLowestTime", "30");
                try {
                    this.autoTrimPriorityLowest_time = Long.parseLong(v) * 60L * 1000L;
                    if (this.autoTrimPriorityLowest_time <= 180000L) {
                        this.autoTrimPriorityLowest_time = 180000L;
                    }
                }
                catch (Exception ex) {
                    this.autoTrimPriorityLowest_time = 1800000L;
                }
            }
            if (!StringUtils.isEmpty((String)(strEnableMemCache = workflowItem.getProperty("EnableMemCache")))) {
                this.enableMemCache = "true".equalsIgnoreCase(strEnableMemCache);
            }
        }
        String tmp = System.getProperty("java.security.auth.login.config");
        FileInputStream fis = null;
        try {
            int i = tmp.lastIndexOf("/");
            Properties properties = new Properties();
            String path = tmp.substring(0, i) + "/";
            String file = path + "wf_deleteRecordTime.properties";
            File f = new File(file);
            fis = new FileInputStream(f);
            properties.load(fis);
            String outTime = (String)properties.get("TimeOut");
            if (!StringUtil.isEmpty((String)outTime)) {
                outTime = outTime.trim();
            }
            this.recordTimeOut = Integer.parseInt(outTime);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)("ProcessStorer.addDeleteProcessRecord : configuration files is null , cause : " + e.getMessage()));
            this.recordTimeOut = 30;
        }
        catch (IOException e) {
            log.debug((Object)("ProcessStorer.addDeleteProcessRecord : configuration files is null , cause : " + e.getMessage()));
            this.recordTimeOut = 30;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error((Object)"finally close inputsteam error", (Throwable)e);
                }
            }
        }
    }

    public int getProcessEndDelay() {
        return this.processEndDelay;
    }

    public int getProcessInstDumpDays() {
        return this.processInstDumpDays;
    }

    public int getProcessInstDumpRecordOfBatch() {
        return this.processInstDumpRecordOfBatch;
    }

    private void setTransEventPriorityPolicyConfig(TransEventPriorityPolicyConfig config, Map mapTransConcurrentConfig) {
        String strHighest;
        String strHigh;
        String strHigher;
        String strMedium;
        String strLower;
        String strLow;
        String strLowest;
        String strEnablePriorityPolicy = (String)mapTransConcurrentConfig.get("EnablePriorityPolicy");
        if (!StringUtils.isEmpty((String)strEnablePriorityPolicy)) {
            config.enableEventPriorityPolicy = "true".equalsIgnoreCase(strEnablePriorityPolicy);
        }
        if (!StringUtils.isEmpty((String)(strLowest = (String)mapTransConcurrentConfig.get("Lowest")))) {
            try {
                config.lowestCapability = Float.valueOf(strLowest).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strLow = (String)mapTransConcurrentConfig.get("Low")))) {
            try {
                config.lowCapability = Float.valueOf(strLow).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strLower = (String)mapTransConcurrentConfig.get("Lower")))) {
            try {
                config.lowerCapability = Float.valueOf(strLower).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strMedium = (String)mapTransConcurrentConfig.get("Medium")))) {
            try {
                config.mediumCapability = Float.valueOf(strMedium).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strHigher = (String)mapTransConcurrentConfig.get("Higher")))) {
            try {
                config.higherCapability = Float.valueOf(strHigher).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strHigh = (String)mapTransConcurrentConfig.get("High")))) {
            try {
                config.highCapability = Float.valueOf(strHigh).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(strHighest = (String)mapTransConcurrentConfig.get("Highest")))) {
            try {
                config.highestCapability = Float.valueOf(strHighest).floatValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getHostInfo() {
        String hostInfo;
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String string = hostInfo = address != null ? address.toString() : null;
        if (hostInfo == null || hostInfo.trim().length() == 0 || "loopback/127.0.0.1".equalsIgnoreCase(hostInfo)) {
            log.warn((Object)("Server address error: " + hostInfo));
            Enumeration<NetworkInterface> enu = null;
            try {
                enu = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException e) {
                log.error((Object)"Get networkInterfaces error.", (Throwable)e);
                throw new IllegalStateException("" + e.getMessage());
            }
            while (enu.hasMoreElements()) {
                NetworkInterface ni = enu.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    String[] ips;
                    InetAddress localAddress = ias.nextElement();
                    String hostAddress = localAddress.getHostAddress();
                    if (hostAddress == null || (ips = hostAddress.split("\\.")).length != 4 || "127.0.0.1".equals(hostAddress)) continue;
                    hostInfo = localAddress.getHostName() + "/" + hostAddress;
                    if (hostAddress.startsWith("192.168.")) continue;
                    break;
                }
                if (hostInfo.indexOf("192.168.") > 0) continue;
                break;
            }
            if (hostInfo == null || hostInfo.trim().length() == 0) {
                throw new IllegalStateException("Server address error." + this.serverKey);
            }
        }
        return hostInfo;
    }

    public String getParticipantProvider() {
        return this.participantProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<EngineConfig> clazz = EngineConfig.class;
        synchronized (EngineConfig.class) {
            if (instance == null) {
                instance = new EngineConfig();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setDefault() {
        instance = null;
    }

    public boolean isDefaultEnableScheduler() {
        return this.isEnableScheduler;
    }

    public int getWorkflowQueueIdleTime() {
        return this.workflowQueueIdleTime;
    }

    public void setWorkflowQueueIdleTime(int time) {
        this.workflowQueueIdleTime = time;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public boolean isInitWfService() {
        return this.isInitWfService;
    }

    public boolean isUT() {
        return this.isUT;
    }

    public int getThreadSemaphore() {
        return this.threadSemaphore;
    }

    public void setThreadSemaphore(int count) {
        this.threadSemaphore = count;
    }

    public String getPermissionProvider() {
        return this.permissionProvider;
    }

    public String getCacheManager() {
        return this.cacheManager;
    }

    public String[] getResumeSuspendedProcessPolicyTime() {
        return this.resumeSuspendedProcessPolicyTime;
    }

    public int getBizeventResetPolicyTime() {
        return this.bizeventResetPolicyTime;
    }

    public int getRepairBizToWfRelationPolicyTime() {
        return this.repairBizToWfRelationPolicyTime;
    }

    public int getRepairSchedulerDataPolicyTime() {
        return this.repairSchedulerDataPolicyTime;
    }

    public int getQueueMaxRetryTimes() {
        return this.queueMaxRetryTimes;
    }

    public String getAssignmentListener() {
        return this.assignListener;
    }

    public boolean isSendMsg() {
        return this.isSendMsg;
    }

    public boolean isEnableBufferedAssignmentCheck() {
        return this.enableBufferedAssignmentCheck;
    }

    public void setEnableBufferedAssignmentCheck(boolean enableBufferedAssignmentCheck) {
        this.enableBufferedAssignmentCheck = enableBufferedAssignmentCheck;
    }

    public int getQueueIdleTimeGroupMode() {
        return this.queueIdleTimeGroupMode;
    }

    public void setQueueIdleTimeGroupMode(int queueIdleTimeGroupMode) {
        this.queueIdleTimeGroupMode = queueIdleTimeGroupMode;
    }

    public boolean isEnableMethodLevelCache() {
        return this.enableMethodLevelCache;
    }

    public void setEnableMethodLevelCache(boolean enableMethodLevelCache) {
        this.enableMethodLevelCache = enableMethodLevelCache;
    }

    public String getBotpProvider() {
        return this.botpProvider;
    }

    public String getKScriptDebugServerProvider() {
        return this.kscriptDebugServerProvider;
    }

    public boolean isEnableWorkflowDataListen() {
        return this.enableWorkflowDataListen;
    }

    public String[] getFilterPackageArray() {
        return this.filterPackageArray;
    }

    public String getSubSystemProvider() {
        return this.subSystemProvider;
    }

    public TransEventPriorityPolicyConfig getTransEventPriorityPolicyConfig() {
        return this.transEventPriorityPolicyConfig;
    }

    public String getWorkCalendarDayProvider() {
        return this.workCalendarDayProvider;
    }

    public boolean isAutoTrimPriority() {
        return this.isAutoTrimPriority;
    }

    public void setAutoTrimPriority(boolean isAutoTrimPriority) {
        this.isAutoTrimPriority = isAutoTrimPriority;
    }

    public int getAutoTrimPriorityLowerNum() {
        return this.autoTrimPriorityLower_num;
    }

    public void setAutoTrimPriorityLowerNum(int autoTrimPriorityLowerNum) {
        this.autoTrimPriorityLower_num = autoTrimPriorityLowerNum;
    }

    public long getAutoTrimPriorityLowerTime() {
        return this.autoTrimPriorityLower_time;
    }

    public void setAutoTrimPriorityLowerTime(long autoTrimPriorityLowerTime) {
        this.autoTrimPriorityLower_time = autoTrimPriorityLowerTime;
    }

    public int getAutoTrimPriorityLowestNum() {
        return this.autoTrimPriorityLowest_num;
    }

    public void setAutoTrimPriorityLowestNum(int autoTrimPriorityLowestNum) {
        this.autoTrimPriorityLowest_num = autoTrimPriorityLowestNum;
    }

    public long getAutoTrimPriorityLowestTime() {
        return this.autoTrimPriorityLowest_time;
    }

    public void setAutoTrimPriorityLowestTime(long autoTrimPriorityLowestTime) {
        this.autoTrimPriorityLowest_time = autoTrimPriorityLowestTime;
    }

    public boolean isControlProcessPermission() {
        return this.isControlProcessPermission;
    }

    public boolean isEnableMemCache() {
        return this.enableMemCache;
    }

    public void setEnableMemCache(boolean enableMemCache) {
        this.enableMemCache = enableMemCache;
    }

    public int getRecordTimeOut() {
        return this.recordTimeOut;
    }

    public int getProDefCacheSize() {
        return this.proDefCacheSize;
    }
}

