/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.DeployedEventSet;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfRuntimeStat;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstBizObjInfo;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogCollection;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class WfDoctor {
    private static final Logger logger = Logger.getLogger(WfDoctor.class);
    private final WfEngine wfEngine;
    private boolean viewEnvReport = false;
    private boolean viewBasicReport = false;
    private boolean viewThreadReport = false;
    private boolean viewQueueReport = false;
    private String bizObjID = null;

    public WfDoctor(WfEngine wfEngine) {
        this.wfEngine = wfEngine;
    }

    public void setViewEnvironmentReport(boolean viewEnvReport) {
        this.viewEnvReport = viewEnvReport;
    }

    public void setViewBasicReport(boolean viewBasicReport) {
        this.viewBasicReport = viewBasicReport;
    }

    public void setViewThreadReport(boolean viewThreadReport) {
        this.viewThreadReport = viewThreadReport;
    }

    public void setViewQueueReport(boolean viewQueueReport) {
        this.viewQueueReport = viewQueueReport;
    }

    public void setBizObjID(String bizObjID) {
        this.bizObjID = bizObjID;
    }

    public String generateOverviewReport() {
        StringBuffer buffer = new StringBuffer(5000);
        if (this.viewEnvReport) {
            buffer.append(this.generateEnvironmentReport());
        }
        if (this.viewBasicReport) {
            buffer.append(this.generateBasicReport());
        }
        if (this.viewThreadReport) {
            buffer.append(this.generateThreadReport());
        }
        if (this.viewQueueReport) {
            buffer.append(this.generateQueueReport());
        }
        if (!StringUtils.isEmpty((String)this.bizObjID) && BOSUuid.isValid((String)this.bizObjID, (boolean)false)) {
            buffer.append(this.generateRefDataReport());
        }
        this.generateRuntimeStat(buffer);
        return buffer.toString();
    }

    private void generateRuntimeStat(StringBuffer buffer) {
        buffer.append("\n\n\u3010\u8fd0\u884c\u65f6\u7edf\u8ba1\u4fe1\u606f\u3011");
        buffer.append("\n\u6700\u8fd15\u5206\u949f\u5904\u7406\u7684\u4efb\u52a1\u6570:").append(WfRuntimeStat.getAssignCount());
        buffer.append("\n\u6267\u884c\u4e2d\u4e1a\u52a1\u8c03\u7528\u6570:").append(WfRuntimeStat.getCurrentBizCount());
        buffer.append("\n\u6700\u8fd11\u5c0f\u65f6\u4e1a\u52a1\u7684\u6267\u884c\u65f6\u95f4:").append(WfRuntimeStat.getBizTime()).append("\u6beb\u79d2");
        buffer.append("\n\u6267\u884c\u4e2d\u6d41\u7a0b\u6570:").append(WfRuntimeStat.getCurrentRunningCount());
        buffer.append("\n\u6700\u8fd11\u5c0f\u65f6\u5de5\u4f5c\u6d41\u7684\u6267\u884c\u65f6\u95f4:").append(WfRuntimeStat.getRunningTime()).append("\u6beb\u79d2");
        buffer.append("\n\u6700\u8fd15\u5206\u949f\u5904\u7406\u7684\u4e8b\u4ef6\u6570:").append(WfRuntimeStat.getEventCount());
        buffer.append("\n\u6700\u8fd15\u5206\u949f\u5de5\u4f5c\u6d41\u6267\u884c\u5931\u8d25\u7684\u6b21\u6570:").append(WfRuntimeStat.getErrorCount());
        buffer.append("\n\u6700\u8fd15\u5206\u949f\u5de5\u4f5c\u6d41\u4e25\u91cd\u5931\u8d25\u7684\u6b21\u6570:").append(WfRuntimeStat.getFatalErrorCount());
        buffer.append("\r\n");
    }

    private String generateEnvironmentReport() {
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("\u3010\u8fd0\u884c\u73af\u5883\u4fe1\u606f\u3011").append('\n');
        Set<Map.Entry<Object, Object>> entrySet = System.getProperties().entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            buffer.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        return buffer.toString();
    }

    private String generateBasicReport() {
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("\u3010\u5de5\u4f5c\u6d41\u5f15\u64ce\u57fa\u672c\u4fe1\u606f\u3011").append('\n');
        buffer.append("\u6807\u8bc6:").append(this.wfEngine.getEngineKey()).append('\n');
        buffer.append("\u8282\u70b9\u540d:").append(this.wfEngine.getServerKey()).append('\n');
        buffer.append("\u89e3\u51b3\u65b9\u6848:").append(this.wfEngine.getEngineSolution()).append('\n');
        buffer.append("\u6570\u636e\u4e2d\u5fc3:").append(this.wfEngine.getEngineAis()).append('\n');
        buffer.append("\u8fd0\u884c\u72b6\u6001:").append(this.wfEngine.getState() == 1 ? "Running" : "Not Running").append('\n');
        boolean registered = false;
        try {
            IServiceAdapter adapter = ServiceManagerFactory.getServiceManager().getService("WORKFLOW_BIZEVENT");
            registered = adapter != null;
        }
        catch (Throwable e) {
            registered = false;
        }
        buffer.append("EAS\u4e8b\u4ef6\u76d1\u542c\uff08WfBizEventListener\uff09:").append(registered ? "\u5df2\u6ce8\u518c" : "\u6ca1\u6ce8\u518c").append('\n');
        boolean hasLicense = false;
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.license.agent.LicenseSrvFactory");
            Object srv = cls.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Method m = srv.getClass().getMethod("licenseCheck", String.class);
            int r = (Integer)m.invoke(srv, "BPM_G");
            hasLicense = r >= 1;
        }
        catch (Throwable e) {
            hasLicense = false;
        }
        buffer.append("License:").append(hasLicense ? "\u6709" : "\u65e0").append('\n');
        buffer.append("\u6d88\u606f\u76ee\u7684\u5730:").append(this.wfEngine.getMessageManager().getWfDestination().toString()).append('\n');
        buffer.append(this.generateDeployedEventInfo()).append('\n');
        return buffer.toString();
    }

    private String generateDeployedEventInfo() {
        StringBuffer buffer = new StringBuffer(500);
        try {
            String[] operationNames;
            String[] functionNames;
            EventInfo[] eventInfos;
            String[] methodIDs;
            int i;
            buffer.append("\u3010\u5f53\u524d\u53d1\u5e03\u7684\u6d41\u7a0b\u542f\u52a8\u4e1a\u52a1\u4e8b\u4ef6\u3011").append('\n');
            Set operations = DeployedEventSet.getInstance((Context)this.wfEngine.context()).getOperations();
            Iterator iterator = operations.iterator();
            while (iterator.hasNext()) {
                buffer.append(iterator.next()).append('\n');
            }
            buffer.append("\u3010\u5f53\u524d\u53d1\u5e03\u7684\u4e1a\u52a1\u4e8b\u4ef6\u3011").append('\n');
            BizEventMap bizEventMap = EventUtils.getDynBizEventMap(this.wfEngine.context());
            int size = bizEventMap.size();
            for (i = 0; i < size; ++i) {
                methodIDs = bizEventMap.getMethodSet();
                eventInfos = bizEventMap.getEventSet();
                functionNames = bizEventMap.getFunctionSet();
                operationNames = bizEventMap.getOperationSet();
                buffer.append("methodID[").append(methodIDs[i]).append("] ").append("eventName[").append(eventInfos[i].getName()).append("] ").append("eventAlias[").append(eventInfos[i].getAlias()).append("] ").append("functionName[").append(functionNames[i]).append("] ").append("operationName[").append(operationNames[i]).append("] ").append('\n');
            }
            buffer.append('\n');
            bizEventMap = EventUtils.getBizEventMap(this.wfEngine.context());
            size = bizEventMap.size();
            for (i = 0; i < size; ++i) {
                methodIDs = bizEventMap.getMethodSet();
                eventInfos = bizEventMap.getEventSet();
                functionNames = bizEventMap.getFunctionSet();
                operationNames = bizEventMap.getOperationSet();
                buffer.append("methodID[").append(methodIDs[i]).append("] ").append("eventName[").append(eventInfos[i].getName()).append("] ").append("eventAlias[").append(eventInfos[i].getAlias()).append("] ").append("functionName[").append(functionNames[i]).append("] ").append("operationName[").append(operationNames[i]).append("] ").append('\n');
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return buffer.toString();
    }

    private String generateThreadReport() {
        StringBuffer buffer = new StringBuffer("\u8be5\u65b9\u6cd5\u4e0d\u518d\u652f\u6301\uff0c\u8bf7\u4f7f\u7528\u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u7684CTRL+O\u67e5\u770b\u7ebf\u7a0b\u72b6\u6001!");
        return buffer.toString();
    }

    private String generateQueueReport() {
        StringBuffer buffer = new StringBuffer("\u8be5\u65b9\u6cd5\u4e0d\u518d\u652f\u6301\uff0c\u8bf7\u4ece\u201c\u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d\u67e5\u770b\u201c~Wf\u201d\u5f00\u5934\u7684\u4e8b\u52a1\u6267\u884c\u60c5\u51b5\uff01");
        return buffer.toString();
    }

    private String generateRefDataReport() {
        BOSUuid objectID = BOSUuid.read((String)this.bizObjID);
        StringBuffer buffer = new StringBuffer(3000);
        Context ctx = this.wfEngine.context();
        buffer.append("\u3010\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f\u3011").append('\n');
        buffer.append(this.getBizObjectInfo(ctx, objectID)).append('\n');
        buffer.append("\u3010\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u5143\u6570\u636e\u4fe1\u606f\u3011").append('\n');
        buffer.append(this.getRefMetadataInfo(ctx, objectID.getType())).append('\n');
        try {
            AssignCollection assignCollection = this.wfEngine.getStoreManager().getWorkItemStorer().getAssignInfoCollection("WHERE bizObjID ='" + this.bizObjID + "' ");
            HashMap<String, ProcInstInfo> mapProcInstInfos = new HashMap<String, ProcInstInfo>();
            HashMap<String, ProcInstDataInfo> mapProcInstDataInfos = new HashMap<String, ProcInstDataInfo>();
            HashMap<String, ProcInstBizObjInfo> mapProcInstBizObjInfos = new HashMap<String, ProcInstBizObjInfo>();
            HashMap<BOSUuid, ActInstInfo> mapActInstInfos = new HashMap<BOSUuid, ActInstInfo>();
            HashMap<BOSUuid, AssignInfo> mapAssignInfos = new HashMap<BOSUuid, AssignInfo>();
            HashMap<BOSUuid, IObjectValue> mapProcInstLogInfos = new HashMap<BOSUuid, IObjectValue>();
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            int size = assignCollection.size();
            for (int i = 0; i < size; ++i) {
                AssignInfo assignInfo = assignCollection.get(i);
                String procInstID = assignInfo.getProcInstID().toString();
                WfProcess wfProcess = this.wfEngine.getProcessInst(procInstID);
                mapProcInstInfos.put(procInstID, wfProcess.getData().getMeta());
                mapProcInstDataInfos.put(procInstID, wfProcess.getProcessContext().getProcInstDataInfo());
                mapProcInstBizObjInfos.put(this.bizObjID, this.wfEngine.getProcInstBizObjInfoByBoId(this.bizObjID));
                WFRProcessInstLogCollection processInstLogCollection = (WFRProcessInstLogCollection)dynamicObject.getCollection(new WFRProcessInstLogInfo().getBOSType(), "WHERE processInstID ='" + wfProcess.getId() + "' ");
                int size1 = processInstLogCollection.size();
                for (int j = 0; j < size1; ++j) {
                    mapProcInstLogInfos.put(processInstLogCollection.get(j).getId(), processInstLogCollection.getObject(j));
                }
                List activities = wfProcess.activities();
                for (WfActivity wfActivity : activities) {
                    mapActInstInfos.put(wfActivity.getMeta().getActInstInfo().getActInstID(), wfActivity.getMeta().getActInstInfo());
                    List assignments = wfActivity.assignments();
                    for (WfAssignment wfAssignment : assignments) {
                        mapAssignInfos.put(wfAssignment.getMeta().getAssignInfo().getAssignID(), wfAssignment.getMeta().getAssignInfo());
                    }
                }
            }
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u6d41\u7a0b\u5b9e\u4f8b\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapProcInstInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u6d41\u7a0b\u4e0a\u4e0b\u6587\u5b9e\u4f8b\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapProcInstDataInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u4e0e\u6d41\u7a0b\u7ed1\u5b9a\u5173\u7cfb\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapProcInstBizObjInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u6d3b\u52a8\u5b9e\u4f8b\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapActInstInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u4efb\u52a1\u5b9e\u4f8b\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapAssignInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u65e5\u5fd7\u4fe1\u606f\u3011").append('\n');
            buffer.append(this.getObjectValuesInfo(mapProcInstLogInfos.values())).append('\n');
            buffer.append("\u3010\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u76f8\u5173\u7684\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u3011").append('\n');
            buffer.append(this.getKPDLInfo(mapProcInstInfos.values())).append('\n');
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        return buffer.toString();
    }

    private String getKPDLInfo(Collection procInstInfos) {
        StringBuffer buffer = new StringBuffer(500);
        for (ProcInstInfo procInstInfo : procInstInfos) {
            buffer.append("\u6d41\u7a0b\u5b9a\u4e49\u7f16\u7801\uff1a").append(procInstInfo.getCode()).append('\n');
            buffer.append("\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0\uff1a").append(procInstInfo.getProcdefName()).append('\n');
            buffer.append("\u6d41\u7a0b\u5b9a\u4e49Hash\u503c\uff1a").append(procInstInfo.getProcdefHash()).append('\n');
            buffer.append("KPDL").append('\n');
            String kpdl = this.wfEngine.getStoreManager().getProcessStorer().getKpdlByHash(procInstInfo.getProcdefHash());
            buffer.append(kpdl).append('\n');
        }
        return buffer.toString();
    }

    private String getObjectValuesInfo(Collection objectValues) {
        StringBuffer buffer = new StringBuffer(500);
        boolean flag = false;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (IObjectValue objectValue : objectValues) {
            if (!flag) {
                Enumeration enumeration = objectValue.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    keys.add(key);
                    buffer.append(key).append("                  ");
                }
                buffer.append('\n');
                flag = true;
            }
            for (String key : keys) {
                buffer.append(objectValue.get(key)).append("                  ");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private String getBizObjectInfo(Context ctx, BOSUuid objectID) {
        StringBuffer buffer = new StringBuffer();
        try {
            BOSObjectType objectType = objectID.getType();
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            IObjectValue objectValue = dynamicObject.getValue(objectType, (IObjectPK)new ObjectUuidPK(objectID));
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(objectType);
            buffer.append(entity.getAlias()).append('(').append(entity.getFullName()).append(')').append(':').append(objectValue.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return buffer.toString();
    }

    private String getRefMetadataInfo(Context ctx, BOSObjectType objectType) {
        StringBuffer buffer = new StringBuffer();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(objectType);
        EventCollection events = entity.getEvents();
        HashSet<EventInfo> setEvent = new HashSet<EventInfo>();
        for (EventInfo eventInfo : events) {
            setEvent.add(eventInfo);
        }
        FunctionObjectCollection functions = loader.getFunctions();
        int size = functions.size();
        for (int i = 0; i < size; ++i) {
            FunctionObjectInfo functionObjectInfo = functions.get(i);
            OperationCollection operations = functionObjectInfo.getOperation();
            int size1 = operations.size();
            for (int j = 0; j < size1; ++j) {
                try {
                    OperationInfo operationInfo = operations.get(j);
                    if (operationInfo != null) {
                        EventInfo eventInfo = operationInfo.getEventRef();
                        UIActionRefInfo actionRefInfo = operationInfo.getUiActionRef();
                        if (actionRefInfo != null && actionRefInfo.getUIObjectRef() == null) {
                            buffer.append("ERROR:  Function[").append(functionObjectInfo.getFullName());
                            buffer.append("] Action[").append(actionRefInfo.getActionRefName());
                            buffer.append("] ' s UIActionRefInfo is null:").append('\n');
                        }
                        if (eventInfo == null || eventInfo.getEventMethods() == null) {
                            buffer.append("ERROR:  Function[").append(functionObjectInfo.getFullName());
                            buffer.append("] Operation[").append(operationInfo.getName());
                            buffer.append("]' s event is null:").append('\n');
                            continue;
                        }
                        if (eventInfo.getEventMethods() == null) {
                            buffer.append("ERROR:  Function[").append(functionObjectInfo.getFullName());
                            buffer.append("] Operation[").append(operationInfo.getName());
                            buffer.append("] ' s eventMethod is null:").append('\n');
                            continue;
                        }
                        if (!setEvent.contains(eventInfo)) continue;
                        buffer.append("Function[").append(functionObjectInfo.getFullName()).append(']');
                        buffer.append("Operation[").append(operationInfo.getName()).append("]\n");
                        continue;
                    }
                    buffer.append("ERROR Function[").append(functionObjectInfo.getFullName()).append(']');
                    buffer.append("'s Operation not found. \n");
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    buffer.append("ERROR:").append(StringUtils.stackToString((Throwable)e));
                }
            }
        }
        return buffer.toString();
    }
}

