/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IWFLogProcessor;
import com.kingdee.bos.workflow.service.IWorkflowLogService;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WorkflowLogUtil {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.util.WorkflowLogFactory");

    public static IWorkflowLogService getWorkflowLogRemoteService() throws BOSException {
        IWorkflowLogService service = (IWorkflowLogService)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.bos.workflow.service.WorkflowLogService", IWorkflowLogService.class);
        return service;
    }

    private static IWorkflowLogService getWorkflowLocalLogService(Context ctx) throws BOSException {
        IWorkflowLogService service = (IWorkflowLogService)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.workflow.service.WorkflowLogService", IWorkflowLogService.class);
        return service;
    }

    public static void endLogByLocal(Context ctx, IObjectPK logPk) {
        try {
            if (logPk != null) {
                WorkflowLogUtil.getWorkflowLocalLogService(ctx).endLogByLocal(logPk);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
    }

    public static IObjectPK beginLogByLocal(Context ctx, WorkflowLogItem wfItem, Object opContent) {
        IObjectPK logPk = null;
        try {
            String opContentStr = WorkflowLogUtil.getOpContentStr(ctx, opContent);
            if (null == opContentStr) {
                return null;
            }
            logPk = WorkflowLogUtil.getWorkflowLocalLogService(ctx).beginLogByLocal(wfItem, opContentStr);
        }
        catch (Exception e) {
            log.error((Object)"beginLogByLocal.error:", (Throwable)e);
        }
        return logPk;
    }

    public static IObjectPK beginLogByLocal(Context ctx, IWFLogProcessor logProcessor) {
        IObjectPK logPk = null;
        try {
            logPk = WorkflowLogUtil.getWorkflowLocalLogService(ctx).beginLogByLocal(logProcessor);
        }
        catch (Exception e) {
            log.error((Object)"beginLogByLocal.error:", (Throwable)e);
        }
        return logPk;
    }

    private static String getOpContentStr(Context ctx, Object opContent) throws EASBizException, BOSException {
        String opContentStr = "";
        IObjectPK[] pkArray = null;
        if (opContent instanceof IObjectPK[]) {
            pkArray = (IObjectPK[])opContent;
            for (int i = 0; i < pkArray.length; ++i) {
                opContentStr = opContentStr + pkArray[i];
                if (i == pkArray.length - 1) continue;
                opContentStr = opContentStr + ";";
            }
        } else if (opContent instanceof MultiApproveInfo) {
            MultiApproveInfo info = (MultiApproveInfo)opContent;
            opContentStr = opContentStr + info.getString("assignment");
            opContentStr = opContentStr + ",";
            opContentStr = opContentStr + info.getString("ispass");
        } else if (opContent instanceof List) {
            List ids = (List)opContent;
            for (int i = 0; i < ids.size(); ++i) {
                opContentStr = opContentStr + (String)ids.get(i);
                if (i == ids.size() - 1) continue;
                opContentStr = opContentStr + ";";
            }
        } else if (opContent instanceof String) {
            opContentStr = (String)opContent;
        } else if (opContent instanceof JSONObject) {
            opContentStr = WorkflowLogUtil.formatNextActs(ctx, opContent);
        }
        return opContentStr;
    }

    private static String formatNextActs(Context ctx, Object opContent) throws BOSException, EASBizException {
        String procinstId = null;
        String procDefHash = null;
        String actName = null;
        StringBuffer result = new StringBuffer();
        JSONObject json = (JSONObject)opContent;
        WfEngine wfEngine = EngineUtil.getEngine(ctx);
        AssignmentInfo assingInfo = (AssignmentInfo)json.get((Object)"assign");
        if (null != assingInfo) {
            procinstId = assingInfo.getProcInstId();
            actName = assingInfo.getActDefName(new Locale("l2"));
            procDefHash = assingInfo.getProcDefHashValue();
        } else {
            procinstId = json.getString("procinstId");
            actName = " \u63d0\u4ea4\u5355\u636e ";
            procDefHash = json.getString("procDefHash");
        }
        WfProcess wfProcess = wfEngine.getProcessInst(procinstId);
        ProcessDef processDef = wfEngine.getProcessDef(procDefHash);
        ObjectUuidPK callerPk = (ObjectUuidPK)json.get((Object)"caller");
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = iUser.getUserInfo((IObjectPK)callerPk);
        StringBuffer opContentSb = new StringBuffer();
        opContentSb.append("\u6d41\u7a0b").append(wfProcess.getProcessMeta().getCode());
        opContentSb.append("\u7684 ").append(actName).append(" \u8282\u70b9 (");
        IPerson personInfo = PersonFactory.getLocalInstance((Context)ctx);
        if (null != assingInfo) {
            List persionArr = (List)json.get((Object)"persons");
            String k = json.getString("actKey");
            if (null != persionArr && persionArr.size() > 0) {
                String actDefId = k.split("@")[1];
                opContentSb.append(" \u6307\u5b9a\u4e86 ");
                ActivityDef activityDef = processDef.getActivityDef(actDefId);
                opContentSb.append(activityDef.getName()).append(" \u8282\u70b9\u7684\u53c2\u4e0e\u4eba\u4e3a\uff1a");
                for (int i = 0; i < persionArr.size(); ++i) {
                    PersonInfo pp = personInfo.getPersonInfo((IObjectPK)new ObjectUuidPK((String)persionArr.get(i)));
                    String personName = pp.getName();
                    opContentSb.append(personName).append(",");
                }
            } else {
                return null;
            }
            opContentSb.append(")");
        } else {
            Map map = (Map)json.get((Object)"nextActs");
            Set keys = map.keySet();
            boolean hasOp = false;
            for (String k : keys) {
                List persionArr = (List)map.get(k);
                if (null == persionArr || persionArr.size() <= 0) continue;
                hasOp = true;
                String actDefId = k.split("@")[1];
                opContentSb.append(" \u6307\u5b9a\u4e86 ");
                ActivityDef activityDef = processDef.getActivityDef(actDefId);
                opContentSb.append(activityDef.getName()).append(" \u8282\u70b9\u7684\u53c2\u4e0e\u4eba\u4e3a\uff1a");
                for (int i = 0; i < persionArr.size(); ++i) {
                    PersonInfo pp = personInfo.getPersonInfo((IObjectPK)new ObjectUuidPK((String)persionArr.get(i)));
                    String personName = pp.getName();
                    opContentSb.append(personName).append(",");
                }
            }
            if (!hasOp) {
                return null;
            }
            opContentSb.append(")");
        }
        return opContentSb.toString();
    }
}

