/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.botp.BotpMappingInfo;
import com.kingdee.bos.workflow.botp.IBotpHelper;
import com.kingdee.bos.workflow.botp.IBotpProvider;
import com.kingdee.bos.workflow.exception.WfBotpException;
import com.kingdee.bos.workflow.util.EngineConfig;
import org.apache.log4j.Logger;

public class BotpHelper
extends AbstractBOSObject
implements IBotpHelper {
    private static Logger logger = Logger.getLogger(BotpHelper.class);
    IBotpProvider _provider = this.loadBotpProvider();

    public BotpHelper() {
        super.registerInterface(IBotpHelper.class, (Object)this);
    }

    public BotpHelper(Context context) {
        super.registerInterface(IBotpHelper.class, (Object)this);
    }

    private IBotpProvider loadBotpProvider() {
        String sBotpProviderClassName = EngineConfig.getInstance().getBotpProvider();
        if (sBotpProviderClassName != null) {
            try {
                Class<?> sBotpProviderClass = Class.forName(sBotpProviderClassName);
                IBotpProvider myBotpProvider = (IBotpProvider)sBotpProviderClass.newInstance();
                return myBotpProvider;
            }
            catch (IllegalAccessException ex1) {
                logger.error((Object)"BotpProvider init error", (Throwable)ex1);
                return null;
            }
            catch (InstantiationException ex1) {
                logger.error((Object)"BotpProvider init error", (Throwable)ex1);
                return null;
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Object)"BotpProvider init error", (Throwable)ex1);
                return null;
            }
        }
        return null;
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"WFBP");
    }

    public BotpMappingInfo[] getBotpMappingInfosByBoth(String srcBillType, String destBillType) throws WfBotpException {
        return this._provider.getBotpMappingInfosByBoth(this.getContext(), srcBillType, destBillType);
    }

    public BotpMappingInfo[] getBotpMappingInfosByBoth(String orgId, String srcBillType, String destBillType) throws WfBotpException {
        return this._provider.getBotpMappingInfosByBoth(this.getContext(), orgId, srcBillType, destBillType);
    }

    public String[] transform(String billId, String orgId, String srcBillType, String destBillType) throws WfBotpException {
        return this._provider.transform(this.getContext(), billId, orgId, srcBillType, destBillType);
    }

    public String[] transformByMappingId(String billId, String srcBillType, String botpId) throws WfBotpException {
        return this._provider.transformByMappingId(this.getContext(), billId, srcBillType, botpId);
    }
}

