/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.biz.trans.UIConfSolutionInfo;
import com.kingdee.bos.workflow.biz.trans.Waf2UIConfSolutionInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.service.ormrpc.IUIConfSolutionProvider;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.wfdesigner.service.IWfDesignerService;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WfDesignerService
extends AbstractBOSObject
implements IWfDesignerService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.WfDesignerService");

    public WfDesignerService() {
        super.registerInterface(IWfDesignerService.class, (Object)this);
    }

    public WfDesignerService(Context ctx) {
        super.registerInterface(IWfDesignerService.class, (Object)this);
    }

    public BOSObjectType getType() {
        return BOSObjectType.create((String)"WFDESIGN");
    }

    public void loadUserContext() throws WfException {
        try {
            Class<?> contextUtilsClass = Class.forName("com.kingdee.eas.base.permission.ContextUtils");
            Method method = contextUtilsClass.getMethod("loadUserContext", Context.class);
            WfEventListenerStateManager.getInstance().disableEventListener();
            method.invoke(contextUtilsClass, this.getContext());
        }
        catch (ClassNotFoundException e) {
            throw new WfException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new WfException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new WfException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new WfException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WfException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WfException((Throwable)e);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    public boolean hasSameStartupCondition(ProcessDef processDef) throws WfException {
        if (processDef == null) {
            throw new IllegalArgumentException();
        }
        StartActivityDef startActDef = processDef.getStartActivity();
        if (startActDef == null) {
            throw new WfException("Fatal error! start activity null.");
        }
        ActivityCollection firstActList = startActDef.getPostActivities();
        for (int i = 0; i < firstActList.size(); ++i) {
            int j;
            FunctionDef funcDef;
            ManpowerActivityDef manpowerActDef;
            ApplicationDef appDef;
            ActivityDef actDef = firstActList.get(i);
            if (!(actDef instanceof ManpowerActivityDef) || (appDef = (manpowerActDef = (ManpowerActivityDef)actDef).getRelatedApplication()) == null || (funcDef = appDef.getFunction()) == null) continue;
            ParticipantCollection participantCollection = manpowerActDef.getParticipants();
            HashMap<String, BizProcInfo> map = new HashMap<String, BizProcInfo>();
            ArrayList<ParticipantDef> list = new ArrayList<ParticipantDef>();
            for (j = 0; j < participantCollection.size(); ++j) {
                ParticipantDef participant = participantCollection.get(j);
                if (!StringUtils.isEmpty((String)participant.getExceptFormRef())) {
                    String exceptRefID = participant.getExceptFormRef();
                    if (map.containsKey(exceptRefID)) {
                        BizProcInfo bizProcInfo = (BizProcInfo)map.get(exceptRefID);
                        bizProcInfo.setExceptPerformerID(participant.getParticipantValue());
                        bizProcInfo.setExceptPerformerType(this.getPerformerType(participant.getParticipantType(), bizProcInfo));
                        if (!this.hasSameStartupCondition(bizProcInfo)) continue;
                        return true;
                    }
                    list.add(participant);
                    continue;
                }
                if (participant.getParticipantType().equals((Object)ParticipantType.RELATION) || participant.getParticipantType().equals((Object)ParticipantType.VARIANT)) continue;
                BizProcInfo bizProcInfo = new BizProcInfo();
                bizProcInfo.setBizFunction(funcDef.getName());
                bizProcInfo.setBizPackage(funcDef.getPackageName());
                bizProcInfo.setBizOperation(funcDef.getOperation());
                bizProcInfo.setPerformerId(participant.getParticipantValue());
                bizProcInfo.setProcDefId(processDef.getID());
                bizProcInfo.setProcStartActDefId(actDef.getID());
                bizProcInfo.setInheritParentProcess(false);
                bizProcInfo.setPerformerType(this.getPerformerType(participant.getParticipantType(), bizProcInfo));
                map.put(participant.getUniqueID(), bizProcInfo);
                if (!this.hasSameStartupCondition(bizProcInfo)) continue;
                return true;
            }
            j = 0;
            int n = list.size();
            while (i < n) {
                ParticipantDef participant = (ParticipantDef)list.get(j);
                String exceptRefID = participant.getExceptFormRef();
                if (map.containsKey(exceptRefID)) {
                    BizProcInfo bizProcInfo = (BizProcInfo)map.get(exceptRefID);
                    bizProcInfo.setExceptPerformerID(participant.getParticipantValue());
                    bizProcInfo.setExceptPerformerType(this.getPerformerType(participant.getParticipantType(), bizProcInfo));
                    if (this.hasSameStartupCondition(bizProcInfo)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private PerformerType getPerformerType(ParticipantType type, BizProcInfo bizProcInfo) throws WfException {
        if (type.equals((Object)ParticipantType.HUMAN)) {
            return PerformerType.EMPLOYEE;
        }
        if (type.equals((Object)ParticipantType.POSITION)) {
            return PerformerType.POSITION;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER)) {
            return PerformerType.ORG_UNIT;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_MEMBER)) {
            return PerformerType.ORG_UNIT;
        }
        if (type.equals((Object)ParticipantType.ROLE)) {
            return PerformerType.ROLE;
        }
        if (type.equals((Object)ParticipantType.ALL)) {
            return PerformerType.ALL;
        }
        if (type.equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL)) {
            return PerformerType.ORG_UNIT_PRINCIPAL;
        }
        if (type.equals((Object)ParticipantType.PERMISSION_OWNER)) {
            return PerformerType.PERMISION_OWNNER;
        }
        if (type.equals((Object)ParticipantType.RELATION)) {
            logger.warn((Object)("Process starte activity participant is relation" + bizProcInfo.getProcDefId()));
            return null;
        }
        if (type.equals((Object)ParticipantType.VARIANT)) {
            logger.warn((Object)("Process starte activity participant is relation" + bizProcInfo.getProcDefId()));
            return null;
        }
        throw new WfException("Not support." + type);
    }

    public boolean hasSameStartupCondition(BizProcInfo bizProcInfo) throws WfException {
        if (bizProcInfo == null) {
            String message = "\"bizProcInfo\" is null!";
            throw new IllegalArgumentException(message);
        }
        try {
            ProcessStorer storer = new ProcessStorer(this.getContext());
            BizProcInfo dbBizProcInfo = storer.getBizProcRelation(bizProcInfo.getPerformerId(), bizProcInfo.getBizFunction(), bizProcInfo.getBizPackage(), bizProcInfo.getBizOperation());
            if (dbBizProcInfo != null) {
                if (bizProcInfo.getPerformerType().equals((Object)PerformerType.ALL)) {
                    Vector infos = storer.getBizProcRelationVector(bizProcInfo.getBizFunction(), bizProcInfo.getBizPackage(), bizProcInfo.getBizOperation());
                    int n = infos.size();
                    for (int i = 0; i < n; ++i) {
                        BizProcInfo info = (BizProcInfo)infos.get(i);
                        if (!info.getPerformerType().equals((Object)PerformerType.ALL) || info.getProcDefId().equals(bizProcInfo.getProcDefId())) continue;
                        return true;
                    }
                } else if (!dbBizProcInfo.getProcDefId().equals(bizProcInfo.getProcDefId())) {
                    return true;
                }
            }
            return false;
        }
        catch (SQLException ex) {
            throw new WfException(ex.getMessage(), (Throwable)ex);
        }
        catch (DataAccessException e) {
            throw new WfException("DataAccessException", (Throwable)e);
        }
    }

    private IUIConfSolutionProvider getUIConfSolutionProvider() throws WfException {
        IUIConfSolutionProvider provider;
        try {
            provider = (IUIConfSolutionProvider)Class.forName("com.kingdee.eas.base.multiapprove.app.UIConfSolutionProvider").newInstance();
        }
        catch (InstantiationException e) {
            throw new WfException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WfException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new WfException((Throwable)e);
        }
        return provider;
    }

    public UIConfSolutionInfo[] getUIConfSolutionInfos(String orgID, String uiFullName) throws WfException {
        return this.getUIConfSolutionProvider().getUIConfSolutionInfos(this.getContext(), orgID, uiFullName);
    }

    public UIConfSolutionInfo getUIConfSolutionInfo(String uiConfSolutionID) throws WfException {
        return this.getUIConfSolutionProvider().getUIConfSolutionInfo(this.getContext(), uiConfSolutionID);
    }

    public Waf2UIConfSolutionInfo[] getWaf2UIConfSolutionInfos(String orgID, String[] entityObjectNames) throws WfException {
        return this.getUIConfSolutionProvider().getWaf2UIConfSolutionInfos(this.getContext(), orgID, entityObjectNames);
    }

    public Waf2UIConfSolutionInfo getWaf2UIConfSolutionInfo(String solutionID) throws WfException {
        return this.getUIConfSolutionProvider().getWaf2UIConfSolutionInfo(this.getContext(), solutionID);
    }
}

