/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.microflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.microflow.EventMap;
import com.kingdee.bos.microflow.MicroFlowEngine;
import com.kingdee.bos.microflow.adapter.MicroflowUtil;
import com.kingdee.bos.microflow.types.BOSUuidType;
import com.kingdee.bos.microflow.types.ObjectValueType;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BizEventListener
extends AbstractServiceAdapter
implements ServletContextListener {
    private static Map<String, EventMap> maps = new ConcurrentHashMap<String, EventMap>();
    private static final Logger logger = Logger.getLogger(BizEventListener.class);

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (!this.isEntityOrFacadeInvoke(serviceContext)) {
            return;
        }
        Context ctx = serviceContext.getContext();
        BizEventMap.EventStructEntry[] events = this.getEvents(serviceContext, ctx);
        if (events == null || events.length == 0) {
            return;
        }
        String boId = this.getBillObjectId(serviceContext, events);
        if (boId == null || boId.length() == 0) {
            return;
        }
        int when = serviceContext.getExecutionMode();
        EventMap map = BizEventListener.getEventMap(serviceContext.getContext());
        for (BizEventMap.EventStructEntry e : events) {
            String procDefId = map.getProcDefId(e.getFunction(), e.getOperation(), when);
            if (procDefId == null) continue;
            Flow flow = MicroFlowEngine.getEngine(ctx).getFlow(procDefId);
            Object param = this.getParams(serviceContext, boId, flow);
            this.executeMicroFlow(flow, ctx, param);
        }
    }

    private void executeMicroFlow(Flow flow, Context ctx, Object param) {
        FlowContext runtime = flow.newInstance();
        MicroflowUtil.setContext(runtime, ctx);
        try {
            runtime.execute(new Object[]{param});
            List output = runtime.getOutput();
            output.size();
        }
        catch (Exception e1) {
            throw new RuntimeException(e1.getMessage(), e1);
        }
    }

    private Object getParams(IServiceContext serviceContext, String boId, Flow flow) throws WfException {
        List inputs = flow.getInputVariables();
        if (inputs.size() == 0) {
            throw new RuntimeException("\u5fae\u6d41\u7a0b(" + flow + ")\u6ca1\u6709\u8f93\u5165\u53d8\u91cf\uff01");
        }
        if (inputs.size() > 1) {
            throw new RuntimeException("\u5fae\u6d41\u7a0b(" + flow + ")\u7684\u8f93\u5165\u53d8\u91cf\u592a\u591a\uff01");
        }
        Variable var = (Variable)inputs.get(0);
        Object param = null;
        if (var.getType() instanceof ObjectValueType) {
            param = this.getBizObjectFromServiceContext(serviceContext, boId);
            if (param == null) {
                param = FunctionHelper.createObjectValueByBoId((String)boId, (Context)serviceContext.getContext(), null);
            }
        } else if (var.getType() == BOSUuidType.TYPE) {
            param = boId;
        } else {
            throw new RuntimeException("\u5fae\u6d41\u7a0b(" + flow + ")\u7684\u8f93\u5165\u53d8\u91cf\u4e0d\u662f\u5355\u636e\u5bf9\u8c61\u6216BOSUuid\u7c7b\u578b\uff01");
        }
        return param;
    }

    private String getBillObjectId(IServiceContext serviceContext, BizEventMap.EventStructEntry[] events) {
        EventInfo eventInfo = events[0].getEvent();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        Object[] args = serviceContext.getOperationParameters();
        String boId = EventUtils.getBoPK((EventMethodInfo)eventInfo.getEventMethods().get(operationPK.toString()), (Object[])args);
        return boId;
    }

    private IObjectValue getBizObjectFromServiceContext(IServiceContext serviceContext, String boId) {
        Object[] args = serviceContext.getOperationParameters();
        IObjectValue bizObject = null;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            if (!(args[i] instanceof IObjectValue) || !((IObjectValue)args[i]).getBOSType().equals((Object)BOSUuid.read((String)boId).getType())) continue;
            bizObject = (IObjectValue)args[i];
            return bizObject;
        }
        return null;
    }

    private BizEventMap.EventStructEntry[] getEvents(IServiceContext serviceContext, Context ctx) {
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        BizEventMap.EventStructEntry[] events = EventUtils.getMatchedEventStructEntries((Context)ctx, (BOSObjectType)boType, (IMetaDataPK)operationPK);
        return events;
    }

    private boolean isEntityOrFacadeInvoke(IServiceContext serviceContext) {
        return MetaDataTypeList.ENTITY.equals((Object)serviceContext.getMetaType()) || MetaDataTypeList.FACADE.equals((Object)serviceContext.getMetaType());
    }

    public String getName() {
        return "micro-flow-service";
    }

    public int getPriority() {
        return 1;
    }

    private static EventMap getEventMap(Context ctx) throws BOSException {
        EventMap map = maps.get(ctx.getAIS());
        if (map == null) {
            map = new EventMap(ctx);
            maps.put(ctx.getAIS(), map);
        }
        return map;
    }

    public void contextDestroyed(ServletContextEvent e) {
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            BizEventListener listener = new BizEventListener();
            ServiceManagerFactory.getServiceManager().registerService((IServiceAdapter)listener);
            ServiceManagerFactory.getServiceManager().enableService(listener.getName());
        }
        catch (CannotCreateServiceManagerException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

