/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.parser;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.engine.app.AssignmentAllocator;
import com.kingdee.bos.workflow.engine.listener.AssignmentCheck;
import com.kingdee.bos.workflow.engine.listener.CancelAssignments;
import com.kingdee.bos.workflow.engine.listener.CancelManpowerRelatedEventActivity;
import com.kingdee.bos.workflow.engine.listener.ManpowerActivityCompleted;
import com.kingdee.bos.workflow.engine.listener.ManpowerActivityHolderBizObject;
import com.kingdee.bos.workflow.engine.listener.OmitWhenHasNoAssigns;
import com.kingdee.bos.workflow.engine.listener.RemoveDeadline;
import com.kingdee.bos.workflow.engine.listener.SetupDeadline;
import com.kingdee.bos.workflow.engine.listener.StartManpowerRelatedEventActivity;
import com.kingdee.bos.workflow.engine.parser.ActivityParser;
import com.kingdee.cbos.process.vm.builder.NodeBuilder;
import com.kingdee.cbos.process.vm.model.NodeEvents;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.plugin.Task;
import java.util.List;

public class ManpowerActivityParser
implements ActivityParser {
    @Override
    public void parse(ActivityDef def, NodeBuilder node) {
        this.setApplication(def, node);
        this.addAssignmentsListener(node);
        this.setListener4BoundEvents(def, node);
        this.setBizObjectLisnter(node);
        this.setDeadlineListners(def, node);
    }

    @Override
    public void parse(Context ctx, ActivityDef def, NodeBuilder node) {
        this.setApplication(def, node);
        this.addAssignmentsListener(node);
        this.setListener4BoundEvents(def, node);
        this.setBizObjectLisnter(node);
        this.setDeadlineListners(def, node);
    }

    private void setBizObjectLisnter(NodeBuilder node) {
        node.listener(NodeEvents.ON_BIZ_COMPLETED, (Listener)ManpowerActivityHolderBizObject.INS);
        node.listener(NodeEvents.ON_BIZ_COMPLETED, (Listener)ManpowerActivityCompleted.INS);
    }

    private void setDeadlineListners(ActivityDef def, NodeBuilder node) {
        ManpowerActivityDef act = (ManpowerActivityDef)def;
        DeadlineCollection deadlines = act.getDeadlines();
        if (deadlines != null && deadlines.size() > 0) {
            node.listener(NodeEvents.ON_CHILDREN_STARTED, (Listener)SetupDeadline.INS);
            node.listener(NodeEvents.ON_RESUMED, (Listener)SetupDeadline.INS);
            node.listener(NodeEvents.ON_RETRIED, (Listener)SetupDeadline.INS);
            node.listener(NodeEvents.ON_SUSPENED, (Listener)RemoveDeadline.INS);
            node.listener(NodeEvents.ON_FAILED, (Listener)RemoveDeadline.INS);
            node.listener(NodeEvents.ON_BIZ_COMPLETED, (Listener)RemoveDeadline.INS);
            node.listener(NodeEvents.ON_TERMINATED, (Listener)RemoveDeadline.INS);
        }
    }

    protected void setApplication(ActivityDef def, NodeBuilder node) {
        node.deferredChoice();
        node.twoPhaseCompletion((Task)AssignmentAllocator.INS);
        if (((ManpowerActivityDef)def).isSkipWhenHasNoAssigns()) {
            node.listener(NodeEvents.ON_BIZ_STARTED, (Listener)OmitWhenHasNoAssigns.INS);
        } else {
            node.listener(NodeEvents.ON_BIZ_STARTED, (Listener)AssignmentCheck.INS);
        }
    }

    private void setListener4BoundEvents(ActivityDef def, NodeBuilder node) {
        List bindingEvent = ((ManpowerActivityDef)def).getBindingEventActDef();
        if (bindingEvent != null && bindingEvent.size() > 0) {
            node.listener(NodeEvents.ON_BIZ_STARTED, (Listener)StartManpowerRelatedEventActivity.INS);
            node.listener(NodeEvents.ON_PARTIAL_COMPLETED, (Listener)CancelManpowerRelatedEventActivity.INS);
            node.listener(NodeEvents.ON_TERMINATED, (Listener)CancelManpowerRelatedEventActivity.INS);
        }
    }

    private void addAssignmentsListener(NodeBuilder node) {
        CancelAssignments l = CancelAssignments.INS;
        node.listener(NodeEvents.ON_TERMINATED, (Listener)l);
    }
}

