/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.component;

import com.kingdee.bos.metadata.ResourceListenerManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class UILoadBundle
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "com.sun.facelets.component.UILoadBundle";
    public static final String COMPONENT_FAMILY = "facelets";
    private String basename;
    private String var;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UILoadBundle() {
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.loadBundle(context);
    }

    public void decode(FacesContext context) {
        this.loadBundle(context);
    }

    public void loadBundle(FacesContext context) {
        Map map;
        UIViewRoot viewRoot = context.getViewRoot();
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = context.getApplication().getDefaultLocale();
        }
        String packageName = "";
        String resFileName = "";
        if (this.getBasename() != null) {
            String baseName = this.getBasename();
            int pos = baseName.lastIndexOf(".");
            packageName = baseName.substring(0, pos);
            resFileName = baseName.substring(pos + 1);
        }
        if ((map = ResourceListenerManager.getRemoteWebResource((String)packageName, (String)resFileName, (Locale)this.convertLocale(locale))) == null || map.size() < 1) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle(this.getBasename(), locale, Thread.currentThread().getContextClassLoader());
            }
            catch (MissingResourceException e) {
                return;
            }
            map = new ResourceBundleMap(bundle);
        }
        context.getExternalContext().getRequestMap().put(this.getVar(), map);
    }

    public String getBasename() {
        ValueBinding vb;
        if (this.basename == null && (vb = this.getValueBinding("basename")) != null) {
            return (String)vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getVar() {
        ValueBinding vb;
        if (this.var == null && (vb = this.getValueBinding("var")) != null) {
            return (String)vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void restoreState(FacesContext faces, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this.basename = (String)state[1];
        this.var = (String)state[2];
    }

    public Object saveState(FacesContext faces) {
        Object[] state = new Object[]{super.saveState(faces), this.basename, this.var};
        return state;
    }

    private Locale convertLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage().equals("l1")) {
            return Locale.US;
        }
        if (locale.getLanguage().equals("l2")) {
            return Locale.CHINA;
        }
        if (locale.getLanguage().equals("l3")) {
            return Locale.TAIWAN;
        }
        return null;
    }

    private static final class ResourceBundleMap
    implements Map {
        protected final ResourceBundle bundle;

        public ResourceBundleMap(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            try {
                this.bundle.getString(key.toString());
                return true;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<ResourceEntry> s = new HashSet<ResourceEntry>();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                s.add(new ResourceEntry(k, this.bundle.getString(k)));
            }
            return s;
        }

        public Object get(Object key) {
            return this.bundle.getObject((String)key);
        }

        public boolean isEmpty() {
            return false;
        }

        public Set keySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(e.nextElement());
            }
            return s;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.keySet().size();
        }

        public Collection values() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<Object> s = new HashSet<Object>();
            while (e.hasMoreElements()) {
                s.add(this.bundle.getObject(e.nextElement()));
            }
            return s;
        }

        private static final class ResourceEntry
        implements Map.Entry {
            protected final String key;
            protected final String value;

            public ResourceEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof ResourceEntry && this.hashCode() == obj.hashCode();
            }
        }
    }
}

