/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf.core;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

public final class ValueChangeListenerHandler
extends TagHandler {
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ValueChangeListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.type, "Must be a literal class name of type ValueChangeListener");
            }
            try {
                Class c = ReflectionUtil.forName(this.type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(this.type, "Couldn't qualify ValueChangeListener", (Throwable)e);
            }
            this.listenerType = this.type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof EditableValueHolder) {
            if (ComponentSupport.isNew(parent)) {
                EditableValueHolder evh = (EditableValueHolder)((Object)parent);
                ValueExpression b = null;
                if (this.binding != null) {
                    b = this.binding.getValueExpression(ctx, ValueChangeListener.class);
                }
                LazyValueChangeListener listener = new LazyValueChangeListener(this.listenerType, b);
                evh.addValueChangeListener(listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type EditableValueHolder, type is: " + parent);
        }
    }

    private static class LazyValueChangeListener
    implements ValueChangeListener,
    Serializable {
        private transient ValueChangeListener instance;
        private final String type;
        private final ValueExpression binding;

        public LazyValueChangeListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processValueChange(ValueChangeEvent event) throws AbortProcessingException {
            if (this.instance == null) {
                FacesContext faces = FacesContext.getCurrentInstance();
                if (faces == null) {
                    return;
                }
                if (this.binding != null) {
                    this.instance = (ValueChangeListener)this.binding.getValue(faces.getELContext());
                }
                if (this.instance == null && this.type != null) {
                    try {
                        this.instance = (ValueChangeListener)ReflectionUtil.forName(this.type).newInstance();
                    }
                    catch (Exception e) {
                        throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", e);
                    }
                    if (this.binding != null) {
                        this.binding.setValue(faces.getELContext(), (Object)this.instance);
                    }
                }
            }
            if (this.instance != null) {
                this.instance.processValueChange(event);
            }
        }
    }
}

