/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.el;

import com.sun.facelets.tag.TagAttribute;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

public final class TagValueExpression
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ValueExpression orig;
    private String attr;

    public TagValueExpression() {
    }

    public TagValueExpression(TagAttribute attr, ValueExpression orig) {
        this.attr = attr.toString();
        this.orig = orig;
    }

    public Class getExpectedType() {
        return this.orig.getExpectedType();
    }

    public Class getType(ELContext context) {
        try {
            return this.orig.getType(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public Object getValue(ELContext context) {
        try {
            return this.orig.getValue(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean isReadOnly(ELContext context) {
        try {
            return this.orig.isReadOnly(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public void setValue(ELContext context, Object value) {
        try {
            this.orig.setValue(context, value);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (PropertyNotWritableException pnwe) {
            throw new PropertyNotWritableException(this.attr + ": " + pnwe.getMessage(), pnwe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagValueExpression other = (TagValueExpression)obj;
        if (this.attr == null ? other.attr != null : !this.attr.equals(other.attr)) {
            return false;
        }
        if (this.orig == null) {
            if (other.orig != null) {
                return false;
            }
        } else {
            if (other.orig == null) {
                return false;
            }
            if (!this.orig.getExpressionString().equals(other.orig.getExpressionString())) {
                return false;
            }
        }
        return true;
    }

    public String getExpressionString() {
        return this.orig.getExpressionString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attr == null ? 0 : this.attr.hashCode());
        result = 31 * result + (this.orig == null ? 0 : this.orig.hashCode());
        return result;
    }

    public boolean isLiteralText() {
        return this.orig.isLiteralText();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orig = (ValueExpression)in.readObject();
        this.attr = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.orig);
        out.writeUTF(this.attr);
    }

    public String toString() {
        return this.attr + ": " + this.orig;
    }
}

