/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.jsf.ActionSourceRule;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentRule;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.facelets.tag.jsf.ValueHolderRule;
import com.sun.facelets.util.FacesAPI;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;

public class ComponentHandler
extends MetaTagHandler {
    private static final Logger log = Logger.getLogger("facelets.tag.component");
    private final TagAttribute binding;
    private final String componentType;
    private final TagAttribute id;
    private final String rendererType;

    public ComponentHandler(ComponentConfig config) {
        super(config);
        this.componentType = config.getComponentType();
        this.rendererType = config.getRendererType();
        this.id = this.getAttribute("id");
        this.binding = this.getAttribute("binding");
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this.tagId);
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Found, marking children for cleanup");
            }
            ComponentSupport.markForDeletion(c);
        } else {
            UIViewRoot root;
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.tag + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            if (this.id != null) {
                String tmpId = this.id.getValue(ctx);
                if (tmpId == null || tmpId != null && tmpId.length() == 0) {
                    UIViewRoot root2 = ComponentSupport.getViewRoot(ctx, parent);
                    if (root2 != null) {
                        String uid = root2.createUniqueId();
                        c.setId(uid);
                    }
                } else {
                    c.setId(tmpId);
                }
            } else if (c.getId() == null && (root = ComponentSupport.getViewRoot(ctx, parent)) != null) {
                String uid = root.createUniqueId();
                c.setId(uid);
            }
            this.setAttributes(ctx, c);
            c.getAttributes().put("com.sun.facelets.MARK_ID", id);
            if (this.rendererType != null) {
                c.setRendererType(this.rendererType);
            }
            this.onComponentCreated(ctx, c, parent);
        }
        this.applyNextHandler(ctx, c);
        int childIndex = -1;
        if (componentFound) {
            ComponentSupport.finalizeForDeletion(c);
            if (facetName == null) {
                childIndex = parent.getChildren().indexOf(c);
                parent.getChildren().remove(c);
            }
        }
        this.onComponentPopulated(ctx, c, parent);
        if (facetName == null) {
            if (childIndex >= 0 && childIndex < parent.getChildCount()) {
                parent.getChildren().add(childIndex, c);
            } else {
                parent.getChildren().add(c);
            }
        } else {
            parent.getFacets().put(facetName, c);
        }
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, Object.class);
            if (FacesAPI.getVersion() >= 12) {
                c = app.createComponent(ve, faces, this.componentType);
                if (c != null) {
                    if (FacesAPI.getComponentVersion(c) >= 12) {
                        c.setValueExpression("binding", ve);
                    } else {
                        LegacyValueBinding vb = new LegacyValueBinding(ve);
                        c.setValueBinding("binding", vb);
                    }
                }
            } else {
                LegacyValueBinding vb = new LegacyValueBinding(ve);
                c = app.createComponent(vb, faces, this.componentType);
                if (c != null) {
                    c.setValueBinding("binding", vb);
                }
            }
        } else {
            c = app.createComponent(this.componentType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this.id != null) {
            return this.id.getValue(ctx);
        }
        return ctx.generateUniqueId(this.tagId);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.ignore("binding").ignore("id");
        m.addRule(ComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        return m;
    }

    protected void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.nextHandler.apply(ctx, c);
    }
}

