/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf.core;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public final class ActionListenerHandler
extends TagHandler {
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ActionListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.type, "Must be a literal class name of type ActionListener");
            }
            try {
                Class c = ReflectionUtil.forName(this.type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(this.type, "Couldn't qualify ActionListener", (Throwable)e);
            }
            this.listenerType = this.type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent instanceof ActionSource) {
            if (ComponentSupport.isNew(parent)) {
                ActionSource as = (ActionSource)((Object)parent);
                ValueExpression b = null;
                if (this.binding != null) {
                    b = this.binding.getValueExpression(ctx, ActionListener.class);
                }
                LazyActionListener listener = new LazyActionListener(this.listenerType, b);
                as.addActionListener(listener);
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private transient ActionListener instance;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            if (this.instance == null) {
                FacesContext faces = FacesContext.getCurrentInstance();
                if (faces == null) {
                    return;
                }
                if (this.binding != null) {
                    this.instance = (ActionListener)this.binding.getValue(faces.getELContext());
                }
                if (this.instance == null && this.type != null) {
                    try {
                        this.instance = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                    }
                    catch (Exception e) {
                        throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", e);
                    }
                    if (this.binding != null) {
                        this.binding.setValue(faces.getELContext(), (Object)this.instance);
                    }
                }
            }
            if (this.instance != null) {
                this.instance.processAction(event);
            }
        }
    }
}

