/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf.core;

import com.kingdee.bos.metadata.ResourceListenerManager;
import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public final class LoadBundleHandler
extends ComponentHandler {
    private final TagAttribute basename = this.getRequiredAttribute("basename");
    private final TagAttribute var = this.getRequiredAttribute("var");

    public LoadBundleHandler(ComponentConfig config) {
        super(config);
    }

    protected void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        Map map;
        super.onComponentPopulated(ctx, c, parent);
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        ResourceBundle bundle = null;
        Locale locale = root.getLocale();
        locale = root != null && root.getLocale() != null ? root.getLocale() : Locale.getDefault();
        String packageName = "";
        String resFileName = "";
        if (this.basename != null) {
            String baseName = this.basename.getValue(ctx);
            int pos = baseName.lastIndexOf(".");
            packageName = baseName.substring(0, pos);
            resFileName = baseName.substring(pos + 1);
        }
        if ((map = ResourceListenerManager.getRemoteWebResource((String)packageName, (String)resFileName, (Locale)this.convertLocale(locale))) == null || map.size() < 1) {
            try {
                String name = this.basename.getValue(ctx);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                bundle = root != null && root.getLocale() != null ? ResourceBundle.getBundle(name, root.getLocale(), cl) : ResourceBundle.getBundle(name, Locale.getDefault(), cl);
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.basename, (Throwable)e);
            }
            map = new ResourceBundleMap(bundle);
        }
        FacesContext faces = ctx.getFacesContext();
        faces.getExternalContext().getRequestMap().put(this.var.getValue(ctx), map);
    }

    private Locale convertLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage().equals("l1")) {
            return Locale.US;
        }
        if (locale.getLanguage().equals("l2")) {
            return Locale.CHINA;
        }
        if (locale.getLanguage().equals("l3")) {
            return Locale.TAIWAN;
        }
        return null;
    }

    private static final class ResourceBundleMap
    implements Map {
        protected final ResourceBundle bundle;

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            try {
                this.bundle.getString(key.toString());
                return true;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<ResourceEntry> s = new HashSet<ResourceEntry>();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                s.add(new ResourceEntry(k, this.bundle.getString(k)));
            }
            return s;
        }

        public Object get(Object key) {
            return this.bundle.getObject((String)key);
        }

        public boolean isEmpty() {
            return false;
        }

        public Set keySet() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<String> s = new HashSet<String>();
            while (e.hasMoreElements()) {
                s.add(e.nextElement());
            }
            return s;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.keySet().size();
        }

        public Collection values() {
            Enumeration<String> e = this.bundle.getKeys();
            HashSet<Object> s = new HashSet<Object>();
            while (e.hasMoreElements()) {
                s.add(this.bundle.getObject(e.nextElement()));
            }
            return s;
        }

        public ResourceBundleMap(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        private static final class ResourceEntry
        implements Map.Entry {
            protected final String key;
            protected final String value;

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof ResourceEntry && this.hashCode() == obj.hashCode();
            }

            public ResourceEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

