/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletRenderResponseContext;
import org.apache.pluto.container.impl.MimeResponseImpl;
import org.apache.pluto.container.util.ArgumentUtility;

public class RenderResponseImpl
extends MimeResponseImpl
implements RenderResponse {
    private PortletRenderResponseContext responseContext;

    public RenderResponseImpl(PortletRenderResponseContext responseContext) {
        super((PortletMimeResponseContext)responseContext);
        this.responseContext = responseContext;
    }

    protected boolean isValidContentType(String contentType) {
        boolean valid = false;
        for (String supportedType : this.getResponseContentTypes()) {
            if (supportedType.equals(contentType)) {
                valid = true;
                continue;
            }
            if (supportedType.indexOf("*") < 0) continue;
            int index = supportedType.indexOf("/");
            String supportedPrefix = supportedType.substring(0, index);
            String supportedSuffix = supportedType.substring(index + 1);
            index = contentType.indexOf("/");
            String typePrefix = contentType.substring(0, index);
            String typeSuffix = contentType.substring(index + 1);
            if (!supportedPrefix.equals("*") && !supportedPrefix.equals(typePrefix) || !supportedSuffix.equals("*") && !supportedSuffix.equals(typeSuffix)) continue;
            valid = true;
        }
        return valid;
    }

    @Override
    public void setContentType(String contentType) {
        ArgumentUtility.validateNotNull("contentType", contentType);
        int index = contentType.indexOf(59);
        if (index != -1) {
            contentType = contentType.substring(0, index);
        }
        if (!this.isValidContentType(contentType = contentType.trim())) {
            throw new IllegalArgumentException("Specified content type '" + contentType + "' is not supported.");
        }
        super.setContentType(contentType);
    }

    public void setNextPossiblePortletModes(Collection<PortletMode> portletModes) {
        ArgumentUtility.validateNotNull("portletModes", portletModes);
        if (portletModes.isEmpty()) {
            throw new IllegalArgumentException("At least one possible PortletMode should be specified.");
        }
        ArrayList<PortletMode> modes = new ArrayList<PortletMode>();
        for (PortletMode mode : portletModes) {
            if (!this.isPortletModeAllowed(mode)) continue;
            modes.add(mode);
        }
        if (modes.isEmpty()) {
            modes.add(this.getPortletWindow().getPortletMode());
        }
        this.responseContext.setNextPossiblePortletModes(modes);
    }

    public void setTitle(String title) {
        this.responseContext.setTitle(title);
    }
}

