/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.MimeResponseImpl;
import org.apache.pluto.container.impl.PortletURLImpl;

public class ResourceResponseImpl
extends MimeResponseImpl
implements ResourceResponse {
    private static final String DEFAULT_CONTAINER_CHARSET = "UTF-8";
    private boolean canSetLocaleEncoding = true;
    private String charset;
    private String requestCacheLevel;
    private PortletResourceResponseContext responseContext;

    public ResourceResponseImpl(PortletResourceResponseContext responseContext, String requestCacheLevel) {
        super((PortletMimeResponseContext)responseContext);
        this.responseContext = responseContext;
        this.requestCacheLevel = requestCacheLevel == null ? "cacheLevelPage" : requestCacheLevel;
    }

    @Override
    public PortletURL createActionURL() {
        if ("cacheLevelPage".equals(this.requestCacheLevel)) {
            return new PortletURLImpl((PortletMimeResponseContext)this.responseContext, PortletURLProvider.TYPE.ACTION);
        }
        throw new IllegalStateException("Not allowed to create an ActionURL with current request cacheability level " + this.requestCacheLevel);
    }

    @Override
    public PortletURL createRenderURL() {
        if ("cacheLevelPage".equals(this.requestCacheLevel)) {
            return new PortletURLImpl((PortletMimeResponseContext)this.responseContext, PortletURLProvider.TYPE.RENDER);
        }
        throw new IllegalStateException("Not allowed to create a RenderURL with current request cacheability level " + this.requestCacheLevel);
    }

    @Override
    public ResourceURL createResourceURL() {
        return new PortletURLImpl((PortletMimeResponseContext)this.responseContext, this.requestCacheLevel);
    }

    @Override
    public PrintWriter getWriter() throws IllegalStateException, IOException {
        if (this.charset == null) {
            this.setCharacterEncoding(DEFAULT_CONTAINER_CHARSET);
        }
        return super.getWriter();
    }

    @Override
    public String getCharacterEncoding() {
        return this.charset != null ? this.charset : DEFAULT_CONTAINER_CHARSET;
    }

    public void setCharacterEncoding(String encoding) {
        int index = encoding.indexOf(61);
        if (index != -1 && index < encoding.length() - 1) {
            encoding = encoding.substring(index + 1).trim();
        }
        if (encoding != null && encoding.length() > 0) {
            this.charset = encoding;
            this.responseContext.setCharacterEncoding(this.charset);
            this.canSetLocaleEncoding = false;
        }
    }

    @Override
    public void setContentType(String contentType) {
        if (contentType != null) {
            String encoding;
            int index = contentType.indexOf(59);
            if (index != -1 && index < contentType.length() - 1 && (encoding = contentType.substring(index + 1).trim()).length() > 0) {
                this.setCharacterEncoding(encoding);
            }
            super.setContentType(contentType);
        }
    }

    public void setContentLength(int len) {
        this.responseContext.setContentLength(len);
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            String encoding;
            this.responseContext.setLocale(locale);
            if (this.canSetLocaleEncoding && (encoding = (String)this.getPortletWindow().getPortletDefinition().getApplication().getLocaleEncodingMappings().get(locale)) != null) {
                this.setCharacterEncoding(encoding);
                this.canSetLocaleEncoding = true;
            }
        }
    }
}

