/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.SecurityConstraint;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionType;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeType;
import org.apache.pluto.container.om.portlet.impl.CustomWindowStateType;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionType;
import org.apache.pluto.container.om.portlet.impl.FilterMappingType;
import org.apache.pluto.container.om.portlet.impl.FilterType;
import org.apache.pluto.container.om.portlet.impl.ListenerType;
import org.apache.pluto.container.om.portlet.impl.PortletType;
import org.apache.pluto.container.om.portlet.impl.PublicRenderParameterType;
import org.apache.pluto.container.om.portlet.impl.SecurityConstraintType;
import org.apache.pluto.container.om.portlet.impl.UserAttributeType;
import org.apache.pluto.container.om.portlet.impl.UserDataConstraintType;

@XmlRootElement(name="portlet-app")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="portlet-appType", propOrder={"portlet", "customPortletMode", "customWindowState", "userAttribute", "securityConstraint", "resourceBundle", "filter", "filterMapping", "defaultNamespace", "eventDefinition", "publicRenderParameter", "listener", "containerRuntimeOption"})
public class PortletAppType
implements PortletApplicationDefinition {
    @XmlElement(name="portlet")
    protected List<PortletType> portlet;
    @XmlElement(name="custom-portlet-mode")
    protected List<CustomPortletModeType> customPortletMode;
    @XmlElement(name="custom-window-state")
    protected List<CustomWindowStateType> customWindowState;
    @XmlElement(name="user-attribute")
    protected List<UserAttributeType> userAttribute;
    @XmlElement(name="security-constraint")
    protected List<SecurityConstraintType> securityConstraint;
    @XmlElement(name="resource-bundle")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String resourceBundle;
    @XmlElement(name="filter")
    protected List<FilterType> filter;
    @XmlElement(name="filter-mapping")
    protected List<FilterMappingType> filterMapping;
    @XmlElement(name="default-namespace")
    @XmlSchemaType(name="anyURI")
    protected String defaultNamespace;
    @XmlElement(name="event-definition")
    protected List<EventDefinitionType> eventDefinition;
    @XmlElement(name="public-render-parameter")
    protected List<PublicRenderParameterType> publicRenderParameter;
    @XmlElement(name="listener")
    protected List<ListenerType> listener;
    @XmlElement(name="container-runtime-option")
    protected List<ContainerRuntimeOptionType> containerRuntimeOption;
    @XmlAttribute(required=true)
    protected String version = "2.0";
    @XmlTransient
    protected String name;
    @XmlTransient
    protected String contextPath;
    @XmlTransient
    protected Map<Locale, String> localeEncodingMappings;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public PortletDefinition getPortlet(String portletName) {
        for (PortletDefinition portletDefinition : this.getPortlets()) {
            if (!portletDefinition.getPortletName().equals(portletName)) continue;
            return portletDefinition;
        }
        return null;
    }

    public List<? extends PortletDefinition> getPortlets() {
        if (this.portlet == null) {
            this.portlet = new ArrayList<PortletType>();
        }
        return this.portlet;
    }

    public PortletDefinition addPortlet(String portletName) {
        if (this.getPortlet(portletName) != null) {
            throw new IllegalArgumentException("Portlet with name: " + portletName + " already defined");
        }
        PortletType p = new PortletType();
        p.setPortletName(portletName);
        p.setApplication(this);
        this.portlet.add(p);
        return p;
    }

    public CustomPortletMode getCustomPortletMode(String name) {
        for (CustomPortletMode customPortletMode : this.getCustomPortletModes()) {
            if (!customPortletMode.getPortletMode().equalsIgnoreCase(name)) continue;
            return customPortletMode;
        }
        return null;
    }

    public List<? extends CustomPortletMode> getCustomPortletModes() {
        if (this.customPortletMode == null) {
            this.customPortletMode = new ArrayList<CustomPortletModeType>();
        }
        return this.customPortletMode;
    }

    public CustomPortletMode addCustomPortletMode(String name) {
        if (this.getCustomPortletMode(name) != null) {
            throw new IllegalArgumentException("Custom PortletMode with mode name: " + name + " already defined");
        }
        CustomPortletModeType cpm = new CustomPortletModeType();
        cpm.setPortletMode(name);
        this.customPortletMode.add(cpm);
        return cpm;
    }

    public CustomWindowState getCustomWindowState(String name) {
        for (CustomWindowState customWindowState : this.getCustomWindowStates()) {
            if (!customWindowState.getWindowState().equalsIgnoreCase(name)) continue;
            return customWindowState;
        }
        return null;
    }

    public List<? extends CustomWindowState> getCustomWindowStates() {
        if (this.customWindowState == null) {
            this.customWindowState = new ArrayList<CustomWindowStateType>();
        }
        return this.customWindowState;
    }

    public CustomWindowState addCustomWindowState(String name) {
        if (this.getCustomWindowState(name) != null) {
            throw new IllegalArgumentException("Custom WindowState with state name: " + name + " already defined");
        }
        CustomWindowStateType cws = new CustomWindowStateType();
        cws.setWindowState(name);
        this.customWindowState.add(cws);
        return cws;
    }

    public UserAttribute getUserAttribute(String name) {
        for (UserAttribute userAttribute : this.getUserAttributes()) {
            if (!userAttribute.getName().equals(name)) continue;
            return userAttribute;
        }
        return null;
    }

    public List<? extends UserAttribute> getUserAttributes() {
        if (this.userAttribute == null) {
            this.userAttribute = new ArrayList<UserAttributeType>();
        }
        return this.userAttribute;
    }

    public UserAttribute addUserAttribute(String name) {
        if (this.getUserAttribute(name) != null) {
            throw new IllegalArgumentException("User attribute with name: " + name + " already defined");
        }
        UserAttributeType ua = new UserAttributeType();
        ua.setName(name);
        this.userAttribute.add(ua);
        return ua;
    }

    public List<? extends SecurityConstraint> getSecurityConstraints() {
        if (this.securityConstraint == null) {
            this.securityConstraint = new ArrayList<SecurityConstraintType>();
        }
        return this.securityConstraint;
    }

    public SecurityConstraint addSecurityConstraint(String transportGuarantee) {
        SecurityConstraintType sc = new SecurityConstraintType();
        ((UserDataConstraintType)sc.getUserDataConstraint()).setTransportGuarantee(transportGuarantee);
        this.getSecurityConstraints();
        this.securityConstraint.add(sc);
        return sc;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String value) {
        this.resourceBundle = value;
    }

    public Filter getFilter(String name) {
        for (Filter filter : this.getFilters()) {
            if (!filter.getFilterName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    public List<? extends Filter> getFilters() {
        if (this.filter == null) {
            this.filter = new ArrayList<FilterType>();
        }
        return this.filter;
    }

    public Filter addFilter(String name) {
        if (this.getFilter(name) != null) {
            throw new IllegalArgumentException("Filter with name: " + name + " already defined");
        }
        FilterType f = new FilterType();
        f.setFilterName(name);
        this.filter.add(f);
        return f;
    }

    public FilterMapping getFilterMapping(String name) {
        for (FilterMapping filterMapping : this.getFilterMappings()) {
            if (!filterMapping.getFilterName().equals(name)) continue;
            return filterMapping;
        }
        return null;
    }

    public List<? extends FilterMapping> getFilterMappings() {
        if (this.filterMapping == null) {
            this.filterMapping = new ArrayList<FilterMappingType>();
        }
        return this.filterMapping;
    }

    public FilterMapping addFilterMapping(String name) {
        if (this.getFilterMapping(name) != null) {
            throw new IllegalArgumentException("Filtermapping for filter: " + name + " already defined");
        }
        FilterMappingType fm = new FilterMappingType();
        fm.setFilterName(name);
        this.filterMapping.add(fm);
        return fm;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace != null ? this.defaultNamespace : "";
    }

    public void setDefaultNamespace(String value) {
        this.defaultNamespace = value;
    }

    public List<? extends EventDefinition> getEventDefinitions() {
        if (this.eventDefinition == null) {
            this.eventDefinition = new ArrayList<EventDefinitionType>();
        }
        return this.eventDefinition;
    }

    public EventDefinition addEventDefinition(String name) {
        EventDefinitionType ed = new EventDefinitionType();
        ed.setName(name);
        this.eventDefinition.add(ed);
        return ed;
    }

    public EventDefinition addEventDefinition(QName qname) {
        EventDefinitionType ed = new EventDefinitionType();
        ed.setQName(qname);
        this.eventDefinition.add(ed);
        return ed;
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        for (PublicRenderParameter publicRenderParameter : this.getPublicRenderParameters()) {
            if (!publicRenderParameter.getIdentifier().equals(identifier)) continue;
            return publicRenderParameter;
        }
        return null;
    }

    public List<? extends PublicRenderParameter> getPublicRenderParameters() {
        if (this.publicRenderParameter == null) {
            this.publicRenderParameter = new ArrayList<PublicRenderParameterType>();
        }
        return this.publicRenderParameter;
    }

    public PublicRenderParameter addPublicRenderParameter(String name, String identifier) {
        if (this.getPublicRenderParameter(identifier) != null) {
            throw new IllegalArgumentException("PublicRenderParameter with identifier: " + identifier + " already defined");
        }
        PublicRenderParameterType p = new PublicRenderParameterType();
        p.setName(name);
        p.setIdentifier(identifier);
        this.publicRenderParameter.add(p);
        return p;
    }

    public PublicRenderParameter addPublicRenderParameter(QName qname, String identifier) {
        if (this.getPublicRenderParameter(identifier) != null) {
            throw new IllegalArgumentException("PublicRenderParameter with identifier: " + identifier + " already defined");
        }
        PublicRenderParameterType p = new PublicRenderParameterType();
        p.setQName(qname);
        p.setIdentifier(identifier);
        this.publicRenderParameter.add(p);
        return p;
    }

    public List<? extends Listener> getListeners() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public Listener addListener(String listenerClass) {
        for (Listener listener : this.getListeners()) {
            if (!listener.getListenerClass().equals(listenerClass)) continue;
            throw new IllegalArgumentException("Listener of class: " + listenerClass + " already defined");
        }
        ListenerType l = new ListenerType();
        l.setListenerClass(listenerClass);
        this.listener.add(l);
        return l;
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String name) {
        for (ContainerRuntimeOption containerRuntimeOption : this.getContainerRuntimeOptions()) {
            if (!containerRuntimeOption.getName().equals(name)) continue;
            return containerRuntimeOption;
        }
        return null;
    }

    public List<? extends ContainerRuntimeOption> getContainerRuntimeOptions() {
        if (this.containerRuntimeOption == null) {
            this.containerRuntimeOption = new ArrayList<ContainerRuntimeOptionType>();
        }
        return this.containerRuntimeOption;
    }

    public ContainerRuntimeOption addContainerRuntimeOption(String name) {
        if (this.getContainerRuntimeOption(name) != null) {
            throw new IllegalArgumentException("Container runtime option with name: " + name + " already defined");
        }
        ContainerRuntimeOptionType cro = new ContainerRuntimeOptionType();
        cro.setName(name);
        this.containerRuntimeOption.add(cro);
        return cro;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        if (!"1.0".equals(value) && !"2.0".equals(value)) {
            throw new IllegalArgumentException("Application descriptor version: " + value + " unsupported.");
        }
        this.version = value;
    }

    public Map<Locale, String> getLocaleEncodingMappings() {
        if (this.localeEncodingMappings == null) {
            this.localeEncodingMappings = new HashMap<Locale, String>();
        }
        return this.localeEncodingMappings;
    }

    public void addLocaleEncodingMapping(Locale locale, String encoding) {
        this.getLocaleEncodingMappings().put(locale, encoding);
    }
}

