/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.BatchSqlParamterProvider;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLException;
import com.kingdee.shr.dydeploy.web.executeSql.SqlProvider;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class BatchPreparedSQLExecutor
implements BatchSqlParamterProvider,
SqlProvider {
    private String preparedSQL;
    private Object[][] preparedValues;
    private int rowIndex = -1;
    private ArrayList exceptions = new ArrayList();

    public BatchPreparedSQLExecutor(String sql, Object[][] values) {
        this.preparedSQL = sql;
        this.preparedValues = values;
    }

    @Override
    public boolean hasMoreValues() {
        ++this.rowIndex;
        return this.rowIndex < this.preparedValues.length;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        for (int i = 0; i < this.preparedValues[this.rowIndex].length; ++i) {
            ps.setObject(i + 1, this.preparedValues[this.rowIndex][i]);
        }
    }

    @Override
    public boolean useParameters() {
        return this.preparedValues != null && this.preparedValues.length > 0;
    }

    @Override
    public String getProviderName() {
        return "BatchPreparedSQLExecutor";
    }

    @Override
    public String getSql() throws DBSQLException {
        return this.preparedSQL;
    }

    @Override
    public boolean handleException(DBSQLException sqle) {
        this.exceptions.add(sqle);
        return false;
    }

    @Override
    public ArrayList getExceptions() {
        return this.exceptions;
    }
}

