/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.FileAccess;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EASSqlScriptFileAccess
implements FileAccess {
    private Logger logger = Logger.getLogger(EASSqlScriptFileAccess.class);
    private String basePath;

    public EASSqlScriptFileAccess(String baseFile) {
        if (baseFile.indexOf("upgradescript") >= 0) {
            this.basePath = baseFile.substring(0, baseFile.indexOf("upgradescript"));
            this.basePath = StringUtils.cleanPath(this.basePath);
        } else {
            this.basePath = new File(baseFile).exists() && new File(baseFile).isFile() ? new File(baseFile).getParent() : baseFile;
        }
    }

    @Override
    public String getBaseFile() {
        return this.basePath;
    }

    @Override
    public InputStream getFileInputStream(String filename) {
        try {
            return new FileInputStream(this.getFilePath(filename));
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"Get fileinputstream error!", (Throwable)e);
            throw new AdminException("File[" + filename + "] not found!", e);
        }
    }

    @Override
    public String[] getFileNames(String filename) throws IOException {
        if (filename.indexOf("*") >= 0) {
            String path = this.getFilePath(filename);
            String fName = path.substring(path.lastIndexOf("/") + 1);
            fName = StringUtils.replace(fName, "*", "\\S*");
            fName = StringUtils.replace(fName, ".", "\\.");
            final Pattern p = Pattern.compile(fName);
            File fPath = new File(path = path.substring(0, path.lastIndexOf("/")));
            File[] files = fPath.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return p.matcher(name).matches();
                }
            });
            if (files != null) {
                Object[] res = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    res[i] = files[i].getCanonicalPath();
                }
                Arrays.sort(res);
                this.logger.debug((Object)("Find files " + Arrays.asList(res) + " matches [" + fName + "] was found in [" + fPath.getAbsolutePath() + "]!"));
                return res;
            }
            this.logger.warn((Object)("No files matches [" + fName + "] was found in [" + fPath.getAbsolutePath() + "]!"));
            return new String[0];
        }
        return new String[]{this.getFilePath(filename)};
    }

    @Override
    public boolean isFileExist(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    private String getFilePath(String filePath) throws FileNotFoundException {
        if (!new File(filePath).exists()) {
            filePath = StringUtils.cleanPath(filePath);
            if (!new File(this.basePath + "/" + filePath).exists()) {
                throw new FileNotFoundException("Script file [" + filePath + "] and [" + this.basePath + "/" + filePath + "] doesn't exist!");
            }
            return this.basePath + "/" + filePath;
        }
        return filePath;
    }
}

