/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.executeSql.InetUtil;
import com.kingdee.shr.dydeploy.web.executeSql.MessageVO;
import com.kingdee.shr.dydeploy.web.executeSql.XMLElement;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MyConsoleMulticastSocket {
    Logger logger = Logger.getLogger(MyConsoleMulticastSocket.class);
    private static final String BROADCAST_IP = System.getProperty("broadcastIP", "224.223.222.221");
    public static final int BROADCAST_PORT = new Integer(System.getProperty("broadcastPort", "30000"));
    private MulticastSocket socket = null;
    private InetAddress broadcastAddress = null;
    private final int DATA_LEN = 4096;
    byte[] inBuff = new byte[4096];
    private SendThread sendThread = new SendThread();
    private ReceiveThread receiveThread = new ReceiveThread();
    private String lastQuestionType;
    private MessageVO receivedMsg;

    public MyConsoleMulticastSocket() {
        try {
            this.init();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    public void init() throws IOException {
        this.socket = new MulticastSocket(BROADCAST_PORT);
        String bindIP = System.getProperty("bindIPForMulticastSocket");
        InetAddress localAddress = null;
        if (bindIP != null && bindIP.length() > 0) {
            String[] strIP;
            this.logger.info((Object)("Bind ip [" + SHRCheck.vaildLog((String)bindIP) + "]"));
            if (!InetUtil.getLocalIPList().contains(bindIP)) {
                this.logger.error((Object)("IP [" + SHRCheck.vaildLog((String)bindIP) + "] isn't bind by this computer"));
                System.exit(-1);
            }
            if ((strIP = bindIP.split("\\.")).length >= 4) {
                byte[] ip = new byte[]{(byte)new Integer(strIP[0]).intValue(), (byte)new Integer(strIP[1]).intValue(), (byte)new Integer(strIP[2]).intValue(), (byte)new Integer(strIP[3]).intValue()};
                localAddress = InetAddress.getByAddress(ip);
            }
        }
        if (localAddress == null) {
            localAddress = InetAddress.getLocalHost();
            this.logger.info((Object)SHRCheck.vaildLog((String)("localAddress = " + (localAddress != null ? localAddress.toString() : "null"))));
        }
        this.socket.setNetworkInterface(NetworkInterface.getByInetAddress(localAddress));
        this.broadcastAddress = InetAddress.getByName(BROADCAST_IP);
        this.socket.joinGroup(this.broadcastAddress);
        this.socket.setLoopbackMode(false);
        new Thread(this.sendThread).start();
        new Thread(this.receiveThread).start();
    }

    public void sendMessage(String questionType, String ip, String port, String detail) {
        MessageVO vo = new MessageVO();
        vo.setMsgID(String.valueOf(System.currentTimeMillis()));
        vo.setMsgType("question");
        vo.setQuestionType(questionType);
        vo.setIP(ip);
        vo.setPort(port);
        vo.setMsgetail(detail);
        this.lastQuestionType = vo.getQuestionType();
        this.sendThread.sendMsg(vo);
        this.receivedMsg = null;
    }

    public MessageVO getAnswerMsg() {
        return this.receivedMsg;
    }

    class SendThread
    implements Runnable {
        ArrayList msgList = new ArrayList();

        SendThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMsg(MessageVO vo) {
            ArrayList arrayList = this.msgList;
            synchronized (arrayList) {
                this.msgList.add("<message><msgID>" + vo.getMsgID() + "</msgID><msgType>" + vo.getMsgType() + "</msgType><questionType>" + vo.getQuestionType() + "</questionType><appName>" + vo.getAppName() + "</appName><ip>" + vo.getIP() + "</ip><port>" + vo.getPort() + "</port><msgDetail>" + vo.getMsgDetail() + "</msgDetail></message>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getNextMsg() {
            ArrayList arrayList = this.msgList;
            synchronized (arrayList) {
                if (this.msgList != null && this.msgList.size() > 0) {
                    String msg = (String)this.msgList.get(this.msgList.size() - 1);
                    this.msgList.remove(this.msgList.size() - 1);
                    return msg.getBytes();
                }
                return null;
            }
        }

        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        byte[] msg = this.getNextMsg();
                        while (msg != null) {
                            DatagramPacket outPacket = new DatagramPacket(new byte[0], 0, MyConsoleMulticastSocket.this.broadcastAddress, BROADCAST_PORT);
                            MyConsoleMulticastSocket.this.logger.debug((Object)("Send message :" + new String(msg)));
                            outPacket.setData(msg);
                            MyConsoleMulticastSocket.this.socket.send(outPacket);
                            msg = this.getNextMsg();
                        }
                        try {
                            Thread.sleep(500L);
                            continue block6;
                        }
                        catch (InterruptedException e) {
                            MyConsoleMulticastSocket.this.logger.error((Object)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    MyConsoleMulticastSocket.this.logger.error((Object)ex);
                    try {
                        if (MyConsoleMulticastSocket.this.socket != null) {
                            MyConsoleMulticastSocket.this.socket.leaveGroup(MyConsoleMulticastSocket.this.broadcastAddress);
                            MyConsoleMulticastSocket.this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        MyConsoleMulticastSocket.this.logger.error((Object)e);
                    }
                    return;
                }
            }
        }
    }

    class ReceiveThread
    implements Runnable {
        private DatagramPacket inPacket;

        ReceiveThread() {
            this.inPacket = new DatagramPacket(MyConsoleMulticastSocket.this.inBuff, MyConsoleMulticastSocket.this.inBuff.length);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    MyConsoleMulticastSocket.this.socket.receive(this.inPacket);
                    InetAddress fromIP = this.inPacket.getAddress();
                    int fromPort = this.inPacket.getPort();
                    String msg = new String(MyConsoleMulticastSocket.this.inBuff, 0, this.inPacket.getLength());
                    MyConsoleMulticastSocket.this.logger.debug((Object)("Received from " + fromIP + " on port " + fromPort + ": " + msg));
                    if (msg.indexOf("answer") < 0) continue;
                    this.dealAnswerMsg(msg);
                }
            }
            catch (IOException ex) {
                MyConsoleMulticastSocket.this.logger.error((Object)ex);
                try {
                    if (MyConsoleMulticastSocket.this.socket != null) {
                        MyConsoleMulticastSocket.this.socket.leaveGroup(MyConsoleMulticastSocket.this.broadcastAddress);
                        MyConsoleMulticastSocket.this.socket.close();
                    }
                }
                catch (IOException e) {
                    MyConsoleMulticastSocket.this.logger.error((Object)e);
                }
                return;
            }
        }

        void dealAnswerMsg(String msg) {
            XMLElement xmlEle = new XMLElement();
            xmlEle.parseString(msg);
            Vector vt = xmlEle.getChildren();
            if (vt != null) {
                MessageVO vo = new MessageVO();
                for (int i = 0; i < vt.size(); ++i) {
                    XMLElement e_child = (XMLElement)vt.get(i);
                    if ("msgID".equals(e_child.getName())) {
                        vo.setMsgID(e_child.getContent());
                        continue;
                    }
                    if ("msgType".equals(e_child.getName())) {
                        vo.setMsgType(e_child.getContent());
                        continue;
                    }
                    if ("questionType".equals(e_child.getName())) {
                        vo.setQuestionType(e_child.getContent());
                        continue;
                    }
                    if ("appName".equals(e_child.getName())) {
                        vo.setAppName(e_child.getContent());
                        continue;
                    }
                    if ("ip".equals(e_child.getName())) {
                        vo.setIP(e_child.getContent());
                        continue;
                    }
                    if ("port".equals(e_child.getName())) {
                        vo.setPort(e_child.getContent());
                        continue;
                    }
                    if (!"msgDetail".equals(e_child.getName())) continue;
                    vo.setMsgetail(e_child.getContent());
                }
                if (MyConsoleMulticastSocket.this.lastQuestionType != null && MyConsoleMulticastSocket.this.lastQuestionType.equals(vo.getQuestionType())) {
                    MyConsoleMulticastSocket.this.receivedMsg = vo;
                } else {
                    MyConsoleMulticastSocket.this.logger.debug((Object)("lastQuestionType is [" + MyConsoleMulticastSocket.this.lastQuestionType + "], but received message question type [" + vo.getQuestionType() + "]"));
                }
            }
        }
    }
}

