/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.ServiceRegisteListener;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceRegistry {
    private static final Logger logger = Logger.getLogger(ServiceRegistry.class);
    private static final HashMap serviceRegMap = new HashMap();
    private static ArrayList listeners = new ArrayList();
    private static final Map serviceCallbackCacheMaps = Collections.synchronizedMap(new HashMap());

    public static void addServiceRegisteListener(ServiceRegisteListener listener) {
        listeners.add(listener);
    }

    public static void removeServiceRegisteListener(ServiceRegisteListener listener) {
        listeners.remove(listener);
    }

    public static void bind(Class serviceInterface, Object serviceImpl) throws RemoteException, IllegalArgumentException, MalformedURLException, AlreadyBoundException {
        String name = serviceInterface.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Begin bind [" + serviceImpl + "] to [" + name + "]......"));
        }
        if (serviceRegMap.get(name) != null) {
            throw new RuntimeException("Service[" + name + "] already bind!");
        }
        serviceRegMap.put(name, serviceImpl);
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceRegisteListener listener = (ServiceRegisteListener)listeners.get(i);
            listener.serviceBind(serviceInterface, serviceImpl);
        }
    }

    public static void rebind(Class serviceInterface, Object serviceImpl) throws RemoteException, IllegalArgumentException, MalformedURLException {
        String name = serviceInterface.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Begin Rebind [" + serviceImpl + "] to [" + name + "]......"));
        }
        serviceRegMap.put(name, serviceImpl);
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceRegisteListener listener = (ServiceRegisteListener)listeners.get(i);
            listener.serviceReBind(serviceInterface, serviceImpl);
        }
    }

    public static void unbind(Class serviceInterface) throws RemoteException, MalformedURLException, NotBoundException {
        String name = serviceInterface.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Begin Unbind [" + name + "]......"));
        }
        serviceRegMap.remove(name);
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceRegisteListener listener = (ServiceRegisteListener)listeners.get(i);
            listener.serviceUnBind(serviceInterface);
        }
    }

    public static Object getServiceImplement(Class serviceInterface) {
        String name = serviceInterface.getName();
        return serviceRegMap.get(name);
    }

    public static ArrayList getServiceCallbackListeners(Class callbackInterface) {
        ArrayList callbacks = (ArrayList)serviceCallbackCacheMaps.get(callbackInterface.getName());
        if (callbacks == null) {
            return new ArrayList(0);
        }
        return callbacks;
    }

    public static void addCallbackListeners(Class callbackInterface, Object listenerObj) {
        ArrayList<Object> callbacks = (ArrayList<Object>)serviceCallbackCacheMaps.get(callbackInterface.getName());
        if (callbacks == null) {
            callbacks = new ArrayList<Object>(1);
        }
        callbacks.add(listenerObj);
        serviceCallbackCacheMaps.put(callbackInterface.getName(), callbacks);
    }

    public static void removeCallbackListeners(Class callbackInterface, Object listenerObj) {
        boolean removed;
        ArrayList callbacks = (ArrayList)serviceCallbackCacheMaps.get(callbackInterface.getName());
        if (callbacks == null) {
            callbacks = new ArrayList(1);
        }
        if (removed = callbacks.remove(listenerObj)) {
            logger.info((Object)("One [" + callbackInterface.getName() + "] callback has remove from cache , current size[" + callbacks.size() + "]"));
        }
        serviceCallbackCacheMaps.put(callbackInterface.getName(), callbacks);
    }
}

