/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.util;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.cache.OrganCache;
import com.kingdee.eas.mobileaccess.hr.common.ec.config.EcConfigBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.org.OrgNameProvide;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EcCommonUtil {
    public static String formatOrgPersonCount(String type, String orgId, String orgName) {
        if ("all".equals(type)) {
            int count = OrganCache.getInstance().getAllPersonCount(orgId);
            return orgName + "  (\u5171" + count + "\u4eba)";
        }
        if ("sub".equals(type)) {
            int count = OrganCache.getInstance().getSubPersonCount(orgId);
            return orgName + "  (\u76f4\u5c5e" + count + "\u4eba)";
        }
        return orgName;
    }

    public static String formatOrgPersonCountByAuth(UserInfo loginUserInfo, String type, String orgId, String orgName) {
        if (EcCommonUtil.showOrgPersonCount(loginUserInfo)) {
            return EcCommonUtil.formatOrgPersonCount(type, orgId, orgName);
        }
        return orgName;
    }

    public static String getOrgActualDisplayName(OrgNameProvide org) {
        boolean show = EcConfigBean.getInstance().showOrganLongName();
        return show ? org.getOrgDisplayName() : org.getOrgName();
    }

    public static String getOrgActualDisplayName(String orgName, String orgDisplayName) {
        boolean show = EcConfigBean.getInstance().showOrganLongName();
        return show ? orgDisplayName : orgName;
    }

    public static boolean showOrgPersonCount(UserInfo loginUserInfo) {
        String[] black = EcConfigBean.getInstance().getStringArray("show_orgcount_userid_black");
        String userId = loginUserInfo.getId().toString();
        if (black == null || black.length == 0) {
            String[] white = EcConfigBean.getInstance().getStringArray("show_orgcount_userid_white");
            if (white == null || white.length == 0) {
                return true;
            }
            if (white.length == 1 && StringUtils.isBlank((String)white[0])) {
                return false;
            }
            List<String> whiteList = Arrays.asList(white);
            return whiteList.contains(userId);
        }
        if (black.length == 1 && StringUtils.isBlank((String)black[0])) {
            return true;
        }
        List<String> blackList = Arrays.asList(black);
        return !blackList.contains(userId);
    }

    public static boolean filterOrgByConfig(OrganBean org) {
        if (org == null) {
            return true;
        }
        boolean showNoPersonOrg = EcConfigBean.getInstance().showNoPersonOrg();
        String subOrgId = org.getId();
        OrganCache config = OrganCache.getInstance();
        int allPersonCount = config.getAllPersonCount(subOrgId);
        if (!showNoPersonOrg && allPersonCount == 0 && config.isInit()) {
            return true;
        }
        String name = org.getName();
        List<String> words = EcConfigBean.getInstance().getWordForFilterOrgan();
        if (words.size() > 0) {
            for (String w : words) {
                if (name.indexOf(w) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean filterOrgByName(String orgName) {
        List<String> words = EcConfigBean.getInstance().getWordForFilterOrgan();
        if (words.size() > 0) {
            for (String w : words) {
                if (orgName.indexOf(w) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean filterPersonMobile(String personNumber) {
        if (personNumber == null) {
            return false;
        }
        EcConfigBean instance = EcConfigBean.getInstance();
        String[] stringArray = instance.getStringArray("ec.personInfo.mobile.unDisplay_list");
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (String s : stringArray) {
            if (!s.equals(personNumber)) continue;
            return true;
        }
        return false;
    }

    private static String replaceAllOrderBy(String orderby, String key, String alias) {
        if (StringUtils.isEmpty((String)orderby)) {
            return "";
        }
        if (StringUtils.isEmpty((String)key)) {
            return orderby;
        }
        if (alias == null) {
            alias = "";
        } else if (alias.trim().length() > 0) {
            alias = alias + ".";
        }
        return orderby.replaceAll(key + "\\.", alias);
    }

    public static String join(Object[] arr) {
        return EcCommonUtil.join(arr, ", ");
    }

    public static String join(Object[] arr, String joinStr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (joinStr == null) {
            joinStr = ",";
        }
        int iMax = arr.length - 1;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(String.valueOf(arr[i]));
            if (i == iMax) {
                return b.toString();
            }
            b.append(joinStr);
            ++i;
        }
    }

    public static String getOrgOrderBy(String orgAlias) {
        Object[] arr = EcConfigBean.getInstance().getStringArray("ec.organ.orderby");
        String orderby = "";
        orderby = arr == null || arr.length == 0 ? " org.FSortCode asc, org.FLongNumber asc " : EcCommonUtil.join(arr);
        return EcCommonUtil.replaceAllOrderBy(orderby, "org", orgAlias);
    }

    public static String getOrgPersonOrderBy(String personAlias, String posAlias) {
        Object[] arr = EcConfigBean.getInstance().getStringArray("ec.person.orderby.orgPerson");
        String orderby = "";
        orderby = arr == null || arr.length == 0 ? "pos.FISRespPosition desc, pos.FIndex asc, person.FIndex asc" : EcCommonUtil.join(arr);
        orderby = EcCommonUtil.replaceAllOrderBy(orderby, "person", personAlias);
        orderby = EcCommonUtil.replaceAllOrderBy(orderby, "pos", posAlias);
        return orderby;
    }

    public static String getOrgAllPersonOrderBy(String personAlias, String posAlias, String orgAlias) {
        Object[] arr = EcConfigBean.getInstance().getStringArray("ec.person.orderby.orgAllPerson");
        String orderby = "";
        orderby = arr == null || arr.length == 0 ? "org.FSortCode asc, org.FLongNumber asc, pos.FISRespPosition desc, pos.FIndex asc, person.FIndex asc" : EcCommonUtil.join(arr);
        orderby = EcCommonUtil.replaceAllOrderBy(orderby, "person", personAlias);
        orderby = EcCommonUtil.replaceAllOrderBy(orderby, "pos", posAlias);
        orderby = EcCommonUtil.replaceAllOrderBy(orderby, "org", orgAlias);
        return orderby;
    }

    public static boolean hasOrgPermission(String userName) {
        String[] arr = EcConfigBean.getInstance().getStringArray("ec.organ.orgPermission.white");
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (String s : arr) {
            if (!userName.equals(s)) continue;
            return true;
        }
        return false;
    }
}

