/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.hr.common.ec.config.EcConfigBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.dao.BaseDaoSupport;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OrgPersonService {
    private static final OrgPersonService instance = new OrgPersonService();
    private String filterWord;
    private List<String> filterLongNumbers;

    private OrgPersonService() {
    }

    public static OrgPersonService getInstance() {
        return instance;
    }

    public List<String> findFilterOrgLongNumber(Context ctx) throws Exception {
        Map<String, Object> org;
        String l = LocaleUtils.getShortCode((Context)ctx);
        EcConfigBean config = EcConfigBean.getInstance();
        List<String> words = config.getWordForFilterOrgan();
        if (words.size() == 0) {
            this.filterWord = null;
            this.filterLongNumbers = null;
            return Collections.emptyList();
        }
        if (this.filterLongNumbers != null && words.toString().equals(this.filterWord)) {
            return this.filterLongNumbers;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sb.append("select flongnumber from T_ORG_Admin where FIsSealUp=0 ");
        sb.append(" and ( ");
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                sb.append(" or ");
            }
            sb.append(" FName_").append(l).append(" like ? ");
            params.add("%" + words.get(i) + "%");
        }
        sb.append(" ) order by flongnumber asc ");
        List<Map<String, Object>> find = BaseDaoSupport.find(ctx, sb.toString(), params.toArray());
        if (find == null || find.size() == 0) {
            return Collections.emptyList();
        }
        String rootLongNumber = null;
        String rootOrgId = config.getRootOrgId();
        if (rootOrgId != null && (org = BaseDaoSupport.findOne(ctx, "select flongnumber from T_ORG_Admin where Fid = ?", rootOrgId)) != null) {
            rootLongNumber = String.valueOf(org.get("FLONGNUMBER"));
        }
        ArrayList<String> nums = new ArrayList<String>();
        for (Map<String, Object> oo : find) {
            if (oo == null) continue;
            String longNumber = String.valueOf(oo.get("FLONGNUMBER"));
            boolean exist = false;
            if (rootLongNumber != null && !longNumber.startsWith(rootLongNumber)) continue;
            for (String num : nums) {
                if (!longNumber.startsWith(num)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            nums.add(longNumber);
        }
        this.filterWord = words.toString();
        this.filterLongNumbers = Collections.unmodifiableList(nums);
        return this.filterLongNumbers;
    }

    public static boolean isFilter(String longNumber, List<String> filterNums) {
        for (String m : filterNums) {
            if (!longNumber.startsWith(m)) continue;
            return true;
        }
        return false;
    }

    public static List<String> findSubFilterLongNumber(String longNumber, List<String> filterNums) {
        if (longNumber == null) {
            return new ArrayList<String>(filterNums);
        }
        ArrayList<String> subList = new ArrayList<String>();
        for (String n : filterNums) {
            if (!n.startsWith(longNumber)) continue;
            subList.add(n);
        }
        return subList;
    }
}

