/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.ec2.dao;

import com.kingdee.bos.Context;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.EmpWorkExperienceBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.OrganPersonInfoBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonRecordBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonSimpleBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.bean.PersonphotoBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.config.EcConfigBean;
import com.kingdee.eas.mobileaccess.hr.common.ec.dao.BaseDaoSupport;
import com.kingdee.eas.mobileaccess.hr.common.ec.util.EcCommonUtil;
import com.kingdee.eas.mobileaccess.hr.common.ec.util.OrgPersonService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class EcDao
extends BaseDaoSupport {
    public static PersonBean findPerson(Context ctx, String personId) throws Exception {
        String sql = "select * from T_BD_Person where FID = ?";
        return EcDao.findOne(ctx, PersonBean.class, sql, personId);
    }

    public static PersonSimpleBean findPersonSimple(Context ctx, String personId) throws Exception {
        String sql = "select * from T_BD_Person where FID = ?";
        return EcDao.findOne(ctx, PersonSimpleBean.class, sql, personId);
    }

    public static List<Map<String, Object>> findPersonMobile(Context ctx, String[] personId) throws Exception {
        if (personId == null || personId.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FCell, FBackupCell from T_BD_Person where FID in (");
        for (int i = 0; i < personId.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return EcDao.find(ctx, sb.toString(), personId);
    }

    public static List<OrganBean> searchOrgan(Context ctx, String word) throws Exception {
        return EcDao.searchOrgan(ctx, word, null);
    }

    public static List<OrganBean> searchOrgan(Context ctx, String word, String longNumber) throws Exception {
        return EcDao.searchOrgan(ctx, word, longNumber, false);
    }

    public static List<OrganBean> searchOrgan(Context ctx, String word, String longNumber, boolean withFilter) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sb.append("select o.* from T_ORG_Admin o where o.FIsSealUp=0 ");
        if (Pattern.compile("[a-zA-Z]").matcher(word).find()) {
            sb.append(" and upper(o.FName_").append(l).append(") like ? ");
            params.add("%" + word.toUpperCase() + "%");
        } else {
            sb.append(" and o.FName_").append(l).append(" like ? ");
            params.add("%" + word + "%");
        }
        if (longNumber != null) {
            sb.append("and o.FLongNumber like ? ");
            params.add(longNumber + "%");
        }
        if (withFilter) {
            List<String> nums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx);
            List<String> subNums = longNumber == null ? nums : OrgPersonService.findSubFilterLongNumber(longNumber, nums);
            int size = subNums.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    sb.append(" and o.flongnumber not like ? ");
                    params.add(subNums.get(i) + "%");
                }
            }
        }
        int searchOrgMaxSize = EcConfigBean.getInstance().getSearchOrgMaxSize();
        return EcDao.find(ctx, 0, searchOrgMaxSize, OrganBean.class, sb.toString(), params.toArray());
    }

    public static List<OrganPersonInfoBean> findOrgPersonInfo(Context ctx, String orgId, int firstResult, int maxResult) throws Exception {
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select a.fid FPersonid, a.FCell FPersonCell, a.FNumber FPersonNumber, a.FName_").append(l).append(" FPersonName, a.FGender FPersonGender, c.FName_").append(l).append(" FPositionName");
        sql.append(" from t_org_positionmember b ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" inner join T_BD_Person a on a.fid=b.fpersonid");
        sql.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.FID");
        sql.append(" where t.fisincount=1 AND a.FDeletedStatus=1  AND b.fisprimary=1 and d.fid=? ");
        String orgPersonOrderBy = EcCommonUtil.getOrgPersonOrderBy("a", "c");
        if (!StringUtils.isEmpty((String)orgPersonOrderBy)) {
            sql.append(" order by ");
            sql.append(orgPersonOrderBy);
        }
        return EcDao.find(ctx, firstResult, maxResult, OrganPersonInfoBean.class, sql.toString(), orgId);
    }

    public static List<OrganPersonInfoBean> findOrgAllPersonInfo(Context ctx, String longNumber, int firstResult, int maxResult) throws Exception {
        String orgAllPersonOrderBy;
        ArrayList<String> params = new ArrayList<String>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid FPersonid, a.FCell FPersonCell, a.FNumber FPersonNumber, a.FName_").append(l).append(" FPersonName, a.FGender FPersonGender, c.FName_").append(l).append(" FPositionName, d.FDisplayName_").append(l).append(" FOrgDisplayName, d.FName_").append(l).append(" FOrgName, d.flongnumber flongnumber");
        sql.append(" from t_org_positionmember b ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0 ");
        sql.append(" inner join T_BD_Person a on a.fid=b.fpersonid");
        sql.append(" inner join T_HR_BDEmployeeType t on a.FEmployeeTypeID=t.FID");
        sql.append(" where b.fisprimary=1 and a.FDeletedStatus=1 and t.FIsInCount = 1 ");
        sql.append(" and d.flongnumber like ? ");
        params.add(longNumber + "%");
        List<String> filterNums = OrgPersonService.getInstance().findFilterOrgLongNumber(ctx);
        List<String> subNums = OrgPersonService.findSubFilterLongNumber(longNumber, filterNums);
        int size = subNums.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                sql.append(" and d.flongnumber not like ? ");
                params.add(subNums.get(i) + "%");
            }
        }
        if (!StringUtils.isEmpty((String)(orgAllPersonOrderBy = EcCommonUtil.getOrgAllPersonOrderBy("a", "c", "d")))) {
            sql.append(" order by ");
            sql.append(orgAllPersonOrderBy);
        }
        return EcDao.find(ctx, firstResult, maxResult, OrganPersonInfoBean.class, sql.toString(), params.toArray());
    }

    public static List<EmpWorkExperienceBean> findPersonWorksByPersonId(Context ctx, String personId) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select b.FPersonID personId, c.fid positionId, c.fname_").append(l).append(" positionName, d.fid orgId, d.FName_").append(l).append(" orgName, d.FDisplayName_").append(l).append(" orgDisplayName");
        sql.append(" from t_org_positionmember b ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid ");
        sql.append(" where b.FPersonID=? and d.FIsSealUp=0");
        sql.append(" order by b.fisprimary desc, d.FSortCode asc, d.FLongNumber asc");
        return EcDao.find(ctx, EmpWorkExperienceBean.class, sql.toString(), personId);
    }

    public static OrganBean findPersonMainOrg(Context ctx, String personId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select d.*");
        sql.append(" from t_org_positionmember b ");
        sql.append(" inner join t_org_position c on b.fpositionid=c.fid  ");
        sql.append(" inner join t_org_admin d on c.FAdminOrgUnitId=d.fid and d.FIsSealUp=0");
        sql.append(" where b.FPersonID=? and b.fisprimary=1");
        return EcDao.findOne(ctx, OrganBean.class, sql.toString(), personId);
    }

    public static List<OrganBean> findOrgChildren(Context ctx, String parentId) throws Exception {
        String sql = "select * from T_ORG_Admin where FParentID = ? and FIsSealUp=0 order by findex asc, FLongNumber asc";
        return EcDao.find(ctx, OrganBean.class, sql, parentId);
    }

    public static List<OrganBean> findOrgChildrenByConfig(Context ctx, String parentId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_ORG_Admin where FParentID = ? and FIsSealUp=0 ");
        String orgOrderBy = EcCommonUtil.getOrgOrderBy(null);
        if (orgOrderBy != null) {
            sql.append(" order by ");
            sql.append(orgOrderBy);
        }
        return EcDao.find(ctx, OrganBean.class, sql.toString(), parentId);
    }

    public static OrganBean findOrgRoot(Context ctx) throws Exception {
        String sql = "select * from T_ORG_Admin where FParentID is null";
        return EcDao.findOne(ctx, OrganBean.class, sql, new Object[0]);
    }

    public static OrganBean findOrgById(Context ctx, String id) throws Exception {
        String sql = "select * from T_ORG_Admin where Fid = ?";
        return EcDao.findOne(ctx, OrganBean.class, sql, id);
    }

    public static byte[] findPersonImage(Context ctx, String personId) throws Exception {
        try {
            List<PersonphotoBean> personImage = EcDao.findPersonImage(ctx, new String[]{personId});
            if (personImage == null || personImage.size() == 0) {
                return null;
            }
            PersonphotoBean personphotoBean = personImage.get(0);
            if (personphotoBean == null) {
                return null;
            }
            return personphotoBean.getImageData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<PersonphotoBean> findPersonImage(Context ctx, String[] personId) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("select FPersonID, FImageData from t_hr_personphoto where FPersonID in (");
        for (int i = 0; i < personId.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])personId);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        while (rowSet.next()) {
            byte[] convertToBytes;
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(rowSet.getObject(1));
            if (rowSet.getBlob(2) == null || (convertToBytes = EcDao.convertToBytes(rowSet.getBlob(2).getBinaryStream())) == null) continue;
            a.add(convertToBytes);
            result.add(a.toArray());
        }
        if (result == null) {
            return null;
        }
        ArrayList<PersonphotoBean> list = new ArrayList<PersonphotoBean>();
        for (Object[] oo : result) {
            if (oo == null) continue;
            PersonphotoBean e = new PersonphotoBean();
            e.setPersonId(oo[0].toString());
            e.setImageData((byte[])oo[1]);
            list.add(e);
        }
        return list;
    }

    private static byte[] convertToBytes(InputStream in) {
        if (in == null) {
            return null;
        }
        byte[] block = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = -1;
        do {
            try {
                len = in.read(block);
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (len <= 0) continue;
            byteOut.write(block, 0, len);
        } while (len == 1024);
        return byteOut.toByteArray();
    }

    public static PersonRecordBean findPersonNamePositionAndAge(Context ctx, String personId) throws Exception {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT   \n");
        sql.append(" PERSON.FID AS ID,  \n");
        sql.append(" PERSON.FName_").append(l).append(" AS NAME , \n");
        sql.append(" DATEDIFF(DAY,PERSON.FBirthday,GETDATE())/365 AS AGE, \n");
        sql.append(" POSITION.FName_").append(l).append(" AS POSITION \n");
        sql.append(" FROM T_HR_PersonPosition AS PERSONPOSITION   \n");
        sql.append(" INNER JOIN T_BD_Person AS PERSON  \n");
        sql.append(" ON PERSONPOSITION.FPersonID = PERSON.FID  \n");
        sql.append(" INNER JOIN T_ORG_Position AS POSITION   \n");
        sql.append(" ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID  \n");
        sql.append("WHERE PERSON.FID = ?  \n");
        return EcDao.findOne(ctx, PersonRecordBean.class, sql.toString(), personId);
    }
}

