/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.common.team.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobileaccess.hr.common.team.util.LanguageUtil;
import com.kingdee.eas.mobileaccess.hr.common.team.util.PersonUtil;
import com.kingdee.eas.mobileaccess.hr.common.team.vo.OrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OrgUnitUtil {
    public static Collection<OrgUnitInfo> getSubOrgUnit(HttpServletRequest request, Context ctx, OrgUnitInfo orgUnitInfo) throws BOSException, SQLException, NoSuchAlgorithmException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("select \n");
        sb.append("org.fid as orgId, \n");
        sb.append("org.fname_").append(LanguageUtil.getType(ctx)).append(" as orgName, \n");
        sb.append("org.fDisplayName_").append(LanguageUtil.getType(ctx)).append(" as orgDisplayName, \n");
        sb.append("org.flongnumber as orgLongNumber \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" inner join t_org_admin parent on parent.fid = org.fparentid \n");
        sb.append(" where org.FIsSealUp = 0 and parent.flongnumber = ");
        sb.append("'");
        sb.append(orgUnitInfo.getLongNumber());
        sb.append("'");
        sb.append(" order by org.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        LinkedHashMap<String, OrgUnitInfo> map = new LinkedHashMap<String, OrgUnitInfo>();
        OrgUnitInfo info = null;
        while (rowSet.next()) {
            info = new OrgUnitInfo();
            info.setId(rowSet.getString("orgId"));
            info.setName(rowSet.getString("orgName"));
            info.setDisplayName(rowSet.getString("orgDisplayName"));
            info.setLongNumber(rowSet.getString("orgLongNumber"));
            map.put(info.getId(), info);
        }
        sb.delete(0, sb.length());
        sb.append("select \n");
        sb.append("org.fid as orgId, \n");
        sb.append("person.fid as personId, \n");
        sb.append("person.fname_").append(LanguageUtil.getType(ctx)).append(" as personName, \n");
        sb.append("person.femail as personEmail, \n");
        sb.append("position.fname_").append(LanguageUtil.getType(ctx)).append(" as positionName, \n");
        sb.append("photo.fimageData as personPhoto \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" inner join t_org_admin parent on parent.fid = org.fparentid \n");
        sb.append(" inner join t_org_position position on position.fadminOrgUnitid = org.fid \n");
        sb.append(" inner join t_org_PositionMember pm on pm.FPositionId = position.fid \n");
        sb.append(" inner join t_bd_person person on person.fid = pm.fpersonid \n");
        sb.append(" left outer join t_hr_PersonPhoto photo on photo.fpersonid = person.fid \n");
        sb.append(" where parent.flongnumber = ");
        sb.append("'");
        sb.append(orgUnitInfo.getLongNumber());
        sb.append("'");
        sb.append(" and position.FISRespPosition = 1 \n");
        sb.append(" and org.FIsSealUp = 0 \n");
        sb.append(" and pm.FisPrimary = 1 \n");
        sb.append(" order by org.flongnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Blob photo = null;
        while (rowSet.next()) {
            info = (OrgUnitInfo)map.get(rowSet.getString("orgId"));
            info.setPersonId(rowSet.getString("personId"));
            info.setPersonName(rowSet.getString("personName"));
            info.setMail(rowSet.getString("personEmail"));
            info.setPersonPosition(rowSet.getString("positionName"));
            photo = (Blob)rowSet.getObject("personPhoto");
            if (photo != null) {
                info.setPersonPhoto(PersonUtil.generatePhotoURL(request, photo.getBytes(1L, (int)photo.length())));
                continue;
            }
            info.setPersonPhoto(null);
        }
        return map.values();
    }

    public static OrgUnitInfo getOrgUnitAll(HttpServletRequest request, Context ctx, String longNumber) throws BOSException, SQLException, NoSuchAlgorithmException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("select \n");
        sb.append("org.fid as orgId, \n");
        sb.append("org.fname_").append(LanguageUtil.getType(ctx)).append(" as orgName, \n");
        sb.append("org.fDisplayName_").append(LanguageUtil.getType(ctx)).append(" as orgDisplayName, \n");
        sb.append("org.flongnumber as orgLongNumber \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" where org.FIsSealUp = 0 \n");
        sb.append(" and (org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" or org.flongnumber like ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("!%'");
        sb.append(") \n");
        sb.append(" order by org.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        LinkedHashMap<String, OrgUnitInfo> map = new LinkedHashMap<String, OrgUnitInfo>();
        OrgUnitInfo info = null;
        while (rowSet.next()) {
            info = new OrgUnitInfo();
            info.setId(rowSet.getString("orgId"));
            info.setName(rowSet.getString("orgName"));
            info.setDisplayName(rowSet.getString("orgDisplayName"));
            info.setLongNumber(rowSet.getString("orgLongNumber"));
            map.put(info.getLongNumber(), info);
        }
        sb.delete(0, sb.length());
        sb.append("select \n");
        sb.append("org.flongnumber as orgLongNumber, \n");
        sb.append("person.fid as personId, \n");
        sb.append("person.fname_").append(LanguageUtil.getType(ctx)).append(" as personName, \n");
        sb.append("person.femail as personEmail, \n");
        sb.append("position.fname_").append(LanguageUtil.getType(ctx)).append(" as positionName, \n");
        sb.append("photo.fimageData as personPhoto \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" inner join t_org_position position on position.fadminOrgUnitid = org.fid \n");
        sb.append(" inner join t_org_PositionMember pm on pm.FPositionId = position.fid \n");
        sb.append(" inner join t_bd_person person on person.fid = pm.fpersonid \n");
        sb.append(" left outer join t_hr_PersonPhoto photo on photo.fpersonid = person.fid \n");
        sb.append(" where (org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" or org.flongnumber like ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("!%'");
        sb.append(")");
        sb.append(" and position.FISRespPosition = 1 \n");
        sb.append(" and org.FIsSealUp = 0 \n");
        sb.append(" and pm.FisPrimary = 1 \n");
        sb.append(" order by org.flongnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Blob photo = null;
        while (rowSet.next()) {
            info = (OrgUnitInfo)map.get(rowSet.getString("orgLongNumber"));
            if (info == null) continue;
            info.setPersonId(rowSet.getString("personId"));
            info.setPersonName(rowSet.getString("personName"));
            info.setMail(rowSet.getString("personEmail"));
            info.setPersonPosition(rowSet.getString("positionName"));
            photo = (Blob)rowSet.getObject("personPhoto");
            if (photo != null) {
                info.setPersonPhoto(PersonUtil.generatePhotoURL(request, photo.getBytes(1L, (int)photo.length())));
                continue;
            }
            info.setPersonPhoto(null);
        }
        OrgUnitUtil.assembleOrgUnitRelation(map);
        OrgUnitInfo root = (OrgUnitInfo)map.get(longNumber);
        return root;
    }

    public static OrgUnitInfo getUnOrgUnitAll(HttpServletRequest request, Context ctx, String[] longNumbers) throws BOSException, SQLException, NoSuchAlgorithmException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("select \n");
        sb.append("org.fid as orgId, \n");
        sb.append("org.fname_").append(LanguageUtil.getType(ctx)).append(" as orgName, \n");
        sb.append("org.fDisplayName_").append(LanguageUtil.getType(ctx)).append(" as orgDisplayName, \n");
        sb.append("org.flongnumber as orgLongNumber \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" where org.FIsSealUp = 0 \n");
        sb.append(" and ");
        sb.append(OrgUnitUtil.assembleConditionStr("org.flongnumber", longNumbers));
        sb.append(" order by org.flongnumber");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        LinkedHashMap<String, OrgUnitInfo> map = new LinkedHashMap<String, OrgUnitInfo>();
        OrgUnitInfo info = null;
        while (rowSet.next()) {
            info = new OrgUnitInfo();
            info.setId(rowSet.getString("orgId"));
            info.setName(rowSet.getString("orgName"));
            info.setDisplayName(rowSet.getString("orgDisplayName"));
            info.setLongNumber(rowSet.getString("orgLongNumber"));
            map.put(info.getLongNumber(), info);
        }
        sb.delete(0, sb.length());
        sb.append("select \n");
        sb.append("org.flongnumber as orgLongNumber, \n");
        sb.append("person.fid as personId, \n");
        sb.append("person.fname_").append(LanguageUtil.getType(ctx)).append(" as personName, \n");
        sb.append("person.femail as personEmail, \n");
        sb.append("position.fname_").append(LanguageUtil.getType(ctx)).append(" as positionName, \n");
        sb.append("photo.fimageData as personPhoto \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" inner join t_org_position position on position.fadminOrgUnitid = org.fid \n");
        sb.append(" inner join t_org_PositionMember pm on pm.FPositionId = position.fid \n");
        sb.append(" inner join t_bd_person person on person.fid = pm.fpersonid \n");
        sb.append(" left outer join t_hr_PersonPhoto photo on photo.fpersonid = person.fid \n");
        sb.append(" where ");
        sb.append(OrgUnitUtil.assembleConditionStr("org.flongnumber", longNumbers));
        sb.append(" and position.FISRespPosition = 1 \n");
        sb.append(" and org.FIsSealUp = 0 \n");
        sb.append(" and pm.FisPrimary = 1 \n");
        sb.append(" order by org.flongnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Blob photo = null;
        while (rowSet.next()) {
            info = (OrgUnitInfo)map.get(rowSet.getString("orgLongNumber"));
            if (info == null) continue;
            info.setPersonId(rowSet.getString("personId"));
            info.setPersonName(rowSet.getString("personName"));
            info.setMail(rowSet.getString("personEmail"));
            info.setPersonPosition(rowSet.getString("positionName"));
            photo = (Blob)rowSet.getObject("personPhoto");
            if (photo != null) {
                info.setPersonPhoto(PersonUtil.generatePhotoURL(request, photo.getBytes(1L, (int)photo.length())));
                continue;
            }
            info.setPersonPhoto(null);
        }
        OrgUnitUtil.assembleOrgUnitRelation(map);
        String longNumber = longNumbers[0];
        int index = longNumber.indexOf("!");
        String rootLongNumber = index != -1 ? longNumber.substring(0, index) : longNumber;
        OrgUnitInfo root = (OrgUnitInfo)map.get(rootLongNumber);
        return root;
    }

    private static String assembleConditionStr(String column, String[] longNumbers) {
        StringBuffer sb = new StringBuffer();
        int length = longNumbers.length;
        for (int i = 0; i < length; ++i) {
            sb.append(column);
            sb.append(" <> ");
            sb.append("'");
            sb.append(longNumbers[i]);
            sb.append("'");
            sb.append(" and ");
            sb.append(column);
            sb.append(" not like ");
            sb.append("'");
            sb.append(longNumbers[i]);
            sb.append("!%'");
        }
        return sb.toString();
    }

    private static void assembleOrgUnitRelation(Map<String, OrgUnitInfo> map) {
        String parentLongNumber = null;
        OrgUnitInfo parent = null;
        for (OrgUnitInfo orgUnitInfo : map.values()) {
            if (orgUnitInfo.getLongNumber().lastIndexOf("!") == -1 || (parent = map.get(parentLongNumber = orgUnitInfo.getLongNumber().substring(0, orgUnitInfo.getLongNumber().lastIndexOf("!")))) == null) continue;
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList<OrgUnitInfo>());
            }
            parent.getChildren().add(orgUnitInfo);
        }
    }

    public static Map getOrgUnitRelateData(Context ctx, String longNumber) throws BOSException, SQLException {
        int count;
        StringBuffer sb = new StringBuffer();
        sb.append("select \n");
        sb.append("parent.fname_").append(LanguageUtil.getType(ctx)).append(" as parentName \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" inner join t_org_admin parent on parent.fid = org.fparentid \n");
        sb.append(" where org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (rowSet.next()) {
            map.put("parentOrgUnit", rowSet.getString("parentName"));
        }
        sb.delete(0, sb.length());
        sb.append("select count(*) from ( \n");
        sb.append(" select distinct p.fid from t_bd_person p \n");
        sb.append(" inner join t_org_PositionMember pm on pm.fpersonId = p.fid \n");
        sb.append(" inner join t_org_position position on position.fid = pm.fpositionid \n");
        sb.append(" inner join t_org_admin org on org.fid = position.FAdminOrgUnitid \n");
        sb.append(" where (org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" or org.flongnumber like ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("!%'");
        sb.append(") as t )");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int personCount = 0;
        if (rowSet.next()) {
            personCount = rowSet.getInt(1);
            map.put("personCount", personCount);
        }
        Calendar now = Calendar.getInstance();
        now.get(1);
        sb.delete(0, sb.length());
        sb.append("select p.FPlan");
        sb.append(now.get(2) + 1);
        sb.append(" from T_HR_PersonPlan p \n");
        sb.append(" inner join t_org_admin org on org.fid = p.FAdminOrgID \n");
        sb.append(" inner join T_HR_PersonPlanScheme s on s.fid = p.FSchemeID \n");
        sb.append(" where s.FStatus = 2 and org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" and  p.fyear = ");
        sb.append(now.get(1));
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rowSet.next() && (count = rowSet.getInt(1)) > 0) {
            int lackCount = count - personCount;
            map.put("lackCount", lackCount);
            BigDecimal percent = BigDecimal.valueOf(Math.abs(lackCount)).divide(BigDecimal.valueOf(count), 4, 4).multiply(new BigDecimal("100"));
            map.put("lackPercent", percent);
        }
        return map;
    }

    public static Map getOrgUnitDetailData(Context ctx, String longNumber) throws BOSException, SQLException {
        Map map = OrgUnitUtil.getOrgUnitRelateData(ctx, longNumber);
        StringBuffer sb = new StringBuffer();
        sb.append("select \n");
        sb.append("org.fdisplayName_").append(LanguageUtil.getType(ctx)).append(" as displayName \n");
        sb.append(" from t_org_admin org \n");
        sb.append(" where org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rowSet.next()) {
            String displayName = rowSet.getString("displayName");
            map.put("displayName", displayName.replace('_', '\\'));
        }
        sb.delete(0, sb.length());
        sb.append("select count(*) from ( \n");
        sb.append(" select distinct p.fid from t_bd_person p \n");
        sb.append(" inner join t_org_PositionMember pm on pm.fpersonId = p.fid \n");
        sb.append(" inner join t_org_position position on position.fid = pm.fpositionid \n");
        sb.append(" inner join t_org_admin org on org.fid = position.FAdminOrgUnitid \n");
        sb.append(" where org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" as t )");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int count = 0;
        if (rowSet.next()) {
            count = rowSet.getInt(1);
            map.put("orgPersonCount", count);
            map.put("subOrgPersonCount", (Integer)map.get("personCount") - count);
        }
        sb.delete(0, sb.length());
        sb.append("select count(*) from ( \n");
        sb.append(" select distinct p.fid from t_bd_person p \n");
        sb.append(" inner join t_org_PositionMember pm on pm.fpersonId = p.fid \n");
        sb.append(" inner join t_org_position position on position.fid = pm.fpositionid \n");
        sb.append(" inner join t_org_admin org on org.fid = position.FAdminOrgUnitid \n");
        sb.append(" inner join t_hr_personPosition pp on pp.fpersonid = p.fid \n");
        sb.append(" where pp.FIsImpt = 1 and (org.flongnumber = ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("'");
        sb.append(" or org.flongnumber like ");
        sb.append("'");
        sb.append(longNumber);
        sb.append("!%'");
        sb.append(") as t )");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rowSet.next()) {
            count = rowSet.getInt(1);
            map.put("keyPersonCount", count);
            int personCount = (Integer)map.get("personCount");
            if (personCount > 0) {
                BigDecimal percent = BigDecimal.valueOf(count).divide(BigDecimal.valueOf(personCount), 4, 4).multiply(new BigDecimal("100"));
                map.put("keyPersonPercent", percent);
            }
        }
        return map;
    }

    public static String getLongNumberById(Context ctx, String orgId) throws BOSException, SQLException, EASBizException {
        AdminOrgUnitInfo orgunit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        return orgunit.getLongNumber();
    }
}

