/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.dao;

import com.kingdee.eas.mobileaccess.hr.sHR.dao.DefaultTypeConvertor;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.EASConnectionProvider;
import com.kingdee.eas.mobileaccess.hr.sHR.dao.page.PageFactory;
import com.kingdee.eas.mobileaccess.hr.sHR.inf.ConnectionProvider;
import com.kingdee.eas.mobileaccess.hr.sHR.inf.IBean;
import com.kingdee.eas.mobileaccess.hr.sHR.inf.TypeConvertor;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CommonDao {
    private ConnectionProvider connectionProvider = new EASConnectionProvider();
    private TypeConvertor typeConvertor = new DefaultTypeConvertor();

    protected final String formatPageSQL(String sql, int offset, int limit) {
        if (offset < 0) {
            offset = 0;
        }
        if (limit < 0) {
            limit = 0;
        }
        if (offset == 0 && limit == 0) {
            return sql;
        }
        if (offset > 0 && limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        return PageFactory.getPage(this).synthesisPage(sql, offset, limit);
    }

    public Connection getConnection() throws Exception {
        Connection connection = this.connectionProvider.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get database connection");
        }
        return connection;
    }

    public void cleanConnection(Connection conn) throws Exception {
        if (conn != null) {
            conn.close();
        }
    }

    public <T extends IBean> T querySingleBean(String sql, Class<T> clazz) throws Exception {
        return this.querySingleBean(sql, new Object[0], clazz);
    }

    public <T extends IBean> T querySingleBean(String sql, Object[] params, Class<T> clazz) throws Exception {
        List<T> beans = this.queryBeans(sql, params, clazz);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        return (T)((IBean)beans.get(0));
    }

    public <T extends IBean> T querySingleBean(String sql, Class<T> clazz, Object[] params) throws Exception {
        if (params == null) {
            return this.querySingleBean(sql, null, clazz);
        }
        return this.querySingleBean(sql, params, clazz);
    }

    public <T extends IBean> List<T> queryBeans(String sql, Class<T> clazz, int offset, int limit) throws Exception {
        return this.queryBeans(sql, null, clazz, offset, limit);
    }

    public <T extends IBean> List<T> queryBeans(String sql, Class<T> clazz) throws Exception {
        return this.queryBeans(sql, new Object[0], clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IBean> List<T> queryBeans(String sql, Object[] params, Class<T> clazz, int offset, int limit) throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<IBean> result = null;
        String pageSQL = this.formatPageSQL(sql, offset, limit);
        try {
            ps = conn.prepareStatement(pageSQL);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData RSMD = rs.getMetaData();
            int colCount = RSMD.getColumnCount();
            result = new LinkedList<IBean>();
            Method[] methods = clazz.getMethods();
            while (rs.next()) {
                IBean bean = (IBean)clazz.newInstance();
                for (int i = 1; i <= colCount; ++i) {
                    Class<?>[] arguments;
                    String name;
                    Method method;
                    Object value = rs.getObject(i);
                    if (value == null || (method = this.getMethod("set", methods, name = RSMD.getColumnName(i))) == null || (arguments = method.getParameterTypes()).length != 1) continue;
                    Object convertedValue = this.typeConvertor.convert(arguments[0], value);
                    method.invoke((Object)bean, convertedValue);
                }
                result.add(bean);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            this.cleanConnection(conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        this.cleanConnection(conn);
        return result;
    }

    protected Method getMethod(String methodPrefix, Method[] all, String colname) {
        for (Method method : all) {
            String name = method.getName();
            if (!name.startsWith(methodPrefix) || !(name = name.substring(methodPrefix.length())).equalsIgnoreCase(colname)) continue;
            return method;
        }
        return null;
    }

    public <T extends IBean> List<T> queryBeans(String sql, Object[] params, Class<T> clazz) throws Exception {
        return this.queryBeans(sql, params, clazz, 0, 0);
    }

    public <T extends IBean> List<T> queryBeans(String sql, Class<T> clazz, Object[] params) throws Exception {
        return this.queryBeans(sql, params, clazz, 0, 0);
    }

    public <T extends IBean> List<T> queryBeans(String sql, Class<T> clazz, int offset, int limit, Object[] params) throws Exception {
        return this.queryBeans(sql, params, clazz, 0, 0);
    }

    public List<Map<String, Object>> query(String sql) throws Exception {
        return this.query(sql, new Object[0], null);
    }

    public List<Map<String, Object>> query(String sql, int from, int pageSize) throws Exception {
        String pageSQL = this.formatPageSQL(sql, from, pageSize);
        return this.query(pageSQL, new Object[0], null);
    }

    public List<Map<String, Object>> query(String sql, String[] colnameDefines) throws Exception {
        return this.query(sql, new Object[0], colnameDefines);
    }

    public List<Map<String, Object>> query(String sql, String[] colnameDefines, int from, int pageSize) throws Exception {
        String pageSQL = this.formatPageSQL(sql, from, pageSize);
        return this.query(pageSQL, new Object[0], colnameDefines);
    }

    public List<Map<String, Object>> query(String sql, Object[] params) throws Exception {
        return this.query(sql, params, null);
    }

    public List<Map<String, Object>> query(String sql, Object[] params, int from, int pageSize) throws Exception {
        String pageSQL = this.formatPageSQL(sql, from, pageSize);
        return this.query(pageSQL, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> query(String sql, Object[] params, String[] colnameDefines) throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Map<String, Object>> result = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            ResultSetMetaData RSMD = rs.getMetaData();
            int colCount = RSMD.getColumnCount();
            result = new LinkedList<Map<String, Object>>();
            while (rs.next()) {
                HashMap<String, Object> bean = new HashMap<String, Object>();
                for (int i = 1; i <= colCount; ++i) {
                    Object value = rs.getObject(i);
                    String name = RSMD.getColumnName(i);
                    if (colnameDefines != null) {
                        for (String dcolname : colnameDefines) {
                            if (!dcolname.equalsIgnoreCase(name)) continue;
                            name = dcolname;
                            break;
                        }
                    } else {
                        name = name.toUpperCase();
                    }
                    bean.put(name, value);
                }
                result.add(bean);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            this.cleanConnection(conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        this.cleanConnection(conn);
        return result;
    }

    public List<Map<String, Object>> query(String sql, Object[] params, String[] colnameDefines, int from, int pageSize) throws Exception {
        String pageSQL = this.formatPageSQL(sql, from, pageSize);
        return this.query(pageSQL, params, colnameDefines);
    }

    public <T extends IBean> int countBeans(String sql, Object[] params, Class<T> clazz) throws Exception {
        List<T> result = this.queryBeans(sql, params, clazz);
        return result == null ? -1 : result.size();
    }

    public int queryIntegerValue(String sql, Object[] params) throws Exception {
        List<Map<String, Object>> result = this.query(sql, params, null);
        if (result == null || result.isEmpty()) {
            return -1;
        }
        Map<String, Object> data = result.get(0);
        Object[] ret = data.values().toArray();
        if (ret.length == 0 || ret[0] == null) {
            return -1;
        }
        return ((Number)ret[0]).intValue();
    }

    public int queryIntegerValue(String sql) throws Exception {
        return this.queryIntegerValue(sql, new Object[0]);
    }

    public int count(String sql) throws Exception {
        return this.queryIntegerValue(sql, new Object[0]);
    }

    public int count(String sql, Object[] params) throws Exception {
        return this.queryIntegerValue(sql, params);
    }

    public int execute(String sql) throws Exception {
        return this.execute(sql, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object[] params) throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
            this.cleanConnection(conn);
        }
    }

    public int delete(String tableName, String conditions, Object[] params) throws Exception {
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(tableName);
        sql.append(" WHERE ");
        sql.append(conditions);
        return this.execute(sql.toString(), params);
    }

    public <T extends IBean> int createBean(T bean, String tableName) throws Exception {
        Field[] fields;
        Class<?> clazz = bean.getClass();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            String name = f.getName();
            Method method = clazz.getMethod("get" + StringUtils.capitalize((String)name), new Class[0]);
            if (method == null) continue;
            data.put(f.getName(), method.invoke(bean, new Object[0]));
        }
        StringBuffer sql = new StringBuffer("INSERT INTO " + tableName + data.keySet().toString().replace("[", "(").replace("]", ")") + " VALUES(");
        LinkedList entrys = new LinkedList(data.entrySet());
        int size = ((List)entrys).size();
        Object[] params = new Object[size];
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)((List)entrys).get(i);
            sql.append("?");
            if (i != size - 1) {
                sql.append(",");
            }
            params[i] = entry.getValue();
        }
        sql.append(")");
        return this.execute(sql.toString(), params);
    }

    public <T extends IBean> int createBean(T bean) throws Exception {
        return this.createBean(bean, bean.getClass().getSimpleName());
    }

    public <T extends IBean> int updateBean(T bean, String idcol, String tableName) throws Exception {
        Class<?> clazz = bean.getClass();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Field[] fields = clazz.getDeclaredFields();
        Object idvalue = "";
        for (Field f : fields) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            String name = f.getName();
            Method method = clazz.getMethod("get" + StringUtils.capitalize((String)name), new Class[0]);
            if (method == null) continue;
            Object value = method.invoke(bean, new Object[0]);
            data.put(f.getName() + "=?", value);
            if (!name.equals(idcol)) continue;
            idvalue = value;
        }
        String sql = "UPDATE " + tableName + " SET " + data.keySet().toString().replace("[", "").replace("]", "") + " WHERE " + idcol + "='" + idvalue + "'";
        return this.execute(sql.toString(), data.values().toArray());
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public TypeConvertor getTypeConvertor() {
        return this.typeConvertor;
    }

    public void setTypeConvertor(TypeConvertor typeConvertor) {
        this.typeConvertor = typeConvertor;
    }

    protected void printRS(ResultSet rs) throws Exception {
        rs.getMetaData();
        ResultSetMetaData RSMD = rs.getMetaData();
        int colCount = RSMD.getColumnCount();
        while (rs.next()) {
            for (int i = 1; i <= colCount; ++i) {
                Object value = rs.getObject(i);
                System.out.println(value);
            }
        }
    }
}

