/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobileaccess.hr.sHR.dao;

import com.kingdee.eas.mobileaccess.hr.sHR.inf.TypeConvertor;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DefaultTypeConvertor
implements TypeConvertor {
    private Logger logger = Logger.getLogger(DefaultTypeConvertor.class);

    public static Object convertNumber(Class desiredType, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(value + " can not be convert to number!");
        }
        Number v = (Number)value;
        if (desiredType.equals(Integer.class)) {
            return new Integer(v.intValue());
        }
        if (desiredType.equals(Long.class)) {
            return new Long(v.longValue());
        }
        if (desiredType.equals(Float.class)) {
            return new Float(v.floatValue());
        }
        if (desiredType.equals(Double.class)) {
            return new Double(v.doubleValue());
        }
        if (desiredType.equals(Byte.class)) {
            return new Byte(v.byteValue());
        }
        if (desiredType.equals(Short.class)) {
            return new Short(v.shortValue());
        }
        if (desiredType.equals(BigDecimal.class)) {
            return new BigDecimal(v.doubleValue());
        }
        return value;
    }

    public static Object convertDate(Class desiredType, Object value) {
        Date date = (Date)value;
        if (desiredType.equals(Timestamp.class)) {
            return new Timestamp(date.getTime());
        }
        return date;
    }

    @Override
    public Object convert(Class desiredType, Object value) {
        if (desiredType.isInstance(value)) {
            return value;
        }
        if (value instanceof Date) {
            return DefaultTypeConvertor.convertDate(desiredType, value);
        }
        if (value instanceof Number) {
            this.logger.warn((Object)("Type mismatched,Convert datatype from " + value.getClass() + " to " + desiredType));
            return DefaultTypeConvertor.convertNumber(desiredType, value);
        }
        return value;
    }
}

