/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.filter;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.shr.base.syssetting.context.ContextFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SHRContextFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SHRContextFilter.class);
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (((HttpServletRequest)servletRequest).getSession() == null) {
            logger.error((Object)("servletRequest:" + SHRCheck.vaildLog((String)servletRequest.toString()) + "---session is null"));
            return;
        }
        SHRContext context = null;
        try {
            context = ContextFactory.getContext(this.servletContext, servletRequest, servletResponse);
            if (context != null) {
                ConfigMDUtil.setContextToThread((Context)context.getContext());
            }
            if (context == null) {
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            SHRContext.setInstance(null);
        }
    }

    public void destroy() {
    }
}

