/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.interceptor;

import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class InterceptorHelper {
    private static Logger logger = Logger.getLogger(InterceptorHelper.class);
    private static final Set<String> METHOD_AND_HANDLER_SET = new HashSet<String>();
    private static final Set<String> URI_SET = new HashSet<String>();
    private static final Set<String> METHOD_SET = new HashSet<String>();
    private static final Set<String> METHOD_AND_SERVLETPATH_SET = new HashSet<String>();

    private InterceptorHelper() {
    }

    public static boolean isIgnoredValidateRequest(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        if (!StringUtils.isEmpty((String)referer) && referer.indexOf("shr/uiview_config.do?") != -1) {
            return true;
        }
        boolean isIgnoreURI = InterceptorHelper.isIgnoreURI(request);
        boolean isIgnoreMethod = InterceptorHelper.isIgnoreMethod(request);
        boolean isIgnoreHandlerAndMethod = InterceptorHelper.isIgnoreHandlerAndMethod(request);
        boolean isIgnoreURIAndMethod = InterceptorHelper.isIgnoreURIAndMethod(request);
        return isIgnoreURI || isIgnoreMethod || isIgnoreHandlerAndMethod || isIgnoreURIAndMethod;
    }

    private static boolean isIgnoreURIAndMethod(HttpServletRequest request) {
        String method = request.getParameter("method");
        String servletPath = request.getServletPath();
        String url = MessageFormat.format("{0}#{1}", servletPath, method);
        return METHOD_AND_SERVLETPATH_SET.contains(url);
    }

    private static boolean isIgnoreHandlerAndMethod(HttpServletRequest request) {
        String method = request.getParameter("method");
        String handler = request.getParameter("handler");
        if (!StringUtils.isEmpty((String)method) && !StringUtils.isEmpty((String)handler)) {
            String key = MessageFormat.format("{0}#{1}", method, handler);
            for (String keyTemp : METHOD_AND_HANDLER_SET) {
                if (!keyTemp.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIgnoreMethod(HttpServletRequest request) {
        boolean flag = false;
        String method = request.getParameter("method");
        String uipk = request.getParameter("uipk");
        if (!StringUtils.isEmpty((String)method) && !StringUtils.isEmpty((String)uipk)) {
            for (String method0 : METHOD_SET) {
                if (!method.equals(method0)) continue;
                logger.debug((Object)MessageFormat.format("isIgnoreMethod ,uipk:{0},method:{1}", uipk, method));
                flag = true;
                break;
            }
        }
        return flag;
    }

    private static boolean isIgnoreURI(HttpServletRequest request) {
        String uri = request.getRequestURI();
        boolean flag = false;
        if (StringUtils.isEmpty((String)uri)) {
            return flag;
        }
        for (String uri0 : URI_SET) {
            if (uri.indexOf(uri0) <= -1) continue;
            flag = true;
            logger.debug((Object)MessageFormat.format("isIgnoreURI ,uri:{0},method:{1}", uri));
            break;
        }
        return flag;
    }

    static {
        METHOD_AND_HANDLER_SET.add("getPersonalNationPlanInfo#com.kingdee.shr.base.syssetting.web.handler.PersonalNantionalPlanEditHandler");
        METHOD_AND_HANDLER_SET.add("getNationPlanById#com.kingdee.shr.base.syssetting.web.handler.PersonalNantionalPlanEditHandler");
        METHOD_AND_HANDLER_SET.add("savePersonalNationPlan#com.kingdee.shr.base.syssetting.web.handler.PersonalNantionalPlanEditHandler");
        METHOD_AND_HANDLER_SET.add("getUIViewInfo#com.kingdee.shr.base.syssetting.web.handler.UIViewListHandler");
        METHOD_AND_HANDLER_SET.add("getSysVersion#com.kingdee.shr.base.syssetting.web.handler.SysPatchToolsHandler");
        METHOD_AND_HANDLER_SET.add("downloadTemplateModel#com.kingdee.shr.certificationservice.web.handler.CommonCertificationTempletEditHandler");
        METHOD_AND_HANDLER_SET.add("downloadTemplateModel#com.kingdee.shr.econtractservice.web.handler.EmpContractTempletEditHandler");
        METHOD_AND_HANDLER_SET.add("downLoadLog#com.kingdee.shr.base.syssetting.web.handler.LogJarClassInfoToolsHandler");
        METHOD_AND_HANDLER_SET.add("check#com.kingdee.shr.base.syssetting.web.handler.ShrLoseCheckToolsHandler");
        METHOD_AND_HANDLER_SET.add("getWaterMark#com.kingdee.shr.base.syssetting.web.handler.GlobalWaterMarkHandler");
        URI_SET.add("/heartbeat.do");
        URI_SET.add("/shr/msf/service.do");
        URI_SET.add("/tags.do");
        URI_SET.add("/shr/home.do");
        URI_SET.add("/shr/main.do");
        METHOD_SET.add("destroy");
        METHOD_AND_SERVLETPATH_SET.add("/appOperate.do#downloadServerJar");
    }
}

