/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.button;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.permission.api.service.SHRDataPermissionModel;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.permission.button.PageConfigParamManager;
import com.kingdee.shr.base.syssetting.web.dynamic.model.PageConfigParam;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ClientCheckModeBuilder {
    private static final String DATA_PERM_KEY = "dataPerm";
    private static final String DATA_PERM_ADMINORG_KEY = "orgId";
    private static final String DATA_PERM_HRORG_KEY = "hrOrgId";
    private static final String DATA_PERM_DEFAULTMANAGE_KEY = "isDefaultManage";
    private static final String DATA_PERM_DEFAULTMANAGE_VALUE_TRUE = "1";
    private static final String DATA_PERM_DEFAULTMANAGE_VALUE_FALSE = "0";

    public static List<SHRDataPermissionModel> build(Context ctx, PageConfigParam pcp, HttpServletRequest request) throws SHRWebException {
        return ClientCheckModeBuilder.assembleSHRDataPermissionModel(ctx, pcp, request);
    }

    public static List<SHRDataPermissionModel> assembleSHRDataPermissionModel(Context ctx, PageConfigParam pcp, HttpServletRequest request) throws SHRWebException {
        String dataPermModelJson = request.getParameter(DATA_PERM_KEY);
        List reqDataPermListModel = (List)JSONUtils.convertJsonToObject(ctx, dataPermModelJson, List.class);
        String checkRule = PageConfigParamManager.getCheckRuleFieldName(pcp);
        return ClientCheckModeBuilder.convertToListModel(reqDataPermListModel, checkRule);
    }

    private static List<SHRDataPermissionModel> convertToListModel(List reqDataPermListModel, String checkRule) {
        ArrayList<SHRDataPermissionModel> dataPermListModel = new ArrayList<SHRDataPermissionModel>();
        if (null == reqDataPermListModel) {
            return dataPermListModel;
        }
        int size = reqDataPermListModel.size();
        for (int i = 0; i < size; ++i) {
            Object obj = reqDataPermListModel.get(i);
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            SHRDataPermissionModel model = new SHRDataPermissionModel();
            String orgIdValueStr = String.valueOf(map.get(DATA_PERM_ADMINORG_KEY));
            Set<String> orgIdSet = PageConfigParamManager.convertStrToSet(orgIdValueStr);
            model.setOrgId(orgIdSet);
            String hrOrgIdValueStr = String.valueOf(map.get(DATA_PERM_HRORG_KEY));
            Set<String> hrOrgIdSet = PageConfigParamManager.convertStrToSet(hrOrgIdValueStr);
            model.setHrOrgId(hrOrgIdSet);
            String isDefaultManage = String.valueOf(map.get(DATA_PERM_DEFAULTMANAGE_KEY));
            model.setDefaultManage(ClientCheckModeBuilder.convertDefaultManageStrToBoolean(isDefaultManage));
            model.setCheckRule(checkRule);
            dataPermListModel.add(model);
        }
        return dataPermListModel;
    }

    private static boolean convertDefaultManageStrToBoolean(String isDefaultManage) {
        boolean flag = false;
        if (StringUtils.isEmpty((String)isDefaultManage)) {
            return flag;
        }
        if (DATA_PERM_DEFAULTMANAGE_VALUE_TRUE.equals(isDefaultManage) || "true".equalsIgnoreCase(isDefaultManage)) {
            flag = true;
        }
        if (DATA_PERM_DEFAULTMANAGE_VALUE_FALSE.equals(isDefaultManage) || "false".equalsIgnoreCase(isDefaultManage)) {
            flag = false;
        }
        return flag;
    }
}

