/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.data.IShrCheckDataPermissionService;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class AbstractShrCheckDataPermissionService
implements IShrCheckDataPermissionService {
    private static Logger logger = Logger.getLogger(AbstractShrCheckDataPermissionService.class);

    @Override
    public String getPermItemId(HttpServletRequest request) {
        return (String)request.getAttribute("permItemId");
    }

    @Override
    public String getShruicode(HttpServletRequest request) {
        return (String)request.getAttribute("shruicode");
    }

    @Override
    public String getBillId(HttpServletRequest request) {
        return request.getParameter("billId");
    }

    protected final Object getValue(Object model, String key) {
        Object result = null;
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (model instanceof IObjectValue) {
            String[] keys;
            IObjectValue obj = (IObjectValue)model;
            if (key.indexOf(".") == -1) {
                return obj.get(key);
            }
            IObjectValue tempCoreBase = obj;
            IObjectCollection tempObjectCollection = null;
            for (String k : keys = key.split("\\.")) {
                if (tempCoreBase == null) {
                    return null;
                }
                result = tempCoreBase.get(k);
                if (null == result) {
                    return null;
                }
                if (result instanceof IObjectValue) {
                    tempCoreBase = (CoreBaseInfo)result;
                    continue;
                }
                if (!(result instanceof IObjectCollection)) break;
                tempObjectCollection = (IObjectCollection)result;
                tempCoreBase = tempObjectCollection.getObject(0);
            }
            return result;
        }
        if (!(model instanceof IObjectCollection) && model instanceof Map) {
            Map vm = (Map)model;
            return vm.get(key);
        }
        return null;
    }

    protected final String getAdminOrgUnitId(Object model, String key) {
        Object obj = this.getValue(model, key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof AdminOrgUnitInfo) {
            return ((AdminOrgUnitInfo)obj).getId().toString();
        }
        if (obj instanceof BOSUuid) {
            return ((BOSUuid)obj).toString();
        }
        return null;
    }

    protected final String getHROrgUnitId(Object model, String key) {
        Object obj = this.getValue(model, key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof HROrgUnitInfo) {
            return ((HROrgUnitInfo)obj).getId().toString();
        }
        if (obj instanceof BOSUuid) {
            return ((BOSUuid)obj).toString();
        }
        return null;
    }

    protected final String getPersonId(Object model, String key) {
        Object obj = this.getValue(model, key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof PersonInfo) {
            return ((PersonInfo)obj).getId().toString();
        }
        if (obj instanceof BOSUuid) {
            return ((BOSUuid)obj).toString();
        }
        return null;
    }

    protected final boolean getIsInnerPerson(Object model, String key) {
        Object isInnerPerson0 = this.getValue(model, key);
        boolean isInner = false;
        isInner = isInnerPerson0 instanceof Boolean ? (Boolean)isInnerPerson0 : Boolean.parseBoolean(String.valueOf(isInnerPerson0));
        return isInner;
    }

    protected final void checkHROrgUnitDataPermission(Context ctx, String permItemId, String hrOrgUnitId) throws SHRWebException {
        try {
            Set<String> hrSets = this.getHROrgRangeIdSet(ctx, permItemId);
            if (null == hrSets || hrSets.isEmpty()) {
                logger.error((Object)"checkHROrgUnitDataPermission getHROrgRangeIdSet is empty ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            if (!hrSets.contains(hrOrgUnitId)) {
                logger.error((Object)("checkHROrgUnitDataPermission getHROrgRangeIdSet not contains hrOrgUnitId :" + SHRCheck.vaildLog((String)hrOrgUnitId)));
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkAdminOrgUnitDataPermission(Context ctx, String permItemId, String adminId) throws SHRWebException {
        try {
            Set<String> adminSets = this.getAdminOrgRangeIdSet(ctx, permItemId);
            if (null == adminSets || adminSets.isEmpty()) {
                logger.error((Object)"checkAdminOrgUnitDataPermission getAdminOrgRangeIdSet is empty ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            if (!adminSets.contains(adminId)) {
                logger.error((Object)("checkAdminOrgUnitDataPermission getHROrgRangeIdSet not contains adminId :" + SHRCheck.vaildLog((String)adminId)));
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrBuAndEntrust(Context ctx, String permItemId, String adminOrgId, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getHROrgRangeIdSet(ctx, permItemId);
            Set<String> adminSets = this.getAdminOrgRangeIdSet(ctx, permItemId);
            boolean buAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && adminSets.contains(adminOrgId)) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrOuAndEntrustOrBuAndEntrust(Context ctx, String permItemId, String adminOrgId, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getHROrgRangeIdSet(ctx, permItemId);
            Set<String> adminSets = this.getAdminOrgRangeIdSet(ctx, permItemId);
            boolean buAndEntrust = false;
            boolean ouAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != adminSets && !adminSets.isEmpty() && adminSets.contains(adminOrgId) && !isInnerPerson) {
                ouAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && adminSets.contains(adminOrgId)) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu || ouAndEntrust) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final void checkOUAndBUOrBuAndEntrust(Context ctx, String permItemId, String adminOrgId, String adminOrgId2, String hrOrgUnitId, boolean isInnerPerson) throws SHRWebException {
        try {
            if (StringUtils.isEmpty((String)hrOrgUnitId) || StringUtils.isEmpty((String)adminOrgId)) {
                logger.error((Object)"checkOUAndBUOrBuAndEntrust hrOrgUnitId is null or adminOrgId is null ");
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            Set<String> hrSets = this.getHROrgRangeIdSet(ctx, permItemId);
            Set<String> adminSets = this.getAdminOrgRangeIdSet(ctx, permItemId);
            boolean buAndEntrust = false;
            boolean buAndOu = false;
            if (null != hrSets && !hrSets.isEmpty() && hrSets.contains(hrOrgUnitId) && !isInnerPerson) {
                buAndEntrust = true;
            }
            if (null != hrSets && !hrSets.isEmpty() && null != adminSets && !adminSets.isEmpty() && hrSets.contains(hrOrgUnitId) && (adminSets.contains(adminOrgId) || adminSets.contains(adminOrgId2))) {
                buAndOu = true;
            }
            if (buAndEntrust || buAndOu) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected final Set<String> getAdminOrgRangeIdSet(Context ctx, String perItemId) throws SHRWebException {
        this.checkPermItemIsNull(ctx, perItemId);
        return SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)perItemId);
    }

    protected final String getAdminOrgRangeSQL(Context ctx, String perItemId) throws SHRWebException {
        this.checkPermItemIsNull(ctx, perItemId);
        return SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)perItemId);
    }

    protected final void addAdminOrgRange(Context ctx, String perItemId, FilterInfo filter, String ou) throws SHRWebException {
        SHRUserOrgPermissionApi.addUserAdminRangeFilter((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)perItemId, (FilterInfo)filter, (String)ou);
    }

    protected final void addHROrgRange(Context ctx, String perItemId, FilterInfo filter, String bu) throws SHRWebException {
        filter.getFilterItems().add(new FilterItemInfo(bu, this.getHROrgRangeIdSet(ctx, perItemId), CompareType.INCLUDE));
    }

    protected final Set<String> getHROrgRangeIdSet(Context ctx, String perItemId) throws SHRWebException {
        this.checkPermItemIsNull(ctx, perItemId);
        return SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)perItemId);
    }

    protected final void checkPermItemIsNull(Context ctx, String perItemId) throws SHRWebException {
        if (StringUtils.isEmpty((String)perItemId)) {
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"permitemid_not_null", (Context)ctx));
        }
    }

    protected final String getPersonId(Context ctx) {
        return HRFilterUtils.getCurrentPersonId((Context)ctx);
    }
}

