/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.resourcemanager;

import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IWebController;
import com.kingdee.shr.base.syssetting.core.IWebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResourceManager {
    private static Logger logger = Logger.getLogger(ResourceManager.class);
    private Map resourceCache = new HashMap();

    public List getControllerLocalKeys(IWebController controller, Locale locale) throws SHRWebException {
        Map resMap = this.getControllerLocalResFromCache(controller, locale);
        Set keySet = resMap.keySet();
        return Arrays.asList(keySet.toArray());
    }

    public String getControllerMessage(IWebController controller, String message, Locale locale) throws SHRWebException {
        Map resMap = this.getControllerLocalResFromCache(controller, locale);
        if (resMap.containsKey(message)) {
            return (String)resMap.get(message);
        }
        return null;
    }

    public Map buildControllerLocalResToCache(IWebController controller, Locale locale) throws SHRWebException {
        String categoryKey;
        if (controller == null) {
            return null;
        }
        if (this.resourceCache == null) {
            this.resourceCache = new HashMap();
        }
        if (this.resourceCache.containsKey(categoryKey = controller.getClass().getName() + "_" + SHRContext.getInstance().getContext().getLocale().toString())) {
            this.resourceCache.remove(categoryKey);
        }
        HashMap<String, String> localMap = new HashMap<String, String>();
        List<Object> keyList = this.getBundleLocalKeys(controller.getClass().getName(), locale);
        for (int nIndex = 0; keyList != null && nIndex < keyList.size(); ++nIndex) {
            String key = (String)keyList.get(nIndex);
            String value = this.getBundleMessage(controller.getClass().getName(), key, locale);
            localMap.put(key, value);
        }
        Map dbLocalMap = this.getControllerLocalResFromDB(controller, SHRContext.getInstance().getContext().getOriginLocale());
        keyList = Arrays.asList(dbLocalMap.keySet().toArray());
        for (int nIndex = 0; keyList != null && nIndex < keyList.size(); ++nIndex) {
            String key = (String)keyList.get(nIndex);
            String value = controller.getMessage(key);
            localMap.put(key, value);
        }
        this.resourceCache.put(categoryKey, localMap);
        return localMap;
    }

    private ResourceBundle getResourceBundle(String className, Locale locale) throws SHRWebException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(className, locale);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return resourceBundle;
    }

    private List getBundleLocalKeys(String className, Locale locale) throws SHRWebException {
        ArrayList<String> keyList = new ArrayList<String>();
        try {
            String res = "";
            for (Class<?> clz = Class.forName(className); clz != null; clz = clz.getSuperclass()) {
                ResourceBundle resBundle = this.getResourceBundle(className, locale);
                if (resBundle == null) continue;
                Enumeration<String> keyEnumeration = resBundle.getKeys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = keyEnumeration.nextElement();
                    keyList.add(key);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return keyList;
    }

    private String getBundleMessage(String className, String key, Locale locale) throws SHRWebException {
        try {
            String res = "";
            for (Class<?> clz = Class.forName(className); clz != null; clz = clz.getSuperclass()) {
                ResourceBundle resBundle = this.getResourceBundle(className, locale);
                if (resBundle == null) continue;
                try {
                    res = resBundle.getString(key);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return res;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Map getControllerLocalResFromCache(IWebController controller, Locale locale) throws SHRWebException {
        if (controller == null) {
            return null;
        }
        String categoryKey = controller.getClass().getName() + "_" + SHRContext.getInstance().getContext().getLocale().toString();
        if (this.resourceCache.containsKey(categoryKey)) {
            return (Map)this.resourceCache.get(categoryKey);
        }
        return this.buildControllerLocalResToCache(controller, locale);
    }

    public Map getControllerLocalResFromDB(IWebController controller, Locale locale) throws SHRWebException {
        HashMap resMap = new HashMap();
        if (controller == null) {
            return resMap;
        }
        try {
            String res = "";
            for (Class<?> clz = controller.getClass(); clz != null; clz = clz.getSuperclass()) {
                String packageAndName = clz.getName();
                packageAndName = packageAndName.substring(0, packageAndName.lastIndexOf("Controller"));
                packageAndName = packageAndName.replaceAll("\\.", "\\\\");
                int index = packageAndName.lastIndexOf("\\");
                Map levelResMap = ResourceListenerManager.getRemoteWebResource((String)packageAndName.substring(0, index), (String)packageAndName.substring(index + 1), (Locale)locale);
                resMap.putAll(levelResMap);
            }
            return resMap;
        }
        catch (Exception exception) {
            return resMap;
        }
    }

    public StringBuffer buildJSLocalRes(IWebController controller, Locale locale) throws SHRWebException {
        StringBuffer buffer = new StringBuffer();
        if (controller == null && controller instanceof IWebPageController) {
            return buffer;
        }
        if (controller != null) {
            List localKeys = this.getBundleLocalKeys(controller.getClass().getName(), locale);
            for (int nIndex = 0; nIndex < localKeys.size(); ++nIndex) {
                String key = (String)localKeys.get(nIndex);
                String message = this.getBundleMessage(controller.getClass().getName(), key, locale);
                key = key.replace(".", "_");
                buffer.append("_self.localeStr." + key + "=\"" + message + "\";");
                buffer.append("\n\t\t\t");
            }
        }
        return buffer;
    }

    public StringBuffer getDynamicWebJSLocalRes(String resPackage, String resFileName, Locale locale) throws SHRWebException {
        StringBuffer buffer = new StringBuffer();
        Map resMap = null;
        int index = resPackage.lastIndexOf(".");
        resMap = ResourceListenerManager.getRemoteWebPageResource((String)resPackage.substring(0, index).replace(".", "\\"), (String)resFileName, (Locale)locale);
        if (resMap == null) {
            return buffer;
        }
        for (String key : resMap.keySet()) {
            String message = (String)resMap.get(key);
            key = key.replace(".", "_");
            buffer.append("_self.localeStr." + key + "=\"" + message + "\";");
            buffer.append("\n\t\t\t");
        }
        return buffer;
    }
}

