/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class HROrgUnitUtil {
    private static Logger logger = Logger.getLogger(HROrgUnitUtil.class);

    public static boolean isHROrgUnitF7(HttpServletRequest request) {
        return "com.kingdee.eas.basedata.org.app.HROrgUnit.F7".equals(request.getParameter("uipk"));
    }

    public static List<Map<String, Object>> getHROrgUnits(String filterSql, boolean isSealUp) throws BOSException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Context ctx = SHRContext.getInstance().getContext();
        StringBuffer sb = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sb.append("select fid, fnumber, fname_").append(l).append(", fissealup from t_org_hro where  fid in (").append(filterSql).append(")");
        if (!isSealUp) {
            sb.append(" and fissealup = 0");
        }
        sb.append(" order by fissealup,FNUMBER asc");
        String seal = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"sealed_up", (Context)ctx);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("fid"));
                if (isSealUp && rs.getBoolean("fissealup")) {
                    map.put("name", rs.getString("fname_" + l) + "(" + seal + ")");
                } else {
                    map.put("name", rs.getString("fname_" + l));
                }
                map.put("value", rs.getString("fnumber"));
                result.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static List<Map<String, Object>> getHROrgUnits(EntityViewInfo viewInfo) throws BOSException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HROrgUnitCollection coll = HROrgUnitFactory.getRemoteInstance().getHROrgUnitCollection(viewInfo);
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                HROrgUnitInfo info = coll.get(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", info.getId().toString());
                map.put("name", info.getName());
                map.put("value", info.getNumber());
                result.add(map);
            }
        }
        return result;
    }
}

