/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.base.syssetting.DesktopItemCollection;
import com.kingdee.shr.base.syssetting.DesktopItemFactory;
import com.kingdee.shr.base.syssetting.DesktopItemInfo;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"base"})
public class BaseController
extends WebPageController {
    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        modelMap.putAll(UserUtil.getUserInfo(request));
        return "/personalDesktop";
    }

    @RequestMapping(params={"method=getDesktopItems"})
    @Action
    protected String getDesktopItemsAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultSortCode"));
        viewInfo.getSelector().add(new SelectorItemInfo("url"));
        viewInfo.getSelector().add(new SelectorItemInfo("urlType"));
        viewInfo.getSelector().add(new SelectorItemInfo("iconPath"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("category", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.getSorter().add(new SorterItemInfo("defaultSortCode"));
        viewInfo.setSorter(sorter);
        ArrayList list = new ArrayList();
        try {
            DesktopItemCollection collection = DesktopItemFactory.getRemoteInstance().getDesktopItemCollection(viewInfo);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                DesktopItemInfo iteminfo = collection.get(i);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("name", iteminfo.getName());
                data.put("defaultSortCode", iteminfo.getDefaultSortCode());
                data.put("url", iteminfo.getUrl());
                data.put("urlType", iteminfo.getUrlType());
                data.put("iconPath", iteminfo.getIconPath());
                list.add(data);
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
            throw new SHRWebException(e);
        }
        JSONUtils.writeJson(response, list);
        return null;
    }

    @RequestMapping(params={"method=getDesktopItemsIframe"})
    @Action
    protected String getDesktopItemsIframeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String newUrl = request.getParameter("newUrl");
        modelMap.putAll(UserUtil.getUserInfo(request));
        modelMap.put((Object)"newUrl", (Object)newUrl);
        return "/personalDesktopItems";
    }
}

